/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines;

import com.ibm.team.filesystem.common.internal.util.StringUtils;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class GraphicalBaselinesEditorInput
implements IEditorInput {
    public static final String SHOW_GRAPHICAL_BASELINES_PAGE = "/ShowGraphicalBaselines";
    private ITeamRepository fRepo;
    private IComponent fComponent;
    private List<IWorkspace> fWorkspaces;

    public ITeamRepository getRepository() {
        return this.fRepo;
    }

    public void setRepository(ITeamRepository repo) {
        if (repo == null) {
            throw new IllegalStateException(Messages.GraphicalBaselinesEditorInput_RepoMustNotNull);
        }
        this.fRepo = repo;
    }

    public IComponent getComponent() {
        return this.fComponent;
    }

    public void setComponent(IComponent component) {
        if (component == null) {
            throw new IllegalStateException(Messages.GraphicalBaselinesEditorInput_ComponentMustNotNull);
        }
        this.fComponent = component;
    }

    public List<IWorkspace> getWorkspaces() {
        return this.fWorkspaces;
    }

    public void setWorkspaces(List<IWorkspace> workspaces) {
        this.fWorkspaces = workspaces == null ? new ArrayList<IWorkspace>() : workspaces;
    }

    public String getName() {
        if (this.fComponent != null) {
            return NLS.bind((String)Messages.GraphicalBaselinesEditorInput_EditorName_ShowComponentBaselinesMode, (Object)this.fComponent.getName());
        }
        return "";
    }

    public String getToolTipText() {
        if (this.fComponent != null) {
            return NLS.bind((String)Messages.GraphicalBaselinesEditorInput_EditorName_ShowComponentBaselinesMode, (Object)this.fComponent.getName());
        }
        return "";
    }

    public boolean exists() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImagePool.GRAPHICAL_BASELINES;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fRepo == null ? 0 : this.fRepo.getId().hashCode());
        result = 31 * result + (this.fComponent == null ? 0 : this.fComponent.getItemId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphicalBaselinesEditorInput other = (GraphicalBaselinesEditorInput)obj;
        if (this.fRepo == null ? other.fRepo != null : !this.fRepo.getId().equals((Object)other.fRepo.getId())) {
            return false;
        }
        return !(this.fComponent == null ? other.fComponent != null : !this.fComponent.sameItemId((IItemHandle)other.fComponent));
    }

    public String getBaseUri() {
        String uriToFix = this.fRepo.getRepositoryURI();
        if (uriToFix.endsWith("/")) {
            uriToFix = uriToFix.substring(0, uriToFix.length() - 1);
        }
        if (uriToFix.endsWith("/secure")) {
            uriToFix = uriToFix.substring(0, uriToFix.length() - "/secure".length());
        }
        String uri = uriToFix;
        return uri;
    }

    public String getUri(boolean debug, boolean addContext) {
        ArrayList<String> streamIds;
        String embeddedUri = this.getBaseUri();
        embeddedUri = String.valueOf(embeddedUri) + SHOW_GRAPHICAL_BASELINES_PAGE + (debug ? "?debug=true&firebug=true" : "");
        String nl = System.getProperty("osgi.nl");
        if (nl != null) {
            Locale locale = Locale.forLanguageTag(nl.replace('_', '-'));
            embeddedUri = String.valueOf(embeddedUri) + (debug ? "&" : "?");
            embeddedUri = String.valueOf(embeddedUri) + "country=" + locale.getCountry() + "&lang=" + locale.getLanguage();
        }
        IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
        String componentId = this.getComponent().getItemId().getUuidValue();
        embeddedUri = String.valueOf(embeddedUri) + "#componentId=" + this.getComponent().getItemId().getUuidValue();
        String preferredStreamIds = prefStore.getString(UiPlugin.getGraphicalBaselineDefaultStreamsPreferenceKey(this.fRepo.getId().getUuidValue(), componentId));
        ArrayList<String> arrayList = streamIds = !preferredStreamIds.isEmpty() ? new ArrayList<String>(Arrays.asList(preferredStreamIds.split(","))) : new ArrayList();
        if (addContext) {
            for (IWorkspace selectedStream : this.getWorkspaces()) {
                String uuidValue = selectedStream.getItemId().getUuidValue();
                if (streamIds.contains(uuidValue)) continue;
                streamIds.add(uuidValue);
            }
            prefStore.putValue(UiPlugin.getGraphicalBaselineDefaultStreamsPreferenceKey(this.fRepo.getId().getUuidValue(), componentId), StringUtils.join(streamIds, (String)","));
        }
        embeddedUri = String.valueOf(embeddedUri) + "&contextId=" + StringUtils.join(streamIds, (String)",");
        String extraParams = prefStore.getString(UiPlugin.getGraphicalBaselinesPreferenceKey(this.fRepo.getId().getUuidValue(), this.getComponent().getItemId().getUuidValue()));
        if (!extraParams.isEmpty()) {
            embeddedUri = String.valueOf(embeddedUri) + "&" + extraParams;
        }
        return embeddedUri;
    }

    public void doSave(String url) {
        String hash = url.substring(url.indexOf("#"));
        if ((hash = hash.replace("#", "")).isEmpty()) {
            return;
        }
        String[] parameters = hash.split("&");
        if (parameters.length < 2) {
            return;
        }
        String[] componentParm = parameters[0].split("=");
        Assert.isTrue((boolean)componentParm[0].equals("componentId"), (String)"Component ID should be the first parameter.");
        if (componentParm.length != 2) {
            return;
        }
        String componentId = componentParm[1];
        String[] streamParm = parameters[1].split("=");
        Assert.isTrue((boolean)streamParm[0].equals("contextId"), (String)"Context ID should be the second parameter.");
        String streamIds = "";
        if (streamParm.length == 2) {
            streamIds = streamParm[1];
        }
        ITeamRepository repo = this.getRepository();
        IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
        store.putValue(UiPlugin.getGraphicalBaselineDefaultStreamsPreferenceKey(repo.getId().getUuidValue(), componentId), streamIds);
        String[] extra = Arrays.copyOfRange(parameters, 2, parameters.length);
        store.putValue(UiPlugin.getGraphicalBaselinesPreferenceKey(repo.getId().getUuidValue(), componentId), StringUtils.join((String[])extra, (String)"&"));
    }
}

