/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines;

import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.editor.FileSystemEditorToolkit;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines.GraphicalBaselinesEditorInput;
import com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines.GraphicalBaselinesPage;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.parts.PartSiteJobRunner;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.ui.editor.TeamFormEditor;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class GraphicalBaselinesEditor
extends TeamFormEditor {
    public static final String ID = "com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines.GraphicalBaselinesEditor";
    public static final String SYSTEM_PROPERTY_IS_SAVABLE = "com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines.GraphicalBaselinesEditor.enableEditorSaving";
    private PartSiteJobRunner fRunner;
    private ResourceManager fResources;
    private GraphicalBaselinesEditorInput fEditorInput;
    private GraphicalBaselinesPage fGraphicalBaselinesPage;
    private RefreshAction fRefreshAction;
    private CopyURLAction fCopyURLAction;
    private ToggleDebugAction fToggleDebugAction;

    public static void open(IWorkbenchPage page, GraphicalBaselinesEditorInput input) {
        if (page == null) {
            throw new IllegalArgumentException(Messages.GraphicalBaselinesEditor_PageMustNotNull);
        }
        if (input == null) {
            throw new IllegalArgumentException(Messages.GraphicalBaselinesEditor_InputMustNotNull);
        }
        if (UiPlugin.getBooleanPreference("prefs_use_external_browser")) {
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            try {
                String url = input.getUri(false, true);
                browserSupport.getExternalBrowser().openURL(new URL(url));
            }
            catch (PartInitException e1) {
                StatusUtil.log((Object)"com.ibm.team.filesystem.ide.ui", (Throwable)e1);
                return;
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
        try {
            GraphicalBaselinesEditor editor = (GraphicalBaselinesEditor)page.openEditor((IEditorInput)input, ID);
            editor.addContext(input);
        }
        catch (PartInitException e) {
            StatusUtil.log(GraphicalBaselinesEditor.class, (Throwable)e);
        }
    }

    private void addContext(GraphicalBaselinesEditorInput input) {
        if (input == this.fEditorInput) {
            return;
        }
        if (!input.getWorkspaces().isEmpty()) {
            this.fGraphicalBaselinesPage.addContexts(input.getWorkspaces());
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.fEditorInput = (GraphicalBaselinesEditorInput)input;
        this.addToolbarActions(site);
    }

    private void addToolbarActions(IEditorSite site) {
        boolean shouldAddCopyURLAction;
        IToolBarManager toolbarManager = site.getActionBars().getToolBarManager();
        if (this.fRefreshAction == null) {
            this.fRefreshAction = new RefreshAction();
        }
        if (this.fToggleDebugAction == null) {
            this.fToggleDebugAction = new ToggleDebugAction();
        }
        if ((shouldAddCopyURLAction = false) && this.fCopyURLAction == null) {
            this.fCopyURLAction = new CopyURLAction();
        }
        if (toolbarManager.find("com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines.GraphicalBaselinesEditor.actions.GlobalMenu") == null) {
            toolbarManager.add((IAction)new AddDropDownAction());
        }
        toolbarManager.update(true);
    }

    protected FormToolkit createToolkit(Display display) {
        return new FileSystemEditorToolkit(UiPlugin.getDefault().getSharedFormColors(display));
    }

    protected Composite createPageContainer(final Composite parent) {
        final Display display = parent.getDisplay();
        this.fResources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.fRunner = new PartSiteJobRunner(this.getSite(), false){

            protected boolean reportProblem(final String opName, Operation op, final IStatus reason) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!parent.isDisposed()) {
                            IStatus adjustedReason = reason;
                            ErrorDialog.openError((Shell)GraphicalBaselinesEditor.this.getSite().getShell(), (String)NLS.bind((String)Messages.GraphicalBaselinesEditor_ErrorDuringMessage, (Object)opName), null, (IStatus)adjustedReason);
                        }
                    }
                });
                return false;
            }
        };
        this.setTitleImage(this.fResources.createImageWithDefault(ImagePool.GRAPHICAL_BASELINES));
        this.setPartName(this.fEditorInput.getName());
        return super.createPageContainer(parent);
    }

    protected void addPages() {
        try {
            this.fGraphicalBaselinesPage = new GraphicalBaselinesPage(this, this.fEditorInput, (IOperationRunner)this.fRunner);
            this.addPage((IFormPage)this.fGraphicalBaselinesPage);
        }
        catch (PartInitException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
        }
    }

    protected void createPages() {
        if (this.getContainer() instanceof CTabFolder) {
            CTabFolder tabFolder = (CTabFolder)this.getContainer();
            tabFolder.setTabHeight(0);
        }
        super.createPages();
    }

    public void setFocus() {
        super.setFocus();
        if (this.fGraphicalBaselinesPage != null) {
            this.fGraphicalBaselinesPage.setFocus();
        }
    }

    public boolean isDirty() {
        return this.fGraphicalBaselinesPage.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
        this.fGraphicalBaselinesPage.doSave(monitor);
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        if (this.fRunner != null) {
            this.fRunner.dispose();
            this.fRunner = null;
        }
        super.dispose();
    }

    protected void fireDirtyStateChanged() {
        this.firePropertyChange(257);
    }

    private class AddDropDownAction
    extends Action {
        public static final String GLOBAL_MENU_ID = "com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines.GraphicalBaselinesEditor.actions.GlobalMenu";

        public AddDropDownAction() {
            super("", 4);
            this.setToolTipText("");
            this.setImageDescriptor(ImagePool.GRAPHICAL_BASELINES);
            this.setMenuCreator(new IMenuCreator(){
                private MenuManager dropDownMenuMgr;

                private void createDropDownMenuMgr() {
                    if (this.dropDownMenuMgr == null) {
                        this.dropDownMenuMgr = new MenuManager();
                        if (GraphicalBaselinesEditor.this.fRefreshAction != null) {
                            this.dropDownMenuMgr.add((IAction)GraphicalBaselinesEditor.this.fRefreshAction);
                        }
                        if (GraphicalBaselinesEditor.this.fCopyURLAction != null) {
                            this.dropDownMenuMgr.add((IAction)GraphicalBaselinesEditor.this.fCopyURLAction);
                        }
                        if (GraphicalBaselinesEditor.this.fToggleDebugAction != null) {
                            this.dropDownMenuMgr.add((IAction)GraphicalBaselinesEditor.this.fToggleDebugAction);
                        }
                    }
                }

                public Menu getMenu(Control parent) {
                    this.createDropDownMenuMgr();
                    final Menu menu = this.dropDownMenuMgr.createContextMenu(parent);
                    menu.addMenuListener((MenuListener)new MenuAdapter(){

                        public void menuShown(MenuEvent e) {
                            RefreshAction defaultAction = GraphicalBaselinesEditor.this.fRefreshAction;
                            if (defaultAction != null) {
                                MenuItem[] items;
                                MenuItem[] menuItemArray = items = menu.getItems();
                                int n = items.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    ActionContributionItem actionItem;
                                    MenuItem item = menuItemArray[n2];
                                    if (item != null && item.getData() != null && item.getData() instanceof ActionContributionItem && ((Object)((Object)defaultAction)).equals((actionItem = (ActionContributionItem)item.getData()).getAction())) {
                                        menu.setDefaultItem(item);
                                        break;
                                    }
                                    ++n2;
                                }
                            }
                        }
                    });
                    return menu;
                }

                public Menu getMenu(Menu parent) {
                    this.createDropDownMenuMgr();
                    Menu menu = new Menu(parent);
                    IContributionItem[] items = this.dropDownMenuMgr.getItems();
                    int i = 0;
                    while (i < items.length) {
                        IContributionItem item;
                        IContributionItem newItem = item = items[i];
                        if (item instanceof ActionContributionItem) {
                            newItem = new ActionContributionItem(((ActionContributionItem)item).getAction());
                        }
                        newItem.fill(menu, -1);
                        ++i;
                    }
                    return menu;
                }

                public void dispose() {
                    if (this.dropDownMenuMgr != null) {
                        this.dropDownMenuMgr.dispose();
                        this.dropDownMenuMgr = null;
                    }
                }
            });
        }

        public void run() {
            GraphicalBaselinesEditor.this.fRefreshAction.run();
        }

        public String getId() {
            return GLOBAL_MENU_ID;
        }
    }

    private class CopyURLAction
    extends Action {
        public static final String COPY_URL_ACTION_ID = "com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines.GraphicalBaselinesEditor.actions.CopyURLAction";

        public CopyURLAction() {
            super(Messages.GraphicalBaselinesEditor_CopyUrlAction, 1);
            this.setImageDescriptor(ImagePool.COPY_URL);
        }

        public void run() {
            IEditorPart activeEditor;
            IWorkbenchPage activePage;
            IWorkbenchPartSite partSite = GraphicalBaselinesEditor.this.getSite();
            if (partSite != null && (activePage = partSite.getWorkbenchWindow().getActivePage()) != null && (activeEditor = activePage.getActiveEditor()) instanceof GraphicalBaselinesEditor) {
                ((GraphicalBaselinesEditor)activeEditor).fGraphicalBaselinesPage.copyUrl();
            }
        }

        public boolean equals(Object obj) {
            return obj.getClass() == ((Object)((Object)this)).getClass();
        }

        public String getId() {
            return COPY_URL_ACTION_ID;
        }
    }

    private class RefreshAction
    extends Action {
        public static final String REFRESH_ACTION_ID = "com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines.GraphicalBaselinesEditor.actions.RefreshAction";

        public RefreshAction() {
            super(Messages.GraphicalBaselinesEditor_RefreshAction, 1);
            this.setImageDescriptor(ImagePool.REFRESH_ICON);
        }

        public void run() {
            IEditorPart activeEditor;
            IWorkbenchPage activePage;
            IWorkbenchPartSite partSite = GraphicalBaselinesEditor.this.getSite();
            if (partSite != null && (activePage = partSite.getWorkbenchWindow().getActivePage()) != null && (activeEditor = activePage.getActiveEditor()) instanceof GraphicalBaselinesEditor) {
                ((GraphicalBaselinesEditor)activeEditor).fGraphicalBaselinesPage.refresh();
            }
        }

        public boolean equals(Object obj) {
            return obj.getClass() == ((Object)((Object)this)).getClass();
        }

        public String getId() {
            return REFRESH_ACTION_ID;
        }
    }

    private class ToggleDebugAction
    extends Action {
        public static final String TOGGLE_DEBUG_ACTION_ID = "com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines.GraphicalBaselinesEditor.actions.ToggleDebugAction";

        public ToggleDebugAction() {
            super(Messages.GraphicalBaselinesEditor_ToggleDebugAction, 2);
            this.setImageDescriptor(ImagePool.TOGGLE_DEBUG_MODE);
        }

        public void run() {
            IEditorPart activeEditor;
            IWorkbenchPage activePage;
            IWorkbenchPartSite partSite = GraphicalBaselinesEditor.this.getSite();
            if (partSite != null && (activePage = partSite.getWorkbenchWindow().getActivePage()) != null && (activeEditor = activePage.getActiveEditor()) instanceof GraphicalBaselinesEditor) {
                ((GraphicalBaselinesEditor)activeEditor).fGraphicalBaselinesPage.toggleDebug();
            }
        }

        public boolean equals(Object obj) {
            return obj.getClass() == ((Object)((Object)this)).getClass();
        }

        public String getId() {
            return TOGGLE_DEBUG_ACTION_ID;
        }
    }
}

