/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.decorators;

import com.ibm.team.filesystem.ui.wrapper.HierarchyData;
import com.ibm.team.filesystem.ui.wrapper.IConfigurationWrapper;
import com.ibm.team.filesystem.ui.wrapper.IHierarchicalComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.InaccessibleBaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.MissingWorkspaceComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentHierarchyNode;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;

public class HierarchicalComponentDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public static final String ID = "com.ibm.team.internal.filesystem.ui.decorators.HierarchicalComponentDecorator";

    public void decorate(Object element, IDecoration decoration) {
        HierarchyData<IComponentHierarchyNode, IComponentHandle, IHierarchicalComponentWrapper> hierarchyData;
        IConfigurationWrapper<IComponentHierarchyNode, IComponentHandle, IHierarchicalComponentWrapper> wrapper;
        if (element instanceof MissingWorkspaceComponentWrapper || element instanceof InaccessibleBaselineWrapper) {
            decoration.addOverlay(ImagePool.PRESENCE_OFFLINE_OVRL);
            Color color = JFaceResources.getColorRegistry().get("com.ibm.team.internal.filesystem.ui.ColorDefinitions.COMPONENT_HIERARCHY_MISSING_COMPONENT");
            if (color != null) {
                decoration.setForegroundColor(color);
            }
        } else if (element instanceof WorkspaceComponentWrapper && ((WorkspaceComponentWrapper)(wrapper = (WorkspaceComponentWrapper)element)).getHierarchyData() != null) {
            try {
                boolean existsInWorkspace = false;
                for (Object o : ((WorkspaceComponentWrapper)wrapper).getWorkspaceConnection().getComponents()) {
                    IComponentHandle component;
                    if (!(o instanceof IComponentHandle) || !(component = (IComponentHandle)o).sameItemId((IItemHandle)((WorkspaceComponentWrapper)wrapper).getComponent())) continue;
                    existsInWorkspace = true;
                    break;
                }
                if (!existsInWorkspace) {
                    decoration.addOverlay(ImagePool.PRESENCE_OFFLINE_OVRL);
                    Color color = JFaceResources.getColorRegistry().get("com.ibm.team.internal.filesystem.ui.ColorDefinitions.COMPONENT_HIERARCHY_MISSING_COMPONENT");
                    if (color != null) {
                        decoration.setForegroundColor(color);
                    }
                }
            }
            catch (TeamRepositoryException existsInWorkspace) {
                // empty catch block
            }
        }
        if (element instanceof IConfigurationWrapper && (hierarchyData = (wrapper = (IConfigurationWrapper)element).getHierarchyData()) != null) {
            IComponentHierarchyNode hierarcyNode = hierarchyData.getHierarchyNode();
            IHierarchicalComponentWrapper parentWrapper = hierarchyData.getParent();
            if (hierarchyData.isBranchContainsCycles() && !hierarchyData.isInCycle()) {
                decoration.addOverlay(ImagePool.COMPONENT_SUBHIERARCHY_CYCLE_OVRL);
            }
            if (hierarcyNode.isInCycle()) {
                if (hierarcyNode.getAncestorPath().contains(hierarchyData.getHierarchyNode().getElementHandle().getItemId())) {
                    decoration.addOverlay(ImagePool.COMPONENT_HIERARCHY_CYCLE_ABOVE_OVRL);
                } else if (hierarchyData.isRoot() || parentWrapper != null && parentWrapper.getHierarchyData() != null && !parentWrapper.getHierarchyData().isInCycle()) {
                    decoration.addOverlay(ImagePool.COMPONENT_HIERARCHY_CYCLE_BELOW_OVRL);
                } else {
                    decoration.addOverlay(ImagePool.COMPONENT_HIERARCHY_CYCLE_OVRL);
                }
                Color color = JFaceResources.getColorRegistry().get("com.ibm.team.internal.filesystem.ui.ColorDefinitions.COMPONENT_HIERARCHY_CYCLE");
                if (color != null) {
                    decoration.setForegroundColor(color);
                }
            }
        }
    }
}

