/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.decorators;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ICopyFileAreaEvent;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IFileStorageVisitor;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreEvent;
import com.ibm.team.filesystem.client.internal.utils.IgnoreUtils;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.ComponentSyncInfo;
import com.ibm.team.filesystem.rcp.core.internal.changes.locks.UserLockCache;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IBaselineGroup;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalChangeSource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.resources.IRepositoryProviderMappingEvent;
import com.ibm.team.filesystem.rcp.core.internal.resources.RepositoryProviderChangeNotifier;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.adapters.AbstractAdaptableRemoteResource;
import com.ibm.team.internal.filesystem.ui.decorators.AbstractDecoratorSourceFactory;
import com.ibm.team.internal.filesystem.ui.decorators.ChangesTree;
import com.ibm.team.internal.filesystem.ui.decorators.ChangesTreeEntry;
import com.ibm.team.internal.filesystem.ui.decorators.ConnectionComponentNameManager;
import com.ibm.team.internal.filesystem.ui.decorators.DecorationDescriptor;
import com.ibm.team.internal.filesystem.ui.decorators.ExceptionCollector;
import com.ibm.team.internal.filesystem.ui.decorators.ShareRootEntry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.ui.PlatformUI;

public class GenericLightDecorator
extends LabelProvider
implements ILightweightLabelDecorator,
IPropertyChangeListener,
IListener,
ICopyFileAreaListener {
    private static final String DECORATOR_SOURCE_CLASS = "class";
    private static final String EP_DECORATOR_SOURCE = "com.ibm.team.filesystem.ide.ui.decoratorSource";
    public static final boolean DEBUG = "true".equals(System.getProperty("GenericLightDecoratorDebug", ""));
    private final DateFormat DATE_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    public static final String ID = "com.ibm.team.filesystem.decorator";
    private static ExceptionCollector exceptions = new ExceptionCollector("Exceptions decorating", "com.ibm.team.filesystem.ide.ui", 4, UiPlugin.getDefault().getLog());
    private static final int SCHEDULING_DELAY = 1000;
    private Object treeLock = new Object();
    private ChangesTree<ChangesTreeEntry> changesTree = new ChangesTree();
    private ChangesTree<ShareRootEntry> shareRootTree = new ChangesTree();
    private Job updateDecoratorsJob = new UpdateDecoratorsJob();
    private UpdateIgnoreJob updateIgnoreJob = new UpdateIgnoreJob();
    private UpdateSharesJob updateSharesJob = new UpdateSharesJob();
    private static Object factoriesLock = new Object();
    private static Collection<AbstractDecoratorSourceFactory> factories = null;

    private long D(Object ... msg) {
        long t = 0L;
        if (DEBUG) {
            t = System.currentTimeMillis();
            Date date = new Date(t);
            System.out.print("[GLD] ");
            System.out.print(this.DATE_FORMAT.format(date));
            System.out.print(" - ");
            int i = 0;
            while (i < msg.length) {
                if (msg[i] instanceof ResourceMapping) {
                    ResourceMapping mapping = (ResourceMapping)msg[i];
                    try {
                        ResourceTraversal[] traversals = mapping.getTraversals(null, (IProgressMonitor)TempHelper.MONITOR);
                        if (traversals.length > 1) {
                            System.out.print('<');
                            System.out.print(traversals.length);
                            System.out.print(" traversals>");
                        } else {
                            ResourceTraversal[] resourceTraversalArray = mapping.getTraversals(null, (IProgressMonitor)TempHelper.MONITOR);
                            int n = resourceTraversalArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ResourceTraversal trav = resourceTraversalArray[n2];
                                IResource[] iResourceArray = trav.getResources();
                                int n3 = iResourceArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IResource r = iResourceArray[n4];
                                    System.out.print(r);
                                    ++n4;
                                }
                                ++n2;
                            }
                        }
                    }
                    catch (CoreException e) {
                        System.out.println("Exception during debug");
                        e.printStackTrace();
                    }
                } else {
                    System.out.print(msg[i]);
                }
                ++i;
            }
            System.out.println();
        }
        return t;
    }

    public GenericLightDecorator() {
        FileSystemCore.getSharingManager().addListener((ICopyFileAreaListener)this);
        this.addSyncModelListener();
        TeamUI.addPropertyChangeListener((IPropertyChangeListener)this);
        SharingManager.getInstance().getIgnoreManager().addGenericListener((Object[])IIgnoreEvent.ALL_EVENTS, (IListener)this.updateIgnoreJob);
        UserLockCache.get().addGenericListener((Object)"lock", (IListener)this);
        RepositoryProviderChangeNotifier.getInstance().addGenericListener((Object)"map", (IListener)this);
        RepositoryProviderChangeNotifier.getInstance().addGenericListener((Object)"unmap", (IListener)this);
        this.updateDecoratorsJob.schedule();
        this.updateSharesJob.schedule();
    }

    private void addSyncModelListener() {
        IComponentSyncModel syncModel = FileSystemResourcesPlugin.getComponentSyncModel();
        syncModel.addGenericListener((Object)"refreshedRemoteCompleted", (IListener)this);
        syncModel.addGenericListener((Object)"shareablesChangedRefreshed", (IListener)this);
    }

    private void removeSyncModelListener() {
        IComponentSyncModel syncModel = FileSystemResourcesPlugin.getComponentSyncModel();
        syncModel.removeGenericListener((IListener)this);
    }

    private static RepositoryProvider getProviderFor(IResource resource) {
        return RepositoryProvider.getProvider((IProject)resource.getProject(), (String)"com.ibm.team.filesystem.rcp.core.provider");
    }

    private static IResource getResource(Object object) {
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable) {
            return (IResource)((IAdaptable)object).getAdapter(IResource.class);
        }
        return null;
    }

    private boolean isRemoteResourceInteresting(AbstractAdaptableRemoteResource remoteResource) {
        return true;
    }

    private boolean isObjectInteresting(Object element) {
        if (element instanceof ResourceMapping) {
            return this.isResourceMappingInteresting((ResourceMapping)element);
        }
        if (element instanceof AbstractAdaptableRemoteResource) {
            return this.isRemoteResourceInteresting((AbstractAdaptableRemoteResource)element);
        }
        return false;
    }

    public void decorate(Object element, IDecoration decoration) {
        block4: {
            this.D("Decorating: ", element);
            if (!(element instanceof ResourceMapping) && !(element instanceof AbstractAdaptableRemoteResource)) {
                return;
            }
            if (!this.isObjectInteresting(element)) {
                return;
            }
            try {
                DecorationDescriptor interimDecoration = this.decorate(element);
                interimDecoration.apply(decoration);
            }
            catch (IllegalStateException e) {
                if (Platform.getBundle((String)"com.ibm.team.filesystem.client").getState() != 32) break block4;
                throw e;
            }
        }
    }

    private static boolean isIResourceInteresting(IResource resource) {
        return resource != null && resource.getType() != 8;
    }

    private boolean isResourceMappingInteresting(ResourceMapping mapping) {
        ResourceTraversal[] traversals;
        if (mapping == null) {
            return false;
        }
        IProject[] projects = mapping.getProjects();
        int i = 0;
        while (i < projects.length) {
            RepositoryProvider provider = GenericLightDecorator.getProviderFor((IResource)projects[i]);
            if (provider != null) {
                return true;
            }
            ++i;
        }
        try {
            traversals = mapping.getTraversals(null, (IProgressMonitor)TempHelper.MONITOR);
        }
        catch (CoreException e) {
            StatusUtil.log((Object)"com.ibm.team.filesystem.client", (String)"Couldn't get traversals", (Throwable)e);
            return false;
        }
        ResourceTraversal[] resourceTraversalArray = traversals;
        int n = traversals.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceTraversal traversal = resourceTraversalArray[n2];
            IResource[] iResourceArray = traversal.getResources();
            int n3 = iResourceArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IProject proj;
                IPath targetPath;
                IResource resource = iResourceArray[n4];
                if (resource.isLinked(512) && (targetPath = this.findWorkspaceLinkPath(resource)) != null && GenericLightDecorator.getProviderFor((IResource)(proj = ResourcesPlugin.getWorkspace().getRoot().getProject(targetPath.segment(0)))) != null) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    private IPath findWorkspaceLinkPath(IResource resource) {
        assert (resource.isLinked(512));
        IPath absolute = resource.getLocation();
        if (absolute == null) {
            return null;
        }
        IPath wsRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (wsRoot.isPrefixOf(absolute)) {
            return absolute.removeFirstSegments(wsRoot.segmentCount());
        }
        return null;
    }

    private ITraversalWrapper[] getTraversals(Object element) throws CoreException {
        if (element instanceof ResourceMapping) {
            ResourceTraversal[] traversals = ((ResourceMapping)element).getTraversals(null, (IProgressMonitor)TempHelper.MONITOR);
            ITraversalWrapper[] wrappers = new ResourceTraversalWrapper[traversals.length];
            int i = 0;
            while (i < traversals.length) {
                wrappers[i] = new ResourceTraversalWrapper(traversals[i]);
                ++i;
            }
            return wrappers;
        }
        if (element instanceof AbstractAdaptableRemoteResource) {
            return new ITraversalWrapper[]{new RemoteTraversalWrapper((AbstractAdaptableRemoteResource)element)};
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DecorationDescriptor decorate(Object element) {
        DecorationDescriptor decoration = new DecorationDescriptor();
        IResource resource = element instanceof ResourceMapping ? GenericLightDecorator.getResource(((ResourceMapping)element).getModelObject()) : null;
        boolean hasRemote = false;
        IShareable shareable = null;
        try {
            if (element instanceof ResourceMapping) {
                if (resource != null) {
                    decoration.setResourceType(resource.getType());
                    if (!resource.exists()) {
                        return decoration;
                    }
                    shareable = (IShareable)resource.getAdapter(IShareable.class);
                    if (shareable == null) {
                        return decoration;
                    }
                    hasRemote = shareable.getRemote((IProgressMonitor)TempHelper.MONITOR) != null;
                } else {
                    decoration.setResourceType(1000);
                }
            } else {
                AbstractAdaptableRemoteResource remoteResource = (AbstractAdaptableRemoteResource)element;
                shareable = (IShareable)remoteResource.getAdapter(IShareable.class);
                ResourceType rType = remoteResource.getType();
                if (rType == null || shareable == null) {
                    return decoration;
                }
                if (rType == ResourceType.FILE) {
                    decoration.setResourceType(1);
                } else if (rType == ResourceType.FOLDER) {
                    decoration.setResourceType(2);
                }
                hasRemote = shareable.getRemote((IProgressMonitor)TempHelper.MONITOR) != null;
            }
            ITraversalWrapper[] traversals = this.getTraversals(element);
            boolean isIgnored = false;
            boolean dirty = false;
            boolean outgoing = false;
            boolean incoming = false;
            boolean conflicting = false;
            boolean teamConflicting = false;
            boolean addition = false;
            boolean isShareRoot = false;
            int i = 0;
            while (i < traversals.length) {
                ChangesTree<ShareRootEntry> shareRootTree;
                ChangesTree<ChangesTreeEntry> changesTree;
                int depth = traversals[i].getDepth();
                Object[] resources = traversals[i].getInterestingResources();
                Object object = this.treeLock;
                synchronized (object) {
                    changesTree = this.changesTree;
                    shareRootTree = this.shareRootTree;
                }
                int j = 0;
                while (j < resources.length) {
                    block37: {
                        IShareable s;
                        AbstractAdaptableRemoteResource adaptFrom;
                        IRelativeLocation decorateAs;
                        block38: {
                            AbstractAdaptableRemoteResource remoteResource;
                            block34: {
                                block36: {
                                    IResource thisIResource;
                                    block35: {
                                        decorateAs = null;
                                        adaptFrom = null;
                                        if (!(resources[j] instanceof IResource)) break block34;
                                        thisIResource = (IResource)resources[j];
                                        if (!thisIResource.isLinked(512)) break block35;
                                        IPath targetPath = this.findWorkspaceLinkPath(thisIResource);
                                        if (targetPath != null && (decorateAs = GenericLightDecorator.pathToRelativeLocation(targetPath)) != null) break block36;
                                        break block37;
                                    }
                                    decorateAs = GenericLightDecorator.pathToRelativeLocation(thisIResource.getFullPath());
                                }
                                adaptFrom = ResourcesPlugin.getWorkspace().getRoot().findMember(decorateAs.toPath());
                                break block38;
                            }
                            adaptFrom = remoteResource = (AbstractAdaptableRemoteResource)resources[j];
                            s = (IShareable)remoteResource.getAdapter(IShareable.class);
                            if (s != null) {
                                decorateAs = s.getLocalPath();
                            }
                        }
                        ILocation sandbox = null;
                        if (adaptFrom != null && (s = (IShareable)adaptFrom.getAdapter(IShareable.class)) != null) {
                            isIgnored |= s.shouldBeIgnored((IProgressMonitor)TempHelper.MONITOR);
                            hasRemote |= s.getRemote((IProgressMonitor)TempHelper.MONITOR) != null;
                            ISandbox sb = s.getSandbox();
                            sandbox = sb.getRoot();
                        }
                        if (decorateAs != null && sandbox != null) {
                            ShareRootEntry shareRoot;
                            ChangesTreeEntry state = changesTree.getEntry(sandbox, decorateAs);
                            if (state != null) {
                                addition |= state.isAddition();
                                switch (depth) {
                                    case 0: {
                                        dirty |= state.isSelfDirty();
                                        outgoing |= state.isSelfOutgoing();
                                        incoming |= state.isSelfIncoming();
                                        conflicting |= state.isSelfConflicting();
                                        teamConflicting |= state.isSelfTeamConflicting();
                                        break;
                                    }
                                    case 1: {
                                        dirty |= state.isShallowDirty();
                                        outgoing |= state.isShallowOutgoing();
                                        incoming |= state.isShallowIncoming();
                                        conflicting |= state.isShallowConflicting();
                                        teamConflicting |= state.isShallowTeamConflicting();
                                        break;
                                    }
                                    default: {
                                        dirty |= state.isDirty();
                                        outgoing |= state.isOutgoing();
                                        incoming |= state.isIncoming();
                                        conflicting |= state.isConflicting();
                                        teamConflicting |= state.isTeamConflicting();
                                    }
                                }
                            }
                            if ((shareRoot = shareRootTree.getEntry(sandbox, decorateAs)) != null) {
                                IShare share = shareRoot.getShare();
                                if (share == null) {
                                    decoration.setSharedDescendents(shareRoot.getDescendentShareCount());
                                } else {
                                    ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
                                    if (sharingDescriptor != null) {
                                        isShareRoot = true;
                                        decoration.setWorkspaceName(GenericLightDecorator.getConnectionName(sharingDescriptor));
                                        decoration.setComponentName(GenericLightDecorator.getComponentName(sharingDescriptor));
                                        ITeamRepository repository = RepositoryUtils.getTeamRepositoryById((UUID)sharingDescriptor.getRepositoryId());
                                        if (repository != null) {
                                            decoration.setRepository(repository.getRepositoryURI());
                                        }
                                    }
                                }
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
            if (addition) {
                decoration.setAdded(true);
            } else {
                decoration.setHasRemote(hasRemote);
            }
            decoration.setIgnored(isIgnored);
            decoration.setDirty(dirty);
            decoration.setOutgoing(outgoing);
            decoration.setIncoming(incoming);
            decoration.setConflicting(conflicting);
            decoration.setTeamConflicting(teamConflicting);
            decoration.setShareRoot(isShareRoot);
            if (shareable != null) {
                UserLockCache.LockInfo info = UserLockCache.get().getLock(shareable);
                IContributor owner = info != null ? info.owner : null;
                IWorkspace target = info != null ? info.stream.getResolvedWorkspace() : null;
                decoration.setLockInfo(owner, target);
            }
        }
        catch (TeamRepositoryException e) {
            StatusUtil.log(GenericLightDecorator.class, (Throwable)e);
        }
        catch (CoreException e) {
            StatusUtil.log(GenericLightDecorator.class, (Throwable)e);
        }
        return decoration;
    }

    public static void refresh() {
        if (Display.getCurrent() != null) {
            PlatformUI.getWorkbench().getDecoratorManager().update(ID);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PlatformUI.getWorkbench().getDecoratorManager().update(GenericLightDecorator.ID);
                }
            });
        }
    }

    public void refresh(IProject project) {
        if (!project.isAccessible()) {
            this.postLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this, new Object[]{project}));
            return;
        }
        final ArrayList resources = new ArrayList();
        try {
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) {
                    resources.add(resource);
                    return true;
                }
            });
            this.postLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this, resources.toArray()));
        }
        catch (CoreException e) {
            GenericLightDecorator.handleException(e);
        }
    }

    private void postLabelEvent(final LabelProviderChangedEvent event) {
        Object[] elts = event.getElements();
        this.D("postLabelEvent for ", elts == null ? "<all>" : Integer.toString(elts.length), " elements");
        boolean DEBUG = false;
        if (DEBUG) {
            int i = 0;
            while (i < event.getElements().length) {
                if (!((IResource)event.getElements()[i]).exists()) {
                    throw new IllegalArgumentException();
                }
                ++i;
            }
        }
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GenericLightDecorator.this.fireLabelProviderChanged(event);
                }
            });
        }
    }

    public void dispose() {
        super.dispose();
        TeamUI.removePropertyChangeListener((IPropertyChangeListener)this);
        this.removeSyncModelListener();
        FileSystemCore.getSharingManager().removeListener((ICopyFileAreaListener)this);
        UserLockCache.get().removeGenericListener((Object)"lock", (IListener)this);
        RepositoryProviderChangeNotifier.getInstance().purgeTypedListener((Object)this);
    }

    private static void handleException(CoreException e) {
        exceptions.handleException(e);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.isEventOfInterest(event)) {
            GenericLightDecorator.refresh();
        }
    }

    private boolean isEventOfInterest(PropertyChangeEvent event) {
        String prop = event.getProperty();
        return prop.equals("org.eclipse.team.uiglobal_ignores_changed") || prop.equals("org.eclipse.team.uiglobal_file_types_changed");
    }

    private static IRelativeLocation getIDEPath(IShareable shareable) {
        if (shareable.getSandbox().getRoot() instanceof PathLocation) {
            return ((Shareable)shareable).getFileStorage().getIDEPath();
        }
        return shareable.getLocalPath();
    }

    private void computeChanges(IComponentSyncContext context, IActivitySource source, boolean isIncoming, IComponentHandle component, IContextHandle connection, Map<ItemKey, ResourceConflict> conflicts, IProgressMonitor monitor) {
        boolean reverse = isIncoming;
        ArrayList<IRemoteActivity> changesets = new ArrayList<IRemoteActivity>(source.getActivities());
        for (IBaselineGroup bg : source.getBaselines()) {
            changesets.addAll(bg.getActivities());
        }
        Map<UUID, List<IRemoteChangeSummary>> itemChanges = GenericLightDecorator.getItemChangesMap(changesets, reverse);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)itemChanges.size());
        ISharingManager sharingManager = FileSystemCore.getSharingManager();
        for (List<IRemoteChangeSummary> summaries : itemChanges.values()) {
            Collection shareables;
            IVersionableHandle item = summaries.get(0).getItem();
            try {
                shareables = sharingManager.findShareables(connection, component, item, (IProgressMonitor)progress.newChild(1));
            }
            catch (FileSystemException e) {
                StatusUtil.log((Object)"com.ibm.team.filesystem.ide.ui", (String)("Couldn't get shareable for " + item.getItemId()), null);
                continue;
            }
            for (IShareable shareable : shareables) {
                ItemKey key = new ItemKey(item, component, connection, shareable.getSandbox());
                ResourceConflict conflict = conflicts.get(key);
                if (conflict == null) {
                    conflict = new ResourceConflict();
                    conflicts.put(key, conflict);
                    conflict.isFile = item instanceof IFileItemHandle;
                    conflict.sandboxRoot = key.sandbox.getRoot();
                    conflict.path = GenericLightDecorator.getIDEPath(shareable);
                }
                if (!conflict.conflicting) {
                    for (IRemoteChangeSummary summary : summaries) {
                        if (!context.isUnresolved(summary)) continue;
                        conflict.conflicting = true;
                        break;
                    }
                }
                if (conflict.path == null && conflict.parent == null) {
                    for (IRemoteChangeSummary summary : summaries) {
                        IFolderHandle parent = summary.getChangeSummary().parent();
                        if (parent == null) continue;
                        conflict.parent = parent;
                        conflict.name = summary.getResourceName();
                        break;
                    }
                }
                if (isIncoming) {
                    conflict.incoming = true;
                    continue;
                }
                conflict.outgoing = true;
            }
        }
        progress.done();
    }

    private void computeLocalChanges(IComponentSyncContext context, IComponentHandle component, IContextHandle connection, Map<ItemKey, ResourceConflict> conflicts) {
        ILocalChangeSource localSource = context.getLocalChangeSource();
        List localChanges = localSource.getLocalChanges();
        for (ILocalChange localChange : localChanges) {
            IShareable shareable = localChange.getShareable();
            if (shareable == null) continue;
            ItemKey key = new ItemKey(localChange.getTarget(), component, connection, shareable.getSandbox());
            ResourceConflict conflict = conflicts.get(key);
            if (conflict == null) {
                conflict = new ResourceConflict();
                conflicts.put(key, conflict);
                conflict.isFile = localChange.getTarget() instanceof IFileItemHandle;
                conflict.sandboxRoot = key.sandbox.getRoot();
                conflict.path = GenericLightDecorator.getIDEPath(shareable);
            }
            conflict.pendingLocal = true;
            ResourceConflict resourceConflict = conflict;
            resourceConflict.isAddition = resourceConflict.isAddition | localChange.isType(2);
        }
    }

    private void resolvePaths(Map<ItemKey, ResourceConflict> conflicts, IProgressMonitor monitor) {
        boolean progress;
        LinkedHashMap<ItemKey, ResourceConflict> unresolved = new LinkedHashMap<ItemKey, ResourceConflict>();
        Iterator<Map.Entry<ItemKey, ResourceConflict>> i = conflicts.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<ItemKey, ResourceConflict> e = i.next();
            ResourceConflict conflict = e.getValue();
            if (conflict.path != null) continue;
            if (conflict.parent == null) {
                i.remove();
                continue;
            }
            unresolved.put(e.getKey(), conflict);
        }
        HashMap resolvedPaths = new HashMap();
        HashSet<UUID> unresolvedPaths = new HashSet<UUID>();
        SubMonitor progressMon = SubMonitor.convert((IProgressMonitor)monitor, (int)unresolved.size());
        do {
            progress = false;
            Iterator i2 = unresolved.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry e = i2.next();
                ResourceConflict conflict = (ResourceConflict)e.getValue();
                ItemKey key = (ItemKey)e.getKey();
                ItemKey parentKey = new ItemKey((IVersionableHandle)conflict.parent, key.component, key.connection, key.sandbox);
                ResourceConflict parentConflict = conflicts.get(parentKey);
                if (parentConflict != null) {
                    if (parentConflict.path == null) continue;
                    conflict.path = parentConflict.path.append(conflict.name);
                    i2.remove();
                    progress = true;
                    continue;
                }
                IRelativeLocation parentPath = (IRelativeLocation)resolvedPaths.get(conflict.parent.getItemId());
                if (parentPath == null && !unresolvedPaths.contains(conflict.parent.getItemId())) {
                    try {
                        IShareable shareable = key.sandbox.findShareable(key.connection, key.component, (IVersionableHandle)conflict.parent, (IProgressMonitor)progressMon.newChild(1));
                        if (shareable != null) {
                            parentPath = shareable.getLocalPath();
                        } else {
                            unresolvedPaths.add(conflict.parent.getItemId());
                        }
                    }
                    catch (FileSystemException ex) {
                        StatusUtil.log((Object)((Object)this), (Throwable)ex);
                    }
                }
                if (parentPath != null) {
                    conflict.path = parentPath.append(conflict.name);
                    progress = true;
                } else {
                    conflicts.remove(key);
                }
                i2.remove();
            }
        } while (progress);
        conflicts.keySet().removeAll(unresolved.keySet());
        progressMon.done();
    }

    private void updateParents(ChangesTreeEntry entry, ILocation sandboxRoot, IRelativeLocation path, ChangesTree<ChangesTreeEntry> tree) {
        int segmentCount = path.segmentCount();
        if (segmentCount == 0) {
            return;
        }
        IRelativeLocation parentPath = path.removeLastSegments(1);
        List<ChangesTreeEntry> entries = tree.getEntryPath(sandboxRoot, parentPath);
        boolean isOutgoing = entry.isOutgoing();
        boolean isIncoming = entry.isIncoming();
        boolean isDirty = entry.isDirty();
        boolean isConflicting = entry.isConflicting();
        boolean isTeamConflicting = entry.isTeamConflicting();
        boolean isFile = entry.isFile();
        ChangesTreeEntry parentEntry = entries.get(segmentCount - 1);
        boolean isShallowOutgoing = false;
        boolean isShallowIncoming = false;
        boolean isShallowDirty = false;
        boolean isShallowConflicting = false;
        boolean isShallowTeamConflicting = false;
        boolean allowNoChange = false;
        if (parentEntry == null) {
            allowNoChange = true;
            parentEntry = new ChangesTreeEntry();
            tree.addEntry(sandboxRoot, parentPath, parentEntry);
            entries.set(segmentCount - 1, parentEntry);
        } else if (isFile) {
            isShallowOutgoing = parentEntry.isShallowOutgoing();
            isShallowIncoming = parentEntry.isShallowIncoming();
            isShallowDirty = parentEntry.isShallowDirty();
            isShallowConflicting = parentEntry.isShallowConflicting();
            isShallowTeamConflicting = parentEntry.isShallowTeamConflicting();
        }
        if (isFile) {
            parentEntry.setShallowOutgoing(isShallowOutgoing |= entry.isSelfOutgoing());
            parentEntry.setShallowIncoming(isShallowIncoming |= entry.isSelfIncoming());
            parentEntry.setShallowDirty(isShallowDirty |= entry.isSelfDirty());
            parentEntry.setShallowConflicting(isShallowConflicting |= entry.isSelfConflicting());
            parentEntry.setShallowTeamConflicting(isShallowTeamConflicting |= entry.isSelfTeamConflicting());
        }
        int i = segmentCount - 1;
        while (i >= 0) {
            ChangesTreeEntry oldEntry;
            ChangesTreeEntry ancestorEntry = entries.get(i);
            if (ancestorEntry == null) {
                oldEntry = ChangesTreeEntry.EMPTY;
                ancestorEntry = new ChangesTreeEntry();
                tree.addEntry(sandboxRoot, path.removeLastSegments(segmentCount - i), ancestorEntry);
            } else {
                oldEntry = ancestorEntry.copy();
                isOutgoing |= ancestorEntry.isOutgoing();
                isIncoming |= ancestorEntry.isIncoming();
                isDirty |= ancestorEntry.isDirty();
                isConflicting |= ancestorEntry.isConflicting();
                isTeamConflicting |= ancestorEntry.isTeamConflicting();
            }
            ancestorEntry.setOutgoing(isOutgoing);
            ancestorEntry.setIncoming(isIncoming);
            ancestorEntry.setDirty(isDirty);
            ancestorEntry.setConflicting(isConflicting);
            ancestorEntry.setTeamConflicting(isTeamConflicting);
            if (oldEntry.equals(ancestorEntry) && !allowNoChange) break;
            allowNoChange = false;
            --i;
        }
    }

    public void handleEvents(List events) {
        boolean shouldUpdate = false;
        for (IEvent event : events) {
            this.D("received generic event, reason: ", event.getEventType());
            if (event.getEventType().equals("lock")) {
                GenericLightDecorator.refresh();
                continue;
            }
            boolean syncModelChange = this.isSyncModelChange(event);
            if (!syncModelChange) continue;
            this.D("-> Interesting!");
            shouldUpdate = true;
            break;
        }
        ArrayList<IProject> toNotify = null;
        for (IEvent candidate : events) {
            if (!(candidate instanceof IRepositoryProviderMappingEvent)) continue;
            IRepositoryProviderMappingEvent event = (IRepositoryProviderMappingEvent)candidate;
            if (toNotify == null) {
                toNotify = new ArrayList<IProject>();
            }
            toNotify.add(event.getProject());
        }
        if (toNotify != null) {
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, toNotify.toArray()));
        }
        if (shouldUpdate) {
            this.D("Scheduling update due to generic event");
            this.updateDecoratorsJob.schedule(1000L);
        }
    }

    private boolean isSyncModelChange(IEvent event) {
        IEventSource eventSource = event.getEventSource();
        if (eventSource instanceof IComponentSyncContext) {
            IComponentSyncContext context = (IComponentSyncContext)eventSource;
            if (context.isLocal()) {
                ComponentSyncInfo info = context.getComponentSyncInfo();
                if (context.getComponentSyncModel().getLocalSynchronizationManager().isShared((IWorkspaceHandle)info.getLocalWorkspaceConnection().getResolvedWorkspace(), (IComponentHandle)info.getComponent())) {
                    return true;
                }
            }
            return false;
        }
        if (eventSource instanceof ILocalChangeSource) {
            return "shareablesChangedRefreshed".equals(event.getEventType());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recomputeChanges(IProgressMonitor monitor) {
        ChangesTree<ChangesTreeEntry> oldTree;
        Object conn;
        ChangesTree<ChangesTreeEntry> startTree;
        IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
        if (model == null) {
            return;
        }
        long start = this.D("Starting recomputeChanges");
        Object object = this.treeLock;
        synchronized (object) {
            startTree = this.changesTree;
        }
        IComponentSyncContext[] contexts = model.getComponentSyncContexts();
        HashMap<ItemKey, ResourceConflict> newConflicts = new HashMap<ItemKey, ResourceConflict>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        SubMonitor subProgress = progress.newChild(70);
        subProgress.setWorkRemaining(contexts.length * 2);
        int i = 0;
        while (i < contexts.length) {
            IComponentSyncContext context = contexts[i];
            conn = context.getOutgoingConnection();
            Object connectionHandle = conn instanceof IBaselineConnection ? ((IBaselineConnection)conn).getBaseline() : (IWorkspaceHandle)((IWorkspaceConnection)conn).getResolvedWorkspace().getItemHandle();
            IComponentHandle component = (IComponentHandle)context.getComponent().getItemHandle();
            this.computeLocalChanges(context, component, (IContextHandle)connectionHandle, newConflicts);
            this.computeChanges(context, (IActivitySource)context.getOutgoingActivitySource(), false, component, (IContextHandle)connectionHandle, newConflicts, (IProgressMonitor)subProgress.newChild(1));
            this.computeChanges(context, (IActivitySource)context.getIncomingActivitySource(), true, component, (IContextHandle)connectionHandle, newConflicts, (IProgressMonitor)subProgress.newChild(1));
            ++i;
        }
        subProgress.done();
        this.resolvePaths(newConflicts, (IProgressMonitor)progress.newChild(30));
        ChangesTree<ChangesTreeEntry> newTree = new ChangesTree<ChangesTreeEntry>();
        for (ResourceConflict conflict : newConflicts.values()) {
            boolean isOutgoing = conflict.outgoing;
            boolean isIncoming = conflict.incoming;
            boolean isDirty = conflict.pendingLocal;
            boolean isConflicting = conflict.conflicting;
            boolean isTeamConflicting = isIncoming && (isOutgoing || isDirty);
            boolean isFile = conflict.isFile;
            boolean isAddition = conflict.isAddition;
            ChangesTreeEntry entry = (ChangesTreeEntry)newTree.getEntry(conflict.sandboxRoot, conflict.path);
            if (entry != null) {
                if (!isOutgoing && !isDirty) {
                    if (entry.isSelfDirty() || entry.isSelfOutgoing()) {
                        isTeamConflicting = true;
                    }
                } else if ((isDirty || isOutgoing) && !entry.isSelfOutgoing() && !entry.isSelfDirty() && entry.isSelfIncoming()) {
                    isTeamConflicting = true;
                }
                isOutgoing |= entry.isSelfOutgoing();
                isIncoming |= entry.isSelfIncoming();
                isDirty |= entry.isSelfDirty();
                isConflicting |= entry.isSelfConflicting();
                isTeamConflicting |= entry.isSelfTeamConflicting();
                isFile |= entry.isFile();
            } else {
                entry = new ChangesTreeEntry();
                newTree.addEntry(conflict.sandboxRoot, conflict.path, entry);
            }
            entry.setSelfOutgoing(isOutgoing);
            entry.setSelfIncoming(isIncoming);
            entry.setSelfDirty(isDirty);
            entry.setSelfConflicting(isConflicting);
            entry.setSelfTeamConflicting(isTeamConflicting);
            entry.setFile(isFile);
            entry.setAddition(isAddition);
            entry.setShallowOutgoing(isOutgoing | entry.isShallowOutgoing());
            entry.setShallowIncoming(isIncoming | entry.isShallowIncoming());
            entry.setShallowDirty(isDirty | entry.isShallowDirty());
            entry.setShallowConflicting(isConflicting | entry.isShallowConflicting());
            entry.setShallowTeamConflicting(isTeamConflicting | entry.isShallowTeamConflicting());
            entry.setOutgoing(isOutgoing | entry.isOutgoing());
            entry.setIncoming(isIncoming | entry.isIncoming());
            entry.setDirty(isDirty | entry.isDirty());
            entry.setConflicting(isConflicting | entry.isConflicting());
            entry.setTeamConflicting(isTeamConflicting | entry.isTeamConflicting());
            this.updateParents(entry, conflict.sandboxRoot, conflict.path, newTree);
        }
        conn = this.treeLock;
        synchronized (conn) {
            oldTree = this.changesTree;
            if (oldTree != startTree) {
                StatusUtil.log((Object)((Object)this), (String)"Two GenericLightDecorator update jobs are running concurrently!");
            }
            this.changesTree = newTree;
        }
        Map<ILocation, List<IRelativeLocation>> changedPaths = oldTree.diff(newTree);
        for (Map.Entry<ILocation, List<IRelativeLocation>> changed : changedPaths.entrySet()) {
            if (changed.getValue().isEmpty()) continue;
            List<Object> modifiedResources = this.getResources(changed.getKey(), changed.getValue());
            this.postLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this, modifiedResources.toArray()));
        }
        progress.done();
        this.D("Done recomputeChanges (", changedPaths.size(), " changes, ", System.currentTimeMillis() - start, "ms)");
    }

    protected void recomputeIgnore(Collection<IShareable> roots, SubMonitor subMonitor) throws FileSystemException {
        final LinkedList toRefresh = new LinkedList();
        subMonitor.beginTask(Messages.GenericLightDecorator_18, roots.size());
        for (IShareable shareable : roots) {
            ((Shareable)shareable).getFileStorage().accept(new IFileStorageVisitor(){

                public boolean visit(IFileStorage storage, IProgressMonitor monitor) {
                    Shareable shareable = storage.getShareable();
                    IResource resource = (IResource)shareable.getAdapter(IResource.class);
                    if (resource == null) {
                        return false;
                    }
                    toRefresh.add(resource);
                    return true;
                }
            }, Integer.MAX_VALUE, (IProgressMonitor)subMonitor.newChild(1));
        }
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, toRefresh.toArray()));
    }

    private static IRelativeLocation pathToRelativeLocation(IPath path) {
        return new RelativeLocation(path.segments());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recomputeShareRoots(IProgressMonitor progress) {
        ILocation sandboxRoot;
        Object share2;
        IShare[] shares;
        ChangesTree<ShareRootEntry> startTree;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)5);
        Object object = this.treeLock;
        synchronized (object) {
            startTree = this.shareRootTree;
        }
        ChangesTree<ShareRootEntry> newTree = new ChangesTree<ShareRootEntry>();
        try {
            shares = SharingManager.getInstance().allShares((IProgressMonitor)monitor.newChild(4));
        }
        catch (FileSystemException e) {
            StatusUtil.log(GenericLightDecorator.class, (Throwable)e);
            return;
        }
        monitor.setWorkRemaining(shares.length);
        ArrayList<IShare> outside = new ArrayList<IShare>(shares.length);
        IShare[] iShareArray = shares;
        int n = shares.length;
        int n2 = 0;
        while (n2 < n) {
            share2 = iShareArray[n2];
            IShareable shareRoot = share2.getShareable();
            ILocation rootLocation = shareRoot.getFullPath();
            IResource root = (IResource)shareRoot.getAdapter(IResource.class);
            if (root == null && rootLocation instanceof PathLocation) {
                outside.add((IShare)share2);
            } else {
                IRelativeLocation idePath = null;
                idePath = root != null ? GenericLightDecorator.pathToRelativeLocation(root.getFullPath()) : shareRoot.getLocalPath();
                if (idePath != null) {
                    ShareRootEntry entry = new ShareRootEntry();
                    entry.setShare((IShare)share2);
                    sandboxRoot = share2.getSandbox().getRoot();
                    newTree.addEntry(sandboxRoot, idePath, entry);
                    IRelativeLocation parentPath = idePath.removeLastSegments(1);
                    while (parentPath.segmentCount() > 0) {
                        ShareRootEntry parentEntry = (ShareRootEntry)newTree.getEntry(sandboxRoot, parentPath);
                        if (parentEntry == null) {
                            parentEntry = new ShareRootEntry();
                            newTree.addEntry(sandboxRoot, parentPath, parentEntry);
                        }
                        parentEntry.incrementDescendentShareCount();
                        parentPath = parentPath.removeLastSegments(1);
                    }
                }
            }
            ++n2;
        }
        for (Object share2 : outside) {
            ILocation shareRoot = share2.getShareable().getFullPath();
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n3 = iProjectArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IProject project = iProjectArray[n4];
                IPath projectRoot = project.getLocation();
                if (projectRoot != null && shareRoot.isPrefixOf((ILocation)new PathLocation(projectRoot))) {
                    IRelativeLocation projLocation = GenericLightDecorator.pathToRelativeLocation(project.getFullPath());
                    sandboxRoot = share2.getSandbox().getRoot();
                    ShareRootEntry entry = (ShareRootEntry)newTree.getEntry(sandboxRoot, projLocation);
                    if (entry == null) {
                        entry = new ShareRootEntry();
                        newTree.addEntry(sandboxRoot, projLocation, entry);
                    }
                    entry.setShare((IShare)share2);
                    entry.setBelowShareRoot(true);
                }
                ++n4;
            }
        }
        share2 = this.treeLock;
        synchronized (share2) {
            this.shareRootTree = newTree;
        }
        Map<ILocation, List<IRelativeLocation>> diff = startTree.diff(newTree);
        for (Map.Entry<ILocation, List<IRelativeLocation>> entry : diff.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            List<Object> modifiedResources = this.getResources(entry.getKey(), entry.getValue());
            this.postLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this, modifiedResources.toArray()));
        }
        monitor.done();
    }

    private List<Object> getResources(ILocation sandboxLocation, List<IRelativeLocation> paths) {
        ArrayList<Object> resources = new ArrayList<Object>(paths.size());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        for (IRelativeLocation path : paths) {
            if (sandboxLocation instanceof PathLocation) {
                IResource resource = root.findMember(path.toPath());
                if (resource == null) continue;
                URI uri = resource.getLocationURI();
                if (uri != null) {
                    if (resource instanceof IContainer) {
                        Collections.addAll(resources, root.findContainersForLocationURI(uri));
                        continue;
                    }
                    if (!(resource instanceof IFile)) continue;
                    Collections.addAll(resources, root.findFilesForLocationURI(uri));
                    continue;
                }
                resources.add(resource);
                continue;
            }
            Collection<AbstractDecoratorSourceFactory> factories = GenericLightDecorator.getDecoratorSourceFactories();
            for (AbstractDecoratorSourceFactory factory : factories) {
                Object source = factory.getDecoratorSource(sandboxLocation.append(path));
                if (source == null) continue;
                resources.add(source);
            }
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<AbstractDecoratorSourceFactory> getDecoratorSourceFactories() {
        Object object = factoriesLock;
        synchronized (object) {
            if (factories != null) {
                return factories;
            }
            factories = new ArrayList<AbstractDecoratorSourceFactory>();
            IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EP_DECORATOR_SOURCE);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    AbstractDecoratorSourceFactory factory = (AbstractDecoratorSourceFactory)element.createExecutableExtension(DECORATOR_SOURCE_CLASS);
                    factories.add(factory);
                }
                catch (CoreException e) {
                    StatusUtil.log((Object)"com.ibm.team.filesystem.ide.ui", (String)e.getMessage(), (Throwable)e);
                }
                ++n2;
            }
            return factories;
        }
    }

    private static Map<UUID, List<IRemoteChangeSummary>> getItemChangesMap(List<IRemoteActivity> changesets, boolean reverse) {
        if (reverse) {
            Collections.reverse(changesets);
        }
        HashMap<UUID, List<IRemoteChangeSummary>> itemChanges = new HashMap<UUID, List<IRemoteChangeSummary>>();
        for (IRemoteActivity activity : changesets) {
            List changes = activity.getChanges();
            for (IRemoteChangeSummary summary : changes) {
                UUID itemId = summary.getItem().getItemId();
                ArrayList<IRemoteChangeSummary> summaries = (ArrayList<IRemoteChangeSummary>)itemChanges.get(itemId);
                if (summaries == null) {
                    summaries = new ArrayList<IRemoteChangeSummary>();
                    itemChanges.put(itemId, summaries);
                }
                summaries.add(summary);
            }
        }
        return itemChanges;
    }

    public void change(ICopyFileAreaEvent[] events) {
        boolean shouldUpdate = false;
        int i = 0;
        while (i < events.length) {
            ICopyFileAreaEvent event = events[i];
            this.D("Received CFA event, reason: ", event.getReason(), "  path:", event.getPath());
            switch (event.getReason()) {
                case 1: 
                case 2: {
                    IResource resource;
                    if (event.getPath() != null && event.getCopyFileAreaRoot() instanceof PathLocation && event.getPath().segmentCount() >= 1 && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember(event.getPath().getName())) != null && resource.exists() && resource instanceof IProject) {
                        this.D("Refreshing project due to CFA event: ", resource);
                        this.refresh((IProject)resource);
                        this.D("Refreshing project done (queued): ", resource);
                    }
                    shouldUpdate = true;
                }
            }
            ++i;
        }
        if (shouldUpdate) {
            this.D("Scheduling update due to CFA event");
            this.updateDecoratorsJob.schedule(1000L);
            this.updateSharesJob.schedule(1000L);
        }
    }

    public static String getConnectionName(ISharingDescriptor sharingDescriptor) {
        return ConnectionComponentNameManager.getInstance().getConnectionName(sharingDescriptor);
    }

    public static String getComponentName(ISharingDescriptor sharingDescriptor) {
        return ConnectionComponentNameManager.getInstance().getComponentName(sharingDescriptor);
    }

    private static interface ITraversalWrapper {
        public int getDepth();

        public Object[] getInterestingResources();
    }

    private static class ItemKey {
        private final IVersionableHandle item;
        private final IComponentHandle component;
        private final IContextHandle connection;
        private final ISandbox sandbox;

        public ItemKey(IVersionableHandle item, IComponentHandle component, IContextHandle connection, ISandbox sandbox) {
            this.item = item;
            this.component = component;
            this.connection = connection;
            this.sandbox = sandbox;
        }

        public int hashCode() {
            return this.item.getItemId().hashCode() ^ this.component.getItemId().hashCode() ^ this.connection.getItemId().hashCode() ^ this.sandbox.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ItemKey)) {
                return false;
            }
            ItemKey other = (ItemKey)obj;
            return other.item.sameItemId((IItemHandle)this.item) && other.component.sameItemId((IItemHandle)this.component) && other.connection.sameItemId((IItemHandle)this.connection) && this.sandbox.equals(other.sandbox);
        }
    }

    private class RemoteTraversalWrapper
    implements ITraversalWrapper {
        private final AbstractAdaptableRemoteResource remote;

        public RemoteTraversalWrapper(AbstractAdaptableRemoteResource remote) {
            this.remote = remote;
        }

        @Override
        public int getDepth() {
            return 2;
        }

        @Override
        public Object[] getInterestingResources() {
            if (GenericLightDecorator.this.isRemoteResourceInteresting(this.remote)) {
                return new Object[]{this.remote};
            }
            return new Object[0];
        }
    }

    private static class ResourceConflict {
        private ILocation sandboxRoot;
        private IRelativeLocation path;
        private IFolderHandle parent;
        private String name;
        private boolean outgoing;
        private boolean incoming;
        private boolean pendingLocal;
        private boolean conflicting;
        private boolean isFile;
        private boolean isAddition;

        private ResourceConflict() {
        }
    }

    private class ResourceTraversalWrapper
    implements ITraversalWrapper {
        private final ResourceTraversal wrappedTraversal;

        ResourceTraversalWrapper(ResourceTraversal traversal) {
            this.wrappedTraversal = traversal;
        }

        @Override
        public int getDepth() {
            return this.wrappedTraversal.getDepth();
        }

        @Override
        public Object[] getInterestingResources() {
            IResource[] resources = this.wrappedTraversal.getResources();
            ArrayList<IResource> interestingResources = new ArrayList<IResource>(resources.length);
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource r = iResourceArray[n2];
                if (GenericLightDecorator.isIResourceInteresting(r)) {
                    interestingResources.add(r);
                }
                ++n2;
            }
            return interestingResources.toArray();
        }
    }

    private class UpdateDecoratorsJob
    extends Job {
        public UpdateDecoratorsJob() {
            super(Messages.GenericLightDecorator_3);
            this.setPriority(50);
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            GenericLightDecorator.this.recomputeChanges(monitor);
            return Status.OK_STATUS;
        }
    }

    private class UpdateIgnoreJob
    extends Job
    implements IListener {
        private LinkedList<IIgnoreEvent> events;

        public UpdateIgnoreJob() {
            super(Messages.GenericLightDecorator_4);
            this.events = new LinkedList();
            this.setPriority(50);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor progress) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
            ArrayList<IIgnoreEvent> toRefresh = new ArrayList<IIgnoreEvent>();
            while (true) {
                LinkedList<IIgnoreEvent> linkedList = this.events;
                synchronized (linkedList) {
                    monitor.setWorkRemaining(3);
                    if (this.events.isEmpty()) {
                        break;
                    }
                    toRefresh.addAll(this.events);
                    this.events.clear();
                }
                try {
                    MultiStatus errors = new MultiStatus("com.ibm.team.filesystem.client", -1, "Errors occurred while computing decoration for ignore events", null);
                    List updateRoots = IgnoreUtils.findShareablesToRefresh(toRefresh, (MultiStatus)errors, (IProgressMonitor)monitor.newChild(1));
                    GenericLightDecorator.this.recomputeIgnore(updateRoots, monitor.newChild(1));
                    if (errors.getChildren().length <= 0) continue;
                    StatusUtil.log((IStatus)errors);
                }
                catch (FileSystemException e) {
                    StatusUtil.log((Object)"com.ibm.team.filesystem.ide.ui", (String)"Exception while computing decoration for ignore events", (Throwable)e);
                }
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvents(List newEvents) {
            LinkedList<IIgnoreEvent> linkedList = this.events;
            synchronized (linkedList) {
                for (IEvent event : newEvents) {
                    this.events.add((IIgnoreEvent)event);
                }
            }
            this.schedule();
        }
    }

    private class UpdateSharesJob
    extends Job {
        public UpdateSharesJob() {
            super(Messages.GenericLightDecorator_SHARE_ROOT_DECORATOR);
            this.setPriority(50);
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            GenericLightDecorator.this.recomputeShareRoots(monitor);
            return Status.OK_STATUS;
        }
    }
}

