/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.decorators;

import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.decorators.DecoratorConfiguration;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IWorkspace;
import java.util.HashMap;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.PlatformUI;

public class DecorationDescriptor {
    private static final String TEXT_PROCESSOR_DELIMITERS = "()[]";
    private String prefix;
    private String suffix;
    private ImageDescriptor overlay;
    private ImageDescriptor overlayTopLeft;
    private ImageDescriptor underlay;
    private Color bkgColor;
    private Color fgColor;
    private Font font;
    public static final int MODEL = 1000;
    private int resourceType = 1;
    private boolean isDirty = false;
    private boolean isOutgoing = false;
    private boolean isIncoming = false;
    private boolean isConflicting = false;
    private boolean isTeamConflicting = false;
    private boolean isIgnored = false;
    private boolean isAdded = false;
    private boolean isNewResource = false;
    private boolean hasRemote = false;
    private String revision;
    private String repository;
    private String workspaceName;
    private String componentName;
    private int descendentShareCount;
    private IContributor lockOwner;
    private IWorkspace lockTarget;
    private String fileFormatter;
    private String folderFormatter;
    private String projectFormatter;
    private String modelFormatter;
    private Preferences preferences;
    private boolean isShareRoot = false;

    public DecorationDescriptor() {
        Preferences prefs = new Preferences();
        prefs.setValue("pref_show_ignored", true);
        prefs.setValue("pref_show_hasremote", true);
        prefs.setValue("pref_show_overlayincoming", true);
        prefs.setValue("pref_show_overlayoutgoing", true);
        prefs.setValue("pref_show_overlayconflict", true);
        prefs.setValue("pref_show_overlayteam_conflict", true);
        prefs.setValue("pref_show_overlaydirty", true);
        prefs.setValue("pref_dirty_flag", Messages.DecorationDescriptor_dirtyFlag);
        prefs.setValue("pref_outgoing_flag", Messages.DecorationDescriptor_outgoingFlag);
        prefs.setValue("pref_added_flag", Messages.DecorationDescriptor_addedFlag);
        prefs.setValue("pref_incoming_flag", Messages.DecorationDescriptor_incomingFlag);
        prefs.setValue("pref_incoming_outgoing_flag", Messages.DecorationDescriptor_incomingAndOutgoingFlag);
        prefs.setValue("pref_team_conflict_flag", Messages.DecorationDescriptor_teamConflictFlag);
        prefs.setValue("pref_conflict_flag", Messages.DecorationDescriptor_conflictFlag);
        prefs.setValue("pref_ignore_flag", Messages.DecorationDescriptor_ignoredFlag);
        this.initialize(prefs, "{dirty_flag}{name}{ignore_flag}{lock_flag}", "{dirty_flag}{name}{ignore_flag}{lock_flag}", "{dirty_flag}{name}", "{dirty_flag}{name}");
    }

    private void initialize(Preferences preferences, String fileFormater, String folderFormatter, String projectFormatter, String modelFormatter) {
        this.preferences = preferences;
        this.fileFormatter = fileFormater;
        this.folderFormatter = folderFormatter;
        this.projectFormatter = projectFormatter;
        this.modelFormatter = modelFormatter;
    }

    public void addPrefix(String prefix) {
        this.prefix = this.prefix == null ? prefix : String.valueOf(prefix) + this.prefix;
    }

    public void addSuffix(String suffix) {
        this.suffix = this.suffix == null ? suffix : String.valueOf(this.suffix) + suffix;
    }

    public void setForegroundColor(Color fgColor) {
        this.fgColor = fgColor;
    }

    public void setBackgroundColor(Color bkgColor) {
        this.bkgColor = bkgColor;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getBackgroundColor() {
        return this.bkgColor;
    }

    public Color getForegroundColor() {
        return this.fgColor;
    }

    public Font getFont() {
        return this.font;
    }

    public ImageDescriptor getOverlay() {
        return this.overlay;
    }

    public ImageDescriptor getUnderlay() {
        return this.underlay;
    }

    public ImageDescriptor getOverlayTopLeft() {
        return this.overlayTopLeft;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setResourceType(int type) {
        this.resourceType = type;
    }

    public void apply(IDecoration decoration) {
        Font f;
        Color fc;
        Color bc;
        ImageDescriptor underlay;
        ImageDescriptor overlay;
        String prefix;
        this.compute();
        String suffix = this.getSuffix();
        if (suffix != null) {
            decoration.addSuffix(TextProcessor.process((String)suffix, (String)TEXT_PROCESSOR_DELIMITERS));
        }
        if ((prefix = this.getPrefix()) != null) {
            decoration.addPrefix(TextProcessor.process((String)prefix, (String)TEXT_PROCESSOR_DELIMITERS));
        }
        if ((overlay = this.getOverlay()) != null) {
            decoration.addOverlay(overlay);
        }
        if ((underlay = this.getUnderlay()) != null) {
            decoration.addOverlay(underlay, 4);
        }
        if (this.overlayTopLeft != null) {
            decoration.addOverlay(this.overlayTopLeft, 0);
        }
        if ((bc = this.getBackgroundColor()) != null) {
            decoration.setBackgroundColor(bc);
        }
        if ((fc = this.getForegroundColor()) != null) {
            decoration.setForegroundColor(fc);
        }
        if ((f = this.getFont()) != null) {
            decoration.setFont(f);
        }
    }

    public void compute() {
        this.computeText();
        this.overlay = this.computeImage();
        this.overlayTopLeft = this.computeOverlayTopLeft();
        this.underlay = this.computeUnderlay();
    }

    private void computeText() {
        HashMap<String, String> bindings = new HashMap<String, String>();
        if (this.isConflicting()) {
            bindings.put("conflict_flag", this.preferences.getString("pref_conflict_flag"));
        }
        if (this.isTeamConflicting()) {
            bindings.put("team_conflict_flag", this.preferences.getString("pref_team_conflict_flag"));
        }
        if (this.isOutgoing()) {
            bindings.put("outgoing_flag", this.preferences.getString("pref_outgoing_flag"));
        }
        if (this.isIncoming()) {
            bindings.put("incoming_flag", this.preferences.getString("pref_incoming_flag"));
        }
        if (this.isIncoming() && this.isOutgoing()) {
            bindings.put("incoming_outgoing_flag", this.preferences.getString("pref_incoming_outgoing_flag"));
        } else if (this.isIncoming()) {
            bindings.put("incoming_outgoing_flag", this.preferences.getString("pref_incoming_flag"));
        } else if (this.isOutgoing()) {
            bindings.put("incoming_outgoing_flag", this.preferences.getString("pref_outgoing_flag"));
        }
        if (this.isAdded()) {
            bindings.put("added_flag", this.preferences.getString("pref_added_flag"));
        } else if (this.isHasRemote()) {
            bindings.put("revision", this.getRevision());
        }
        if ((this.isTeamConflicting() || this.isConflicting()) && this.preferences.getBoolean("pref_show_conflict_color")) {
            this.setForegroundColor(PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get("pref_conflict_color"));
        }
        if (this.isDirty() && this.preferences.getBoolean("pref_show_dirty_font")) {
            this.setFont(PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().getBold(""));
        }
        if (this.isIgnored() && (this.isIncoming() || this.isOutgoing() || this.isAdded() || this.isTeamConflicting() || this.isConflicting())) {
            bindings.put("ignore_flag", this.preferences.getString("pref_ignore_flag"));
        }
        if (this.lockOwner != null && this.lockTarget != null) {
            ITeamRepository repo = (ITeamRepository)this.lockOwner.getOrigin();
            String value = this.lockOwner.sameItemId((IItemHandle)repo.loggedInContributor()) ? NLS.bind((String)Messages.DecorationDescriptor_1, (Object)this.lockTarget.getName()) : NLS.bind((String)Messages.DecorationDescriptor_0, (Object)this.lockOwner.getName(), (Object)this.lockTarget.getName());
            bindings.put("lock_flag", value);
        }
        DecoratorConfiguration.decorate(this, this.getResourceTextFormatter(), bindings);
        if (this.isShareRoot()) {
            bindings.put("host", this.repository);
            bindings.put("user", "");
            bindings.put("workspace_name", this.workspaceName);
            bindings.put("component_name", this.componentName);
            DecoratorConfiguration.decorate(this, "{name} ({workspace_name} - {component_name})", bindings);
        } else if (this.descendentShareCount > 0) {
            bindings.put("shared_descendent_count", NLS.bind((String)Messages.DecorationDescriptor_REMOTE_COMPONENT_LOADED_LOCALLY_COUNT, (Object)Integer.toString(this.descendentShareCount)));
            DecoratorConfiguration.decorate(this, "{name} ({shared_descendent_count})", bindings);
        }
    }

    private ImageDescriptor computeImage() {
        if (this.preferences.getBoolean("pref_show_overlayconflict") && this.isConflicting()) {
            return ImagePool.UNRESOLVED_SMALL_OVRL;
        }
        if (this.preferences.getBoolean("pref_show_overlayteam_conflict") && this.isTeamConflicting()) {
            return ImagePool.TEAM_CONFLICT_SMALL_OVRL;
        }
        if (this.isIncoming() && this.isOutgoing() && this.preferences.getBoolean("pref_show_overlayoutgoing") && this.preferences.getBoolean("pref_show_overlayincoming")) {
            return ImagePool.DECORATION_INOUT_OVRL;
        }
        if (this.preferences.getBoolean("pref_show_overlayoutgoing") && this.isOutgoing()) {
            return ImagePool.DECORATION_OUTGOING_OVRL;
        }
        if (this.preferences.getBoolean("pref_show_overlayincoming") && this.isIncoming()) {
            return ImagePool.DECORATION_INCOMING_OVRL;
        }
        if (this.preferences.getBoolean("pref_show_added") && this.isAdded()) {
            return ImagePool.DECORATION_ADDED_OVRL;
        }
        if (this.preferences.getBoolean("pref_show_ignored") && this.isIgnored()) {
            return ImagePool.DECORATION_IGNORED_OVRL;
        }
        if (this.preferences.getBoolean("pref_show_hasremote") && this.isHasRemote()) {
            return ImagePool.DECORATION_CHECKEDIN_OVRL;
        }
        return null;
    }

    private ImageDescriptor computeOverlayTopLeft() {
        if (this.lockOwner != null && this.lockTarget != null) {
            ITeamRepository repo = (ITeamRepository)this.lockOwner.getOrigin();
            return this.lockOwner.sameItemId((IItemHandle)repo.loggedInContributor()) ? ImagePool.LOCKED_BY_ME_OVRL : ImagePool.LOCKED_BY_OTHER_OVRL;
        }
        return null;
    }

    private ImageDescriptor computeUnderlay() {
        if (this.preferences.getBoolean("pref_show_overlaydirty") && this.isDirty()) {
            return ImagePool.PENDING_LOCAL_OVRL;
        }
        return null;
    }

    private String getResourceTextFormatter() {
        switch (this.resourceType) {
            case 1: {
                return this.fileFormatter;
            }
            case 2: {
                return this.folderFormatter;
            }
            case 4: {
                return this.projectFormatter;
            }
            case 1000: {
                return this.modelFormatter;
            }
        }
        return "no format specified";
    }

    public boolean isAdded() {
        return this.isAdded;
    }

    public void setAdded(boolean isAdded) {
        this.isAdded = isAdded;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public boolean isIncoming() {
        return this.isIncoming;
    }

    public void setIncoming(boolean isIncoming) {
        this.isIncoming = isIncoming;
    }

    public boolean isOutgoing() {
        return this.isOutgoing;
    }

    public void setOutgoing(boolean isOutgoing) {
        this.isOutgoing = isOutgoing;
    }

    public boolean isConflicting() {
        return this.isConflicting;
    }

    public void setConflicting(boolean isConflicting) {
        this.isConflicting = isConflicting;
    }

    public boolean isTeamConflicting() {
        return this.isTeamConflicting;
    }

    public void setTeamConflicting(boolean isTeamConflicting) {
        this.isTeamConflicting = isTeamConflicting;
    }

    public boolean isIgnored() {
        return this.isIgnored;
    }

    public void setIgnored(boolean isIgnored) {
        this.isIgnored = isIgnored;
    }

    public boolean isNewResource() {
        return this.isNewResource;
    }

    public void setNewResource(boolean isNewResource) {
        this.isNewResource = isNewResource;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public boolean isHasRemote() {
        return this.hasRemote;
    }

    public void setHasRemote(boolean hasRemote) {
        this.hasRemote = hasRemote;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public void setLockInfo(IContributor owner, IWorkspace target) {
        this.lockOwner = owner;
        this.lockTarget = target;
    }

    public void setShareRoot(boolean isShareRoot) {
        this.isShareRoot = isShareRoot;
    }

    public boolean isShareRoot() {
        return this.isShareRoot;
    }

    public void setSharedDescendents(int descendentShareCount) {
        this.descendentShareCount = descendentShareCount;
    }
}

