/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.decorators;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

public class ConnectionComponentNameManager
extends Job
implements ITeamRepository.ILoginParticipant,
ISharedItemChangeListener {
    private static ConnectionComponentNameManager instance;
    private Map<UUID, String> names = new HashMap<UUID, String>();
    private List<ISharingDescriptor> updates = new ArrayList<ISharingDescriptor>();
    private Map<UUID, List<ISharingDescriptor>> deferredUpdates = new HashMap<UUID, List<ISharingDescriptor>>();
    private Map<UUID, Map<UUID, IItem>> nameChanges = new HashMap<UUID, Map<UUID, IItem>>();
    private Map<UUID, ITeamRepository> repositories = new HashMap<UUID, ITeamRepository>();

    public static synchronized ConnectionComponentNameManager getInstance() {
        if (instance == null) {
            instance = new ConnectionComponentNameManager();
        }
        return instance;
    }

    public ConnectionComponentNameManager() {
        super(Messages.ConnectionComponentNameManager_0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        while (true) {
            progress.setWorkRemaining(100);
            List<ISharingDescriptor> list = this.updates;
            synchronized (list) {
                try {
                    if (this.updates.isEmpty()) {
                        this.updateDescriptorsIfRequired(progress.newChild(100));
                        this.schedule(1000L);
                        return Status.OK_STATUS;
                    }
                    ArrayList<ISharingDescriptor> toUpdate = new ArrayList<ISharingDescriptor>();
                    toUpdate.addAll(this.updates);
                    this.updates.clear();
                    this.performUpdate(toUpdate, progress.newChild(50));
                }
                catch (TeamRepositoryException e) {
                    LoggingHelper.log((IStatus)FileSystemStatusUtil.getStatusFor((int)2, (String)"An error occurred while attemtping to fetch the latest workspace/component names", (Throwable)e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performUpdate(List<ISharingDescriptor> toUpdate, SubMonitor progress) throws TeamRepositoryException {
        Map<UUID, Object> map;
        HashMap allItemsToFetch = new HashMap();
        HashMap<UUID, String> descriptorNames = new HashMap<UUID, String>();
        for (ISharingDescriptor sharingDescriptor : toUpdate) {
            ITeamRepository repo = this.getRepository(sharingDescriptor);
            if (repo != null && repo.loggedIn()) {
                HashMap<UUID, Object> itemsToFetch = (HashMap<UUID, Object>)allItemsToFetch.get(repo.getId());
                if (itemsToFetch == null) {
                    itemsToFetch = new HashMap<UUID, Object>();
                    allItemsToFetch.put(repo.getId(), itemsToFetch);
                }
                map = this.names;
                synchronized (map) {
                    if (this.names.get(sharingDescriptor.getConnectionHandle().getItemId()) == null) {
                        itemsToFetch.put(sharingDescriptor.getConnectionHandle().getItemId(), sharingDescriptor.getConnectionHandle());
                        descriptorNames.put(sharingDescriptor.getConnectionHandle().getItemId(), sharingDescriptor.getConnectionName());
                    }
                    if (this.names.get(sharingDescriptor.getComponent().getItemId()) == null) {
                        itemsToFetch.put(sharingDescriptor.getComponent().getItemId(), sharingDescriptor.getComponent());
                        descriptorNames.put(sharingDescriptor.getComponent().getItemId(), sharingDescriptor.getComponentName());
                    }
                    continue;
                }
            }
            this.deferUpdate(sharingDescriptor);
        }
        progress.setWorkRemaining(this.repositories.size());
        for (ITeamRepository repo : this.repositories.values()) {
            Map<UUID, IItem> changed;
            Map itemsToFetch = (Map)allItemsToFetch.get(repo.getId());
            if (itemsToFetch == null || (changed = this.fetchNames(repo, itemsToFetch, descriptorNames, progress.newChild(1))).isEmpty()) continue;
            map = this.nameChanges;
            synchronized (map) {
                Map<UUID, IItem> itemChanges = this.nameChanges.get(repo.getId());
                if (itemChanges == null) {
                    itemChanges = new HashMap<UUID, IItem>();
                    this.nameChanges.put(repo.getId(), itemChanges);
                }
                for (IItem item : changed.values()) {
                    itemChanges.put(item.getItemId(), item);
                }
            }
        }
    }

    private ITeamRepository getRepository(ISharingDescriptor sharingDescriptor) {
        ITeamRepository repo = this.repositories.get(sharingDescriptor.getRepositoryId());
        if (repo == null && (repo = RepositoryUtils.getTeamRepositoryById((UUID)sharingDescriptor.getRepositoryId())) != null) {
            repo.addLoginParticipant((ITeamRepository.ILoginParticipant)this);
            repo.itemManager().addItemChangeListener(IComponent.ITEM_TYPE, (ISharedItemChangeListener)this);
            repo.itemManager().addItemChangeListener(IWorkspace.ITEM_TYPE, (ISharedItemChangeListener)this);
            this.repositories.put(repo.getId(), repo);
        }
        return repo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<UUID, IItem> fetchNames(ITeamRepository repo, Map<UUID, IItemHandle> itemsToFetch, Map<UUID, String> descriptorNames, SubMonitor progress) throws TeamRepositoryException {
        IItemManager im = repo.itemManager();
        ArrayList<IItemHandle> handles = new ArrayList<IItemHandle>(itemsToFetch.size());
        handles.addAll(itemsToFetch.values());
        progress.setWorkRemaining(2);
        List result = im.fetchCompleteItems(handles, 0, (IProgressMonitor)progress.newChild(1));
        HashMap<UUID, IItem> changed = new HashMap<UUID, IItem>();
        for (Object object : result) {
            Object storedName;
            String name;
            if (object instanceof IComponent) {
                IComponent component = (IComponent)object;
                name = component.getName();
                Map<UUID, String> map = this.names;
                synchronized (map) {
                    this.names.put(component.getItemId(), name);
                }
                storedName = descriptorNames.get(component.getItemId());
                if (storedName != null && ((String)storedName).equals(name)) continue;
                changed.put(component.getItemId(), (IItem)component);
                continue;
            }
            if (!(object instanceof IWorkspace)) continue;
            IWorkspace workspace = (IWorkspace)object;
            name = workspace.getName();
            storedName = this.names;
            synchronized (storedName) {
                this.names.put(workspace.getItemId(), name);
            }
            storedName = descriptorNames.get(workspace.getItemId());
            if (storedName != null && ((String)storedName).equals(name)) continue;
            changed.put(workspace.getItemId(), (IItem)workspace);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDescriptorsIfRequired(SubMonitor progress) throws FileSystemException {
        HashMap<UUID, Map<UUID, IItem>> changes = new HashMap<UUID, Map<UUID, IItem>>();
        Map<UUID, Map<UUID, IItem>> map = this.nameChanges;
        synchronized (map) {
            for (Map.Entry<UUID, Map<UUID, IItem>> entry : this.nameChanges.entrySet()) {
                changes.put(entry.getKey(), entry.getValue());
            }
            this.nameChanges.clear();
        }
        if (changes.isEmpty()) {
            return;
        }
        Collection allCopyFileAreas = ICopyFileAreaManager.instance.getAllCopyFileAreas();
        progress.setWorkRemaining(1000);
        for (ICopyFileArea cfa : allCopyFileAreas) {
            AbstractLock lock = CFALockUtil.lockExistingForGlobalUpdate((ILocation)cfa.getRoot(), (IProgressMonitor)progress.newChild(1));
            if (lock == null) continue;
            try {
                Collection shares = cfa.allShares();
                for (IShare share : shares) {
                    ISharingDescriptor desc = share.getSharingDescriptor();
                    Map repoChanges = (Map)changes.get(desc.getRepositoryId());
                    String newComponentName = null;
                    String newWorkspaceName = null;
                    if (repoChanges != null) {
                        IItem wi;
                        IItem ci = (IItem)repoChanges.get(desc.getComponent().getItemId());
                        if (ci instanceof IComponent) {
                            IComponent component = (IComponent)ci;
                            newComponentName = component.getName();
                        }
                        if ((wi = (IItem)repoChanges.get(desc.getConnectionHandle().getItemId())) instanceof IWorkspace) {
                            IWorkspace workspace = (IWorkspace)wi;
                            newWorkspaceName = workspace.getName();
                        }
                    }
                    if (!this.isNameChanged(newComponentName, desc.getComponentName()) && !this.isNameChanged(newWorkspaceName, desc.getConnectionName())) continue;
                    SharingDescriptor newDesc = new SharingDescriptor(desc, newWorkspaceName == null ? desc.getConnectionName() : newWorkspaceName, newComponentName == null ? desc.getComponentName() : newComponentName);
                    ((CopyFileArea)cfa).setSharingInfo(share.getPath(), (ISharingDescriptor)newDesc, (IProgressMonitor)progress.newChild(1));
                }
            }
            finally {
                CFALockUtil.endBatching((AbstractLock)lock, (IProgressMonitor)progress.newChild(1));
            }
        }
    }

    private boolean isNameChanged(String newName, String name) {
        return newName != null && (name == null || !newName.equals(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deferUpdate(ISharingDescriptor sharingDescriptor) {
        Map<UUID, List<ISharingDescriptor>> map = this.deferredUpdates;
        synchronized (map) {
            List<ISharingDescriptor> list = this.deferredUpdates.get(sharingDescriptor.getRepositoryId());
            if (list == null) {
                list = new ArrayList<ISharingDescriptor>();
                this.deferredUpdates.put(sharingDescriptor.getRepositoryId(), list);
            }
            if (!list.contains(sharingDescriptor)) {
                list.add(sharingDescriptor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConnectionName(ISharingDescriptor sharingDescriptor) {
        Map<UUID, String> map = this.names;
        synchronized (map) {
            String name = this.names.get(sharingDescriptor.getConnectionHandle().getItemId());
            if (name != null) {
                return name;
            }
        }
        this.requestFetch(sharingDescriptor);
        return sharingDescriptor.getConnectionName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getComponentName(ISharingDescriptor sharingDescriptor) {
        Map<UUID, String> map = this.names;
        synchronized (map) {
            String name = this.names.get(sharingDescriptor.getComponent().getItemId());
            if (name != null) {
                return name;
            }
        }
        this.requestFetch(sharingDescriptor);
        return sharingDescriptor.getComponentName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestFetch(ISharingDescriptor sharingDescriptor) {
        List<ISharingDescriptor> list = this.updates;
        synchronized (list) {
            if (!this.updates.contains(sharingDescriptor)) {
                this.updates.add(sharingDescriptor);
                this.schedule(1000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleLogin(ITeamRepository repository) {
        List<ISharingDescriptor> toUpdate = null;
        Object object = this.deferredUpdates;
        synchronized (object) {
            List<ISharingDescriptor> list = this.deferredUpdates.get(repository.getId());
            if (list != null) {
                toUpdate = list;
                this.deferredUpdates.remove(repository.getId());
            }
        }
        if (toUpdate != null && !toUpdate.isEmpty()) {
            object = this.updates;
            synchronized (object) {
                this.updates.addAll(toUpdate);
                this.schedule(20000L);
            }
        }
    }

    public void handleLogout(ITeamRepository repository) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemsChanged(List events) {
        boolean schedule = false;
        for (Object object : events) {
            Map<UUID, String> map;
            String name;
            if (!(object instanceof ISharedItemChangeEvent)) continue;
            ISharedItemChangeEvent event = (ISharedItemChangeEvent)object;
            IItem item = event.getSharedItem();
            ITeamRepository repo = event.getItemManager().teamRepository();
            Map<UUID, String> map2 = this.names;
            synchronized (map2) {
                name = this.names.get(item.getItemId());
            }
            if (name == null) continue;
            boolean changed = false;
            if (item instanceof IComponent) {
                IComponent component = (IComponent)item;
                boolean bl = changed = !name.equals(component.getName());
                if (changed) {
                    map = this.names;
                    synchronized (map) {
                        this.names.put(item.getItemId(), component.getName());
                    }
                }
            } else if (item instanceof IWorkspace) {
                IWorkspace workspace = (IWorkspace)item;
                boolean bl = changed = !name.equals(workspace.getName());
                if (changed) {
                    map = this.names;
                    synchronized (map) {
                        this.names.put(item.getItemId(), workspace.getName());
                    }
                }
            }
            if (!changed) continue;
            schedule = true;
            Map<UUID, Map<UUID, IItem>> map3 = this.nameChanges;
            synchronized (map3) {
                Map<UUID, IItem> changeItems = this.nameChanges.get(repo.getId());
                if (changeItems == null) {
                    changeItems = new HashMap<UUID, IItem>();
                    this.nameChanges.put(repo.getId(), changeItems);
                }
                changeItems.put(item.getItemId(), item);
            }
        }
        if (schedule) {
            this.schedule(1000L);
        }
    }

    public boolean shouldRun() {
        return !this.updates.isEmpty() || !this.nameChanges.isEmpty();
    }

    public boolean belongsTo(Object family) {
        if (family == ICopyFileAreaManager.instance) {
            return true;
        }
        return super.belongsTo(family);
    }
}

