/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.decorators;

public final class ChangesTreeEntry {
    private static final int CONFLICTING = 1;
    private static final int DIRTY = 2;
    private static final int FILE = 4;
    private static final int INCOMING = 8;
    private static final int OUTGOING = 16;
    private static final int TEAM_CONFLICTING = 32;
    private static final int ADDITION = 64;
    private static final int SELF_CONFLICTING = 256;
    private static final int SELF_DIRTY = 512;
    private static final int SELF_INCOMING = 2048;
    private static final int SELF_OUTGOING = 4096;
    private static final int SELF_TEAM_CONFLICTING = 8192;
    private static final int SHALLOW_CONFLICTING = 65536;
    private static final int SHALLOW_DIRTY = 131072;
    private static final int SHALLOW_INCOMING = 524288;
    private static final int SHALLOW_OUTGOING = 0x100000;
    private static final int SHALLOW_TEAM_CONFLICTING = 0x200000;
    public static ChangesTreeEntry EMPTY = new ChangesTreeEntry();
    private int flags;

    public ChangesTreeEntry copy() {
        ChangesTreeEntry entry = new ChangesTreeEntry();
        entry.flags = this.flags;
        return entry;
    }

    public boolean equals(Object o) {
        if (o instanceof ChangesTreeEntry) {
            ChangesTreeEntry other = (ChangesTreeEntry)o;
            return this.flags == other.flags;
        }
        return false;
    }

    private boolean isBitSet(int bit) {
        return (this.flags & bit) != 0;
    }

    private void setBit(int bit, boolean flag) {
        this.flags = this.flags & ~bit | (flag ? bit : 0);
    }

    public boolean isAddition() {
        return this.isBitSet(64);
    }

    public boolean isConflicting() {
        return this.isBitSet(1);
    }

    public boolean isDirty() {
        return this.isBitSet(2);
    }

    public boolean isFile() {
        return this.isBitSet(4);
    }

    public boolean isIncoming() {
        return this.isBitSet(8);
    }

    public boolean isOutgoing() {
        return this.isBitSet(16);
    }

    public boolean isSelfConflicting() {
        return this.isBitSet(256);
    }

    public boolean isSelfDirty() {
        return this.isBitSet(512);
    }

    public boolean isSelfIncoming() {
        return this.isBitSet(2048);
    }

    public boolean isSelfOutgoing() {
        return this.isBitSet(4096);
    }

    public boolean isSelfTeamConflicting() {
        return this.isBitSet(8192);
    }

    public boolean isShallowConflicting() {
        return this.isBitSet(65536);
    }

    public boolean isShallowDirty() {
        return this.isBitSet(131072);
    }

    public boolean isShallowIncoming() {
        return this.isBitSet(524288);
    }

    public boolean isShallowOutgoing() {
        return this.isBitSet(0x100000);
    }

    public boolean isShallowTeamConflicting() {
        return this.isBitSet(0x200000);
    }

    public boolean isTeamConflicting() {
        return this.isBitSet(32);
    }

    public void setAddition(boolean flag) {
        this.setBit(64, flag);
    }

    public void setConflicting(boolean flag) {
        this.setBit(1, flag);
    }

    public void setDirty(boolean flag) {
        this.setBit(2, flag);
    }

    public void setFile(boolean flag) {
        this.setBit(4, flag);
    }

    public void setIncoming(boolean flag) {
        this.setBit(8, flag);
    }

    public void setOutgoing(boolean flag) {
        this.setBit(16, flag);
    }

    public void setSelfConflicting(boolean flag) {
        this.setBit(256, flag);
    }

    public void setSelfDirty(boolean flag) {
        this.setBit(512, flag);
    }

    public void setSelfIncoming(boolean flag) {
        this.setBit(2048, flag);
    }

    public void setSelfOutgoing(boolean flag) {
        this.setBit(4096, flag);
    }

    public void setSelfTeamConflicting(boolean flag) {
        this.setBit(8192, flag);
    }

    public void setShallowConflicting(boolean flag) {
        this.setBit(65536, flag);
    }

    public void setShallowDirty(boolean flag) {
        this.setBit(131072, flag);
    }

    public void setShallowIncoming(boolean flag) {
        this.setBit(524288, flag);
    }

    public void setShallowOutgoing(boolean flag) {
        this.setBit(0x100000, flag);
    }

    public void setShallowTeamConflicting(boolean flag) {
        this.setBit(0x200000, flag);
    }

    public void setTeamConflicting(boolean flag) {
        this.setBit(32, flag);
    }
}

