/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.decorators;

import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChangesTree<T> {
    private HashMap<ILocation, Node<T>> roots = new HashMap();

    public T getEntry(ILocation sb, IRelativeLocation path) {
        Node<T> currentNode = this.roots.get(sb);
        if (currentNode == null) {
            return null;
        }
        int max = path.segmentCount();
        int i = 0;
        while (i < max) {
            Node<T> child = currentNode.getChild(path.segment(i));
            if (child == null) {
                return null;
            }
            currentNode = child;
            ++i;
        }
        return currentNode.getEntry();
    }

    public List<T> getEntryPath(ILocation sb, IRelativeLocation path) {
        int max = path.segmentCount();
        ArrayList<T> entries = new ArrayList<T>(max + 1);
        Node<T> currentNode = this.roots.get(sb);
        if (currentNode == null) {
            return entries;
        }
        entries.add(currentNode.getEntry());
        int i = 0;
        while (i < max) {
            Node<T> child = currentNode.getChild(path.segment(i));
            if (child == null) {
                return null;
            }
            entries.add(child.getEntry());
            currentNode = child;
            ++i;
        }
        return entries;
    }

    public void addEntry(ILocation sb, IRelativeLocation path, T entry) {
        int max = path.segmentCount();
        Node<T> currentNode = this.roots.get(sb);
        if (currentNode == null) {
            currentNode = new Node();
            this.roots.put(sb, currentNode);
        }
        int i = 0;
        while (i < max) {
            Node<T> child = currentNode.getChild(path.segment(i));
            if (child == null) {
                child = new Node();
                currentNode.addChild(path.segment(i), child);
            }
            currentNode = child;
            ++i;
        }
        currentNode.setEntry(entry);
    }

    public void removeEntry(ISandbox sb, IRelativeLocation path) {
        Node<T> currentNode = this.roots.get(sb);
        if (currentNode == null) {
            return;
        }
        Node<T> root = currentNode;
        int max = path.segmentCount();
        ArrayList<Node<T>> nodes = new ArrayList<Node<T>>(max + 1);
        nodes.add(currentNode);
        int i = 0;
        while (i < max) {
            Node<T> child = currentNode.getChild(path.segment(i));
            if (child == null) {
                return;
            }
            nodes.add(child);
            currentNode = child;
            ++i;
        }
        currentNode.setEntry(null);
        if (currentNode == root || currentNode.hasEntries()) {
            return;
        }
        i = max - 1;
        while (i >= 0) {
            Node parent = (Node)nodes.get(i);
            parent.removeChild(path.segment(i));
            if (parent.hasEntries()) {
                return;
            }
            --i;
        }
    }

    public Map<ILocation, List<IRelativeLocation>> diff(ChangesTree<T> other) {
        int initialSize = this.roots.size() + other.roots.size();
        HashMap<ILocation, List<IRelativeLocation>> allSandboxDiff = new HashMap<ILocation, List<IRelativeLocation>>(initialSize);
        for (ILocation l : this.roots.keySet()) {
            allSandboxDiff.put(l, null);
        }
        for (ILocation l : other.roots.keySet()) {
            allSandboxDiff.put(l, null);
        }
        Node empty = new Node();
        for (ILocation sandboxRoot : allSandboxDiff.keySet()) {
            Node<T> otherNode;
            Node<T> myNode = this.roots.get(sandboxRoot);
            if (myNode == null) {
                myNode = empty;
            }
            if ((otherNode = other.roots.get(sandboxRoot)) == null) {
                otherNode = empty;
            }
            List<IRelativeLocation> diff = ChangesTree.diff(myNode, otherNode);
            allSandboxDiff.put(sandboxRoot, diff);
        }
        return allSandboxDiff;
    }

    private static <T> List<IRelativeLocation> diff(Node<T> mine, Node<T> other) {
        ArrayList<IRelativeLocation> result = new ArrayList<IRelativeLocation>();
        if (mine == other) {
            return result;
        }
        ArrayList myDiffNodes = new ArrayList();
        ArrayList<Node> otherDiffNodes = new ArrayList<Node>();
        ArrayList<Object> paths = new ArrayList<Object>();
        myDiffNodes.add(mine);
        otherDiffNodes.add(other);
        paths.add(RelativeLocation.EMPTY_LOCATION);
        while (!myDiffNodes.isEmpty()) {
            Node myNode = (Node)myDiffNodes.remove(myDiffNodes.size() - 1);
            Node otherNode = (Node)otherDiffNodes.remove(myDiffNodes.size());
            IRelativeLocation path = (IRelativeLocation)paths.remove(myDiffNodes.size());
            if (myNode.getEntry() != null) {
                if (otherNode.getEntry() == null) {
                    result.add(path);
                } else if (!otherNode.getEntry().equals(myNode.getEntry())) {
                    result.add(path);
                }
            } else if (otherNode.getEntry() != null) {
                result.add(path);
            }
            Map myChildren = myNode.getEntries();
            HashMap otherChildren = new HashMap(otherNode.getEntries());
            for (Map.Entry entry : myChildren.entrySet()) {
                Node opposite = (Node)otherChildren.remove(entry.getKey());
                if (opposite != null) {
                    paths.add(path.append(entry.getKey()));
                    myDiffNodes.add(entry.getValue());
                    otherDiffNodes.add(opposite);
                    continue;
                }
                result.addAll(ChangesTree.getAllPaths(path.append(entry.getKey()), entry.getValue()));
            }
            for (Map.Entry<String, Node<Object>> entry : otherChildren.entrySet()) {
                result.addAll(ChangesTree.getAllPaths(path.append(entry.getKey()), entry.getValue()));
            }
        }
        return result;
    }

    public List<IRelativeLocation> debug_getAllPaths(ISandbox sb) {
        return ChangesTree.getAllPaths((IRelativeLocation)RelativeLocation.EMPTY_LOCATION, this.roots.get(sb));
    }

    public String debug_getAllPathsAsString(ISandbox sandbox) {
        StringBuffer sb = new StringBuffer();
        for (IRelativeLocation path : this.debug_getAllPaths(sandbox)) {
            sb.append(path.toString());
            sb.append('\n');
        }
        return sb.toString();
    }

    protected static <T> List<IRelativeLocation> getAllPaths(IRelativeLocation rootPath, Node<T> root) {
        ArrayList toVisit = new ArrayList();
        ArrayList<IRelativeLocation> pathsToVisit = new ArrayList<IRelativeLocation>();
        ArrayList<IRelativeLocation> paths = new ArrayList<IRelativeLocation>();
        toVisit.add(root);
        pathsToVisit.add(rootPath);
        while (!toVisit.isEmpty()) {
            Node node = (Node)toVisit.remove(toVisit.size() - 1);
            IRelativeLocation path = (IRelativeLocation)pathsToVisit.remove(toVisit.size());
            if (node.getEntry() != null) {
                paths.add(path);
            }
            for (Map.Entry e : node.getEntries().entrySet()) {
                toVisit.add(e.getValue());
                pathsToVisit.add(path.append(e.getKey()));
            }
        }
        return paths;
    }

    private static class Node<T> {
        private Map<String, Node<T>> children = new HashMap<String, Node<T>>();
        private T entry;

        public Node<T> getChild(String name) {
            return this.children.get(name);
        }

        public void addChild(String name, Node<T> child) {
            this.children.put(name, child);
        }

        public void removeChild(String name) {
            this.children.remove(name);
        }

        public void setEntry(T entry) {
            this.entry = entry;
        }

        public T getEntry() {
            return this.entry;
        }

        public Map<String, Node<T>> getEntries() {
            return this.children;
        }

        public boolean hasEntries() {
            return !this.children.isEmpty() || this.entry != null;
        }
    }
}

