/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.dashboard;

import com.ibm.team.filesystem.client.internal.namespace.impl.WorkspaceContext;
import com.ibm.team.filesystem.ui.configuration.IHistoryEntry;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.core.HistoryBin;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.dashboard.DelegatingDomainAdapter;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.internal.RepoFetcher;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;

public class HistoryEntryDomainAdapter
extends DelegatingDomainAdapter {
    @Override
    protected Object getDomainElement(Object input) {
        if (input instanceof IHistoryEntry) {
            IHistoryEntry entry = (IHistoryEntry)input;
            return entry.getDomainElement();
        }
        return null;
    }

    @Override
    public void generateContentAsHTML(HashMap head, StringBuffer body, Object input, IDomainAdapter.Info info, IProgressMonitor progress) {
        super.generateContentAsHTML(head, body, input, info, progress);
        if (input instanceof IHistoryEntry) {
            boolean showAddedInformation;
            IHistoryEntry historyEntry = (IHistoryEntry)input;
            String boldStart = "<span style=\"font-weight: bold; \">";
            String boldEnd = "</span>";
            boolean bl = showAddedInformation = historyEntry.getTargetItem() == null && historyEntry.getDynamicContext() instanceof WorkspaceContext;
            if (showAddedInformation) {
                if (historyEntry.getDeliveredBy() != null) {
                    try {
                        IContributor contributor = (IContributor)RepoFetcher.fetchCurrent((ITeamRepository)historyEntry.getRepository(), historyEntry.getDeliveredBy(), (IProgressMonitor)progress);
                        body.append(String.valueOf(boldStart) + Messages.HistoryEntryDomainAdapter_2 + boldEnd + XMLString.createFromPlainText((String)contributor.getName()).getXMLText() + "<br/>");
                    }
                    catch (TeamRepositoryException e) {
                        StatusUtil.log((Object)((Object)this), (Throwable)e);
                    }
                }
                if (historyEntry.getDeliveryTime() != null) {
                    body.append(String.valueOf(boldStart) + Messages.HistoryEntryDomainAdapter_4 + boldEnd + HistoryBin.formatDif((Date)historyEntry.getDeliveryTime(), (boolean)true, (boolean)true) + "<br/>");
                }
            }
        }
    }

    @Override
    public void generateContentAsHTML(HashMap head, StringBuffer body, Object input, IDomainAdapter.Info info) {
        this.generateContentAsHTML(head, body, input, info, null);
    }
}

