/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.dashboard;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.ide.ui.internal.util.TableUtil;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IBaselineGroup;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalChangeSource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISuspendedActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedSource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.CurrentPortNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PortsNode;
import com.ibm.team.filesystem.rcp.core.internal.patches.AbstractStateChangeOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.ApplyHunkOp;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.LabelsUtil;
import com.ibm.team.filesystem.rcp.core.patches.PatchModel;
import com.ibm.team.filesystem.rcp.core.patches.PatchOp;
import com.ibm.team.filesystem.rcp.core.patches.PatchOpHandle;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetInContextWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.PlannedForWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.foundation.rcp.core.HistoryBin;
import com.ibm.team.internal.filesystem.ui.LinkUtils;
import com.ibm.team.internal.filesystem.ui.labelproviders.BaselineLabelProvider;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentDetails;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentDetailsFunction;
import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.preview.HTMLGenerator;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.process.client.IAccessGroupClientService;
import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IReadScopeDescriber;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.ICurrentComponentInfo;
import com.ibm.team.scm.common.dto.IAccessGroupScope;
import com.ibm.team.scm.common.dto.IContributorDeferringScope;
import com.ibm.team.scm.common.dto.IPrivateScope;
import com.ibm.team.scm.common.dto.IProcessAreaScope;
import com.ibm.team.scm.common.dto.IPublicScope;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.dto.ITeamAreaPrivateScope;
import com.ibm.team.scm.common.links.ChangeSetLocationFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class FilesystemHTMLGenerator
extends HTMLGenerator {
    private static final String GENERAL_CSS = "GENERAL_QUERY_CSS";
    private Object object;
    static final String ADD_A_DESCRIPTION = Messages.FilesystemHTMLGenerator_1;

    public FilesystemHTMLGenerator(Object object) {
        ChangeSetInContextWrapper cs = (ChangeSetInContextWrapper)((Object)Adapters.getAdapter((Object)object, ChangeSetInContextWrapper.class));
        this.object = cs != null ? cs : object;
    }

    public static boolean isSupported(Object object) {
        ChangeSetInContextWrapper cs = (ChangeSetInContextWrapper)((Object)Adapters.getAdapter((Object)object, ChangeSetInContextWrapper.class));
        return cs != null;
    }

    protected void createControl(HTMLGenerator.Composite composite, IProgressMonitor monitor) {
        this.createTheControl(composite, monitor);
    }

    protected void createControl(HTMLGenerator.Composite composite) {
        this.createTheControl(composite, null);
    }

    protected void createTheControl(HTMLGenerator.Composite composite, IProgressMonitor progress) {
        if (this.object instanceof WorkspaceComponentWrapper) {
            this.createControlWorkspaceComponentWrapper(composite, (WorkspaceComponentWrapper)this.object, progress);
        }
        if (this.object instanceof ComponentWrapper) {
            this.createControlComponentWrapper(composite, (ComponentWrapper)((Object)this.object), progress);
        }
        if (this.object instanceof AbstractPlaceWrapper) {
            this.createControlAbstractPlaceWrapper(composite, (AbstractPlaceWrapper)((Object)this.object), progress);
        }
        if (this.object instanceof ChangeSetWrapper) {
            this.createControlRemoteActivity(composite, (ChangeSetWrapper)((Object)this.object), progress);
        }
        if (this.object instanceof IWorkspaceSyncContext) {
            this.createControlWorkspaceSyncContext(composite, (IWorkspaceSyncContext)this.object, progress);
        }
        if (this.object instanceof IComponentSyncContext) {
            this.createControlComponentSyncContext(composite, (IComponentSyncContext)this.object, progress);
        }
        if (this.object instanceof IBaselineGroup) {
            this.createControlBaselineGroup(composite, (IBaselineGroup)this.object, progress);
        }
        if (this.object instanceof IConflictItem) {
            this.createControlConflictItem(composite, (IConflictItem)this.object, progress);
        }
        if (this.object instanceof PatchOpHandle) {
            PatchOpHandle localOp = (PatchOpHandle)this.object;
            PatchOp op = localOp.getOp();
            if (op instanceof ApplyHunkOp) {
                this.createControlUnmatchedHunk(composite, (ApplyHunkOp)op, progress);
            } else if (op instanceof AbstractStateChangeOp) {
                this.createControlPatchMerge(composite, (AbstractStateChangeOp)op, progress);
            }
        }
        if (this.object instanceof ILocalChange) {
            this.createLocalChange(composite, (ILocalChange)this.object, progress);
        }
        if (this.object instanceof IUnresolvedSource) {
            this.createUnresolvedSource(composite, (IUnresolvedSource)this.object, progress);
        }
        if (this.object instanceof IChangeSetHandle) {
            this.createControlChangeSetHandle(composite, (IChangeSetHandle)this.object, progress);
        }
        if (this.object instanceof PatchModel) {
            this.createControlPatchModel(composite, (PatchModel)this.object, progress);
        }
        if (this.object instanceof IOutgoingActivitySource) {
            this.createControlOutgoingActivitySource(composite, (IOutgoingActivitySource)this.object, progress);
        }
        if (this.object instanceof IIncomingActivitySource) {
            this.createControlIncomingActivitySource(composite, (IIncomingActivitySource)this.object, progress);
        }
        if (this.object instanceof ISuspendedActivitySource) {
            this.createControlSuspendedActivitySource(composite, (ISuspendedActivitySource)this.object, progress);
        }
        if (this.object instanceof PortsNode) {
            this.createControlPortsNode(composite, (PortsNode)this.object, progress);
        }
        if (this.object instanceof PlannedForWrapper) {
            this.createControlPlannedForWrapper(composite, (PlannedForWrapper)this.object, progress);
        }
    }

    protected void generateHead(HashMap map) {
        if (map.containsKey(GENERAL_CSS)) {
            return;
        }
        StringBuffer css = new StringBuffer();
        css.append("<style type=\"text/css\">");
        css.append("body { overflow: auto; ").append(MarkupUtil.getFont()).append(" }");
        css.append("span.photo { float: left; }");
        css.append("p.teaser { ").append(MarkupUtil.getDefaultFont()).append(" } ");
        if (this.getInfo().isHoverTooltip) {
            css.append("a:link { text-decoration: none; color: black; } ");
        } else {
            css.append("a:link { color: #0000FF; text-decoration: none; }");
        }
        if (this.getInfo().isHoverTooltip) {
            css.append("a:visited { color: black; text-decoration: none; } ");
        } else {
            css.append("a:visited { color: #0000FF; text-decoration: none; }\n");
        }
        css.append("a:hover { color: #000080; text-decoration: underline; }");
        css.append("</style>");
        map.put(GENERAL_CSS, css.toString());
    }

    void createControlWorkspaceComponentWrapper(HTMLGenerator.Composite composite, WorkspaceComponentWrapper wrapper, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_14).setFont(null, -1, false, true);
                new HTMLGenerator.Label((HTMLGenerator)this, composite, this.sanitize(wrapper.getComponent().getName()));
                new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                ComponentWrapper componentWrapper = (ComponentWrapper)((Object)Adapters.getAdapter((Object)wrapper, ComponentWrapper.class));
                Map<ComponentWrapper, ComponentDetails> details = ComponentDetailsFunction.fetchComponentDetails(Collections.singletonList(componentWrapper), (IProgressMonitor)progress.newChild(25));
                if (details != null && details.size() == 1) {
                    ComponentDetails componentDetails = details.values().iterator().next();
                    this.createComponentOwnerLabels(composite, componentDetails);
                    new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                    if (wrapper.getWorkspaceConnection().isLocked(wrapper.getComponentHandle())) {
                        IContributorHandle lockOwnerHandle = (IContributorHandle)IContributor.ITEM_TYPE.createItemHandle(UUID.valueOf((String)wrapper.getWorkspaceConnection().getLockOwnerItemID(wrapper.getComponentHandle())), null);
                        IItemManager itemMgr = wrapper.getRepository().itemManager();
                        IContributor contributor = (IContributor)itemMgr.fetchCompleteItem((IItemHandle)lockOwnerHandle, 0, (IProgressMonitor)progress.newChild(50));
                        new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_LOCKED_BY).setFont(null, -1, false, true);
                        HTMLGenerator.Link lockOwnerlink = new HTMLGenerator.Link((HTMLGenerator)this, composite, Location.itemLocation((IItemHandle)contributor, (String)wrapper.getRepository().getRepositoryURI()).toAbsoluteUri().toString());
                        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)lockOwnerlink, this.sanitize(contributor.getName()));
                        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                    }
                    this.createVisibilityLabels(composite, componentDetails.getVisibility(), wrapper.getRepository(), (IProgressMonitor)progress.newChild(25));
                }
                progress.setWorkRemaining(50);
                new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_15).setFont(null, -1, false, true);
                new HTMLGenerator.Label((HTMLGenerator)this, composite, this.getStatus(wrapper, (IProgressMonitor)progress.newChild(25)));
                new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                IWorkspaceConnection wc = wrapper.getWorkspaceConnection();
                ICurrentComponentInfo info = wc.getComponentInfo((IComponentHandle)wrapper.getComponent());
                IBaselineHandle baselineHandle = info.basis();
                IItemManager itemMgr = wrapper.getRepository().itemManager();
                IBaseline baseline = (IBaseline)itemMgr.fetchCompleteItem((IItemHandle)baselineHandle, 0, (IProgressMonitor)progress.newChild(25));
                new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_16).setFont(null, -1, false, true);
                new HTMLGenerator.Label((HTMLGenerator)this, composite, this.sanitize(BaselineLabelProvider.getText(baseline, true)));
                new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                if (!info.isDivergedFromBasis()) {
                    new HTMLGenerator.Label((HTMLGenerator)this, composite, this.sanitize(Messages.FilesystemHTMLGenerator_NO_CHANGES_AFTER_BASIS));
                } else {
                    new HTMLGenerator.Label((HTMLGenerator)this, composite, this.sanitize(Messages.FilesystemHTMLGenerator_CHANGES_AFTER_BASIS));
                }
                if (info.isHierarchyDivergedFromBasis() && !info.isDivergedFromBasis()) {
                    new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                    new HTMLGenerator.Label((HTMLGenerator)this, composite, this.sanitize(Messages.FilesystemHTMLGenerator_CHANGES_IN_HIERARCHY));
                }
            }
            catch (TeamRepositoryException e) {
                new HTMLGenerator.Label((HTMLGenerator)this, composite, String.valueOf(Messages.FilesystemHTMLGenerator_17) + e.getMessage());
                progress.done();
            }
        }
        finally {
            progress.done();
        }
    }

    private void createComponentOwnerLabels(HTMLGenerator.Composite composite, ComponentDetails componentDetails) {
        new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_25).setFont(null, -1, false, true);
        String ownerText = XMLString.createFromPlainText((String)componentDetails.getOwnerText()).getXMLText();
        IItem owner = componentDetails.getOwner().getItem();
        ITeamRepository ownerRepo = componentDetails.getOwner().getRepository();
        HTMLGenerator.Link link = new HTMLGenerator.Link((HTMLGenerator)this, composite, Location.itemLocation((IItemHandle)owner, (String)ownerRepo.getRepositoryURI()).toAbsoluteUri().toString());
        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)link, ownerText);
    }

    void createControlComponentWrapper(HTMLGenerator.Composite composite, ComponentWrapper wrapper, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_14).setFont(null, -1, false, true);
                new HTMLGenerator.Label((HTMLGenerator)this, composite, this.sanitize(wrapper.getComponent().getName()));
                new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                Map<ComponentWrapper, ComponentDetails> details = ComponentDetailsFunction.fetchComponentDetails(Collections.singletonList(wrapper), (IProgressMonitor)progress.newChild(50));
                if (details != null && details.size() == 1) {
                    ComponentDetails componentDetails = details.values().iterator().next();
                    this.createComponentOwnerLabels(composite, componentDetails);
                    new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                    this.createVisibilityLabels(composite, componentDetails.getVisibility(), wrapper.getRepository(), (IProgressMonitor)progress.newChild(50));
                }
            }
            catch (TeamRepositoryException e) {
                new HTMLGenerator.Label((HTMLGenerator)this, composite, String.valueOf(Messages.FilesystemHTMLGenerator_17) + e.getMessage());
                progress.done();
            }
        }
        finally {
            progress.done();
        }
    }

    private String getStatus(WorkspaceComponentWrapper wrapper, IProgressMonitor progress) {
        if (wrapper.isShared()) {
            int n = -1;
            try {
                n = FileSystemCore.getSharingManager().getNumShares((IContextHandle)wrapper.getWorkspace(), (IComponentHandle)wrapper.getComponent(), progress);
            }
            catch (FileSystemException e) {
                StatusUtil.log((Object)((Object)this), (String)"Error determining number of shares in component", (Throwable)e);
            }
            return NLS.bind((String)Messages.FilesystemHTMLGenerator_19, (Object)(n == -1 ? Messages.FilesystemHTMLGenerator_20 : Integer.toString(n)));
        }
        return Messages.FilesystemHTMLGenerator_21;
    }

    void createControlAbstractPlaceWrapper(HTMLGenerator.Composite composite, AbstractPlaceWrapper wrapper, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        try {
            new HTMLGenerator.Label((HTMLGenerator)this, composite, wrapper instanceof ContributorPlaceWrapper ? Messages.FilesystemHTMLGenerator_22 : Messages.FilesystemHTMLGenerator_23).setFont(null, -1, false, true);
            new HTMLGenerator.Label((HTMLGenerator)this, composite, XMLString.createFromPlainText((String)wrapper.getWorkspace().getName()).getXMLText());
            new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
            new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
            ITeamRepository repository = wrapper.getRepository();
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_24).setFont(null, -1, false, true);
            new HTMLGenerator.Label((HTMLGenerator)this, composite, FilesystemHTMLGenerator.checkIsSet(RepositoryUtils.getLabel(repository)));
            new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
            IItemManager itemMgr = wrapper.getRepository().itemManager();
            IAuditable auditable = (IAuditable)itemMgr.fetchCompleteItem((IItemHandle)wrapper.getWorkspace().getOwner(), 0, (IProgressMonitor)monitor.newChild(50));
            String name = auditable instanceof IProcessArea ? ((IProcessArea)auditable).getName() : ((IContributor)auditable).getName();
            name = this.sanitize(name);
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_25).setFont(null, -1, false, true);
            HTMLGenerator.Link link = new HTMLGenerator.Link((HTMLGenerator)this, composite, Location.itemLocation((IItemHandle)auditable, (String)repository.getRepositoryURI()).toAbsoluteUri().toString());
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)link, name);
            new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
            if (wrapper.getWorkspace().isLocked()) {
                IContributorHandle lockOwnerHandle = (IContributorHandle)IContributor.ITEM_TYPE.createItemHandle(UUID.valueOf((String)wrapper.getWorkspace().getLockOwnerItemID()), null);
                IContributor contributor = (IContributor)itemMgr.fetchCompleteItem((IItemHandle)lockOwnerHandle, 0, (IProgressMonitor)monitor.newChild(50));
                new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_LOCKED_BY).setFont(null, -1, false, true);
                HTMLGenerator.Link lockOwnerlink = new HTMLGenerator.Link((HTMLGenerator)this, composite, Location.itemLocation((IItemHandle)contributor, (String)wrapper.getRepository().getRepositoryURI()).toAbsoluteUri().toString());
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)lockOwnerlink, this.sanitize(contributor.getName()));
                new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
            }
            IWorkspaceConnection connection = (IWorkspaceConnection)wrapper.getConnection((IProgressMonitor)monitor.newChild(50));
            this.createVisibilityLabels(composite, connection.getReadScope(), repository, (IProgressMonitor)monitor);
            new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_26).setFont(null, -1, false, true);
            String description = wrapper.getWorkspace().getDescription();
            if (description == null) {
                description = ADD_A_DESCRIPTION;
            }
            description = this.sanitize(description);
            new HTMLGenerator.Label((HTMLGenerator)this, composite, description);
        }
        catch (TeamRepositoryException e) {
            new HTMLGenerator.Label((HTMLGenerator)this, composite, String.valueOf(Messages.FilesystemHTMLGenerator_27) + e.getMessage());
        }
    }

    private void createVisibilityLabels(HTMLGenerator.Composite composite, IReadScope scope, ITeamRepository repo, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_2).setFont(null, -1, false, true);
        String unknownName = Messages.FilesystemHTMLGenerator_UNKNOWN;
        if (scope == null) {
            new HTMLGenerator.Label((HTMLGenerator)this, composite, this.sanitize(unknownName));
            return;
        }
        if (scope instanceof ITeamAreaPrivateScope) {
            ITeamAreaPrivateScope teamPrivateScope = (ITeamAreaPrivateScope)scope;
            String scopePrefix = IReadScopeDescriber.FACTORY.shortDescription((IReadScope)teamPrivateScope);
            HTMLGenerator.Link hyperlink = null;
            try {
                IAuditableHandle teamAreaHandle = teamPrivateScope.getTeamArea();
                IProcessArea teamArea = (IProcessArea)repo.itemManager().fetchCompleteItem((IItemHandle)teamAreaHandle, 0, (IProgressMonitor)progress.newChild(100));
                if (teamArea != null) {
                    new HTMLGenerator.Label((HTMLGenerator)this, composite, String.valueOf(scopePrefix) + " (");
                    hyperlink = new HTMLGenerator.Link((HTMLGenerator)this, composite, Location.itemLocation((IItemHandle)teamArea, (String)repo.getRepositoryURI()).toAbsoluteUri().toString());
                    new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)hyperlink, this.sanitize(teamArea.getName()));
                    new HTMLGenerator.Label((HTMLGenerator)this, composite, ")");
                }
            }
            catch (Exception e) {
                StatusUtil.log((Object)((Object)this), (Throwable)e);
            }
            if (hyperlink == null) {
                new HTMLGenerator.Label((HTMLGenerator)this, composite, NLS.bind((String)Messages.FilesystemHTMLGenerator_40, (Object)this.sanitize(scopePrefix), (Object)this.sanitize(unknownName)));
            }
        } else if (scope instanceof IProcessAreaScope) {
            IProcessAreaScope processAreaScope = (IProcessAreaScope)scope;
            String scopePrefix = IReadScopeDescriber.FACTORY.shortDescription((IReadScope)processAreaScope);
            HTMLGenerator.Link hyperlink = null;
            try {
                IProcessArea readScopeProjectArea;
                IAuditableHandle processAreaHandle = processAreaScope.getProcessArea();
                IProcessArea processArea = (IProcessArea)repo.itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 0, (IProgressMonitor)progress.newChild(50));
                if (processArea != null && (readScopeProjectArea = (IProcessArea)repo.itemManager().fetchCompleteItem((IItemHandle)processArea.getProjectArea(), 0, (IProgressMonitor)progress.newChild(50))) != null) {
                    new HTMLGenerator.Label((HTMLGenerator)this, composite, String.valueOf(scopePrefix) + " (");
                    hyperlink = new HTMLGenerator.Link((HTMLGenerator)this, composite, Location.itemLocation((IItemHandle)readScopeProjectArea, (String)repo.getRepositoryURI()).toAbsoluteUri().toString());
                    new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)hyperlink, this.sanitize(readScopeProjectArea.getName()));
                    new HTMLGenerator.Label((HTMLGenerator)this, composite, ")");
                }
            }
            catch (Exception e) {
                StatusUtil.log((Object)((Object)this), (Throwable)e);
            }
            if (hyperlink == null) {
                new HTMLGenerator.Label((HTMLGenerator)this, composite, NLS.bind((String)Messages.FilesystemHTMLGenerator_40, (Object)this.sanitize(scopePrefix), (Object)this.sanitize(unknownName)));
            }
        } else if (scope instanceof IContributorDeferringScope) {
            IContributorDeferringScope contributorDeferringScope = (IContributorDeferringScope)scope;
            String scopePrefix = IReadScopeDescriber.FACTORY.shortDescription((IReadScope)contributorDeferringScope);
            HTMLGenerator.Link hyperlink = null;
            try {
                IAuditableHandle projectAreaHandle = contributorDeferringScope.getScope();
                IProcessArea projectArea = (IProcessArea)repo.itemManager().fetchCompleteItem((IItemHandle)projectAreaHandle, 0, (IProgressMonitor)progress.newChild(100));
                if (projectArea != null) {
                    new HTMLGenerator.Label((HTMLGenerator)this, composite, String.valueOf(scopePrefix) + " (");
                    hyperlink = new HTMLGenerator.Link((HTMLGenerator)this, composite, Location.itemLocation((IItemHandle)projectArea, (String)repo.getRepositoryURI()).toAbsoluteUri().toString());
                    new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)hyperlink, this.sanitize(projectArea.getName()));
                    new HTMLGenerator.Label((HTMLGenerator)this, composite, ")");
                }
            }
            catch (Exception e) {
                StatusUtil.log((Object)((Object)this), (Throwable)e);
            }
            if (hyperlink == null) {
                new HTMLGenerator.Label((HTMLGenerator)this, composite, NLS.bind((String)Messages.FilesystemHTMLGenerator_40, (Object)this.sanitize(scopePrefix), (Object)this.sanitize(unknownName)));
            }
        } else if (scope instanceof IPublicScope) {
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_3);
        } else if (scope instanceof IPrivateScope) {
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_4);
        } else if (scope instanceof IAccessGroupScope) {
            IAccessGroupScope accessGroupScope = (IAccessGroupScope)scope;
            String shortDescription = IReadScopeDescriber.FACTORY.shortDescription((IReadScope)accessGroupScope);
            String accessGroupName = unknownName;
            try {
                IAccessGroupClientService accessGroupService = (IAccessGroupClientService)repo.getClientLibrary(IAccessGroupClientService.class);
                IAccessGroup accessGroup = accessGroupService.getAccessGroupForGroupContextId(accessGroupScope.getAccessGroupId(), (IProgressMonitor)progress.newChild(100));
                if (accessGroup != null) {
                    accessGroupName = accessGroup.getName();
                }
            }
            catch (OperationCanceledException accessGroupService) {
            }
            catch (Exception e) {
                StatusUtil.log((Object)((Object)this), (Throwable)e);
            }
            new HTMLGenerator.Label((HTMLGenerator)this, composite, NLS.bind((String)Messages.FilesystemHTMLGenerator_40, (Object)this.sanitize(shortDescription), (Object)this.sanitize(accessGroupName)));
        }
    }

    private String sanitize(String s) {
        return XMLString.createFromPlainText((String)s).getXMLText();
    }

    void createControlChangeSetHandle(HTMLGenerator.Composite composite, IChangeSetHandle changeSetHandle, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        if (changeSetHandle.getOrigin() == null) {
            return;
        }
        try {
            ITeamRepository repo = (ITeamRepository)changeSetHandle.getOrigin();
            IChangeSet changeSet = (IChangeSet)repo.itemManager().fetchCompleteItem((IItemHandle)changeSetHandle, 0, (IProgressMonitor)monitor.newChild(20));
            this.createControlChangeSet(composite, repo, changeSet, (IProgressMonitor)monitor.newChild(80));
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
    }

    void createControlRemoteActivity(HTMLGenerator.Composite composite, ChangeSetWrapper activity, IProgressMonitor progress) {
        this.createControlChangeSet(composite, activity.getRepository(), activity.getChangeSet(), progress);
    }

    void createControlChangeSet(HTMLGenerator.Composite composite, ITeamRepository repo, IChangeSet changeSet, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        try {
            IItemManager itemMgr = repo.itemManager();
            IContributor contributor = (IContributor)itemMgr.fetchCompleteItem((IItemHandle)changeSet.getAuthor(), 0, (IProgressMonitor)monitor.newChild(10));
            Date modified = changeSet.getLastChangeDate();
            String creatorName = contributor != null ? XMLString.createFromPlainText((String)contributor.getName()).getXMLText() : Messages.FilesystemHTMLGenerator_28;
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_29).setFont(null, -1, false, true);
            new HTMLGenerator.Label((HTMLGenerator)this, composite, creatorName);
            new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_30).setFont(null, -1, false, true);
            new HTMLGenerator.Label((HTMLGenerator)this, composite, HistoryBin.formatDif((Date)modified, (boolean)true, (boolean)true));
            new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
            String comment = LabelsUtil.html((String)ChangeSetLocationFactory.getFullContextLabel((IChangeSet)changeSet));
            comment = ChangeSetLocationFactory.replaceLineEnding((String)comment, (String)"<br/>");
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_32).setFont(null, -1, false, true);
            new HTMLGenerator.Label((HTMLGenerator)this, composite, comment);
            new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
            List<IItem> reasons = LinkUtils.fetchDisplayReasonsFor((IChangeSetHandle)changeSet, (IProgressMonitor)monitor.newChild(35));
            List<IURIReference> oslcReferences = LinkUtils.fetchDisplayOslcLinksFor((IChangeSetHandle)changeSet, (IProgressMonitor)monitor.newChild(35));
            if (reasons.size() > 0 || oslcReferences.size() > 0) {
                new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_33).setFont(null, -1, false, true);
                new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                for (IItem object : reasons) {
                    IDomainAdapter itemAdapter = DomainAdapterUtils.getDomainAdapter((Object)object);
                    if (itemAdapter == null) continue;
                    HTMLGenerator.Link link = new HTMLGenerator.Link((HTMLGenerator)this, composite, Location.itemLocation((IItemHandle)object, (String)repo.getRepositoryURI()).toAbsoluteUri().toString());
                    new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)link, this.sanitize(itemAdapter.generateTitle((Object)object)));
                    new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                }
                for (IURIReference oslcReference : oslcReferences) {
                    HTMLGenerator.Link link = new HTMLGenerator.Link((HTMLGenerator)this, composite, oslcReference.getURI().toString());
                    new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)link, this.sanitize(oslcReference.getComment()));
                    new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                }
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
    }

    void createControlWorkspaceSyncContext(HTMLGenerator.Composite composite, IWorkspaceSyncContext context, IProgressMonitor progress) {
        String type;
        IWorkspaceConnection remote;
        IConnection connection;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IWorkspaceConnection wc = context.getLocal();
        new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_35).setFont(null, -1, false, true);
        new HTMLGenerator.Label((HTMLGenerator)this, composite, this.sanitize(wc.getName()));
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        ITeamRepository repository = context.getLocal().teamRepository();
        new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_41).setFont(null, -1, false, true);
        new HTMLGenerator.Label((HTMLGenerator)this, composite, FilesystemHTMLGenerator.checkIsSet(RepositoryUtils.getLabel(repository)));
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        IComponentSyncContext[] contexts = context.getComponentSyncContexts();
        if (contexts.length > 0) {
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_42).setFont(null, -1, false, true);
            new HTMLGenerator.Label((HTMLGenerator)this, composite, this.sanitize(contexts[0].getOutgoingActivitySource().getOwnerName()));
            new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        }
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        try {
            connection = context.getRemoteIncomingConnectionDescriptor().getConnection((IProgressMonitor)monitor.newChild(50));
            if (connection instanceof IWorkspaceConnection) {
                remote = (IWorkspaceConnection)connection;
                type = remote.isStream() ? Messages.FilesystemHTMLGenerator_37 : Messages.FilesystemHTMLGenerator_38;
                new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_39_1).setFont(null, -1, false, true);
                new HTMLGenerator.Label((HTMLGenerator)this, composite, NLS.bind((String)Messages.FilesystemHTMLGenerator_40, (Object)this.sanitize(remote.getName()), (Object)type));
                new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                repository = remote.teamRepository();
                new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_41).setFont(null, -1, false, true);
                new HTMLGenerator.Label((HTMLGenerator)this, composite, FilesystemHTMLGenerator.checkIsSet(RepositoryUtils.getLabel(repository)));
            }
        }
        catch (TeamRepositoryException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
        }
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        try {
            connection = context.getRemoteOutgoingConnectionDescriptor().getConnection((IProgressMonitor)monitor.newChild(50));
            if (connection instanceof IWorkspaceConnection) {
                remote = (IWorkspaceConnection)connection;
                type = remote.isStream() ? Messages.FilesystemHTMLGenerator_37 : Messages.FilesystemHTMLGenerator_38;
                new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_39_2).setFont(null, -1, false, true);
                new HTMLGenerator.Label((HTMLGenerator)this, composite, NLS.bind((String)Messages.FilesystemHTMLGenerator_40, (Object)this.sanitize(remote.getName()), (Object)type));
                new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                repository = remote.teamRepository();
                new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_41).setFont(null, -1, false, true);
                new HTMLGenerator.Label((HTMLGenerator)this, composite, FilesystemHTMLGenerator.checkIsSet(RepositoryUtils.getLabel(repository)));
            }
        }
        catch (TeamRepositoryException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
        }
    }

    static String checkIsSet(String string) {
        return string != null ? string : Messages.FilesystemHTMLGenerator_43;
    }

    void createControlComponentSyncContext(HTMLGenerator.Composite composite, IComponentSyncContext context, IProgressMonitor progress) {
        int pending;
        IWorkspaceConnection wc;
        IBaseline baseline;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IComponent component = context.getComponent();
        new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_44).setFont(null, -1, false, true);
        new HTMLGenerator.Label((HTMLGenerator)this, composite, XMLString.createFromPlainText((String)component.getName()).getXMLText());
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        if (context.detectCycle()) {
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_COMPONENT_IN_CYCLE_LABEL).setFont(null, -1, false, true);
            new HTMLGenerator.Label((HTMLGenerator)this, composite, NLS.bind((String)Messages.FilesystemHTMLGenerator_COMPONENT_IN_CYCLE_HELP, (Object)context.getWorkspaceSyncContext().getLocal().getName())).setFont(null, -1, false, false);
            new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
            new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        }
        if (context.getOutgoingTeamPlace() != null) {
            WorkspaceComponentWrapper wrapper = WorkspaceComponentWrapper.newWrapper(context.getOutgoingTeamPlace(), component);
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_45).setFont(null, -1, false, true);
            new HTMLGenerator.Label((HTMLGenerator)this, composite, this.getStatus(wrapper, (IProgressMonitor)monitor.newChild(100)));
            new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        }
        if ((baseline = context.getLocalBaseline()) != null) {
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_46).setFont(null, -1, false, true);
            new HTMLGenerator.Label((HTMLGenerator)this, composite, this.sanitize(BaselineLabelProvider.getText(baseline, true)));
            new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
            if (context.getOutgoingTeamPlace() != null) {
                wc = context.getOutgoingTeamPlace();
                try {
                    ICurrentComponentInfo componentInfo = wc.getComponentInfo((IComponentHandle)component);
                    if (componentInfo.isDivergedFromBasis()) {
                        new HTMLGenerator.Label((HTMLGenerator)this, composite, this.sanitize(Messages.FilesystemHTMLGenerator_CHANGES_AFTER_BASIS));
                        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                    } else {
                        new HTMLGenerator.Label((HTMLGenerator)this, composite, this.sanitize(Messages.FilesystemHTMLGenerator_NO_CHANGES_AFTER_BASIS));
                        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                    }
                    if (componentInfo.isHierarchyDivergedFromBasis() && !componentInfo.isDivergedFromBasis()) {
                        new HTMLGenerator.Label((HTMLGenerator)this, composite, this.sanitize(Messages.FilesystemHTMLGenerator_CHANGES_IN_HIERARCHY));
                        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                    }
                }
                catch (ComponentNotInWorkspaceException componentInfo) {
                    // empty catch block
                }
            }
        }
        if (context.isOfType(1)) {
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_51).setFont(null, -1, false, true);
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_47);
        } else {
            String type;
            wc = context.getRemoteIncomingTeamPlace();
            if (wc != null) {
                type = wc.isStream() ? Messages.FilesystemHTMLGenerator_49 : Messages.FilesystemHTMLGenerator_50;
                new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_39_1).setFont(null, -1, false, true);
                new HTMLGenerator.Label((HTMLGenerator)this, composite, NLS.bind((String)Messages.FilesystemHTMLGenerator_52, (Object)this.sanitize(wc.getName()), (Object)type));
                new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_41).setFont(null, -1, false, true);
                new HTMLGenerator.Label((HTMLGenerator)this, composite, FilesystemHTMLGenerator.checkIsSet(RepositoryUtils.getLabel(context.getRemoteIncomingTeamRepository())));
            }
            if ((wc = context.getRemoteOutgoingTeamPlace()) != null) {
                new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                type = wc.isStream() ? Messages.FilesystemHTMLGenerator_49 : Messages.FilesystemHTMLGenerator_50;
                new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_39_2).setFont(null, -1, false, true);
                new HTMLGenerator.Label((HTMLGenerator)this, composite, NLS.bind((String)Messages.FilesystemHTMLGenerator_52, (Object)this.sanitize(wc.getName()), (Object)type));
                new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_41).setFont(null, -1, false, true);
                new HTMLGenerator.Label((HTMLGenerator)this, composite, FilesystemHTMLGenerator.checkIsSet(RepositoryUtils.getLabel(context.getRemoteIncomingTeamRepository())));
            }
        }
        if (context.isLocal()) {
            new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_53).setFont(null, -1, false, true);
            ILocalChangeSource source = context.getLocalChangeSource();
            String msg = source.getAutoCheckinMode() ? (source.getAutoCheckinLastError() == null ? Messages.FilesystemHTMLGenerator_54 : Messages.FilesystemHTMLGenerator_55) : Messages.FilesystemHTMLGenerator_56;
            new HTMLGenerator.Label((HTMLGenerator)this, composite, msg);
        }
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        Date date = context.getRefreshLastTime();
        new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_176).setFont(null, -1, false, true);
        String status = context.getRefreshLastError() != null || !context.getLoggedIn() ? Messages.FilesystemHTMLGenerator_177 : Messages.FilesystemHTMLGenerator_178;
        new HTMLGenerator.Label((HTMLGenerator)this, composite, NLS.bind((String)Messages.FilesystemHTMLGenerator_179, (Object)(date != null ? HistoryBin.formatDif((Date)date, (boolean)true, (boolean)true) : Messages.FilesystemHTMLGenerator_180), (Object)status));
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        if (context.isOfType(2) && (context.isOfType(4) || context.isOfType(8))) {
            pending = context.getLocalChangeSource().size();
            int incoming = context.getIncomingActivitySource().getActivities().size();
            int outgoing = context.getOutgoingActivitySource().getActivities().size();
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_57).setFont(null, -1, false, true);
            String label = "";
            boolean needSep = false;
            if (pending != 0) {
                label = String.valueOf(label) + NLS.bind((String)Messages.FilesystemHTMLGenerator_59, (Object)pending);
                needSep = true;
            }
            if (outgoing != 0) {
                if (needSep) {
                    label = String.valueOf(label) + ", ";
                }
                label = String.valueOf(label) + NLS.bind((String)Messages.FilesystemHTMLGenerator_61, (Object)outgoing);
                needSep = true;
            }
            if (incoming != 0) {
                if (needSep) {
                    label = String.valueOf(label) + ", ";
                }
                label = String.valueOf(label) + NLS.bind((String)Messages.FilesystemHTMLGenerator_63, (Object)incoming);
                needSep = true;
            }
            if (pending == 0 && outgoing == 0 && incoming == 0) {
                label = String.valueOf(label) + Messages.FilesystemHTMLGenerator_64;
            }
            new HTMLGenerator.Label((HTMLGenerator)this, composite, label);
        }
        if (context.isOfType(16)) {
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_65);
        }
        if (context.isOfType(32)) {
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_66);
        }
        if (context.isOfType(64)) {
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_67);
        }
        if (context.isOfType(128)) {
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_68);
        }
        if (context.isOfType(1)) {
            pending = context.getLocalChangeSource().size();
            int outgoing = context.getOutgoingActivitySource().getActivities().size();
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_69).setFont(null, -1, false, true);
            String label = "";
            if (pending != 0) {
                label = String.valueOf(label) + NLS.bind((String)Messages.FilesystemHTMLGenerator_71, (Object)pending);
            }
            if (outgoing != 0) {
                if (pending != 0) {
                    label = String.valueOf(label) + ", ";
                }
                label = String.valueOf(label) + NLS.bind((String)Messages.FilesystemHTMLGenerator_73, (Object)outgoing);
            }
            if (pending == 0 && outgoing == 0) {
                label = String.valueOf(label) + Messages.FilesystemHTMLGenerator_74;
            }
            new HTMLGenerator.Label((HTMLGenerator)this, composite, label);
        }
        if (context.isLocal()) {
            Collection sandboxes = null;
            try {
                sandboxes = FileSystemCore.getSharingManager().getSandboxes(new ConfigurationFacade((IConnection)context.getOutgoingTeamPlace(), (IComponentHandle)component), (IProgressMonitor)monitor.newChild(1));
            }
            catch (FileSystemException e) {
                StatusUtil.log((Object)((Object)this), (String)"Error retrieving sandboxes.", (Throwable)e);
            }
            if (sandboxes != null && sandboxes.size() > 0) {
                int numOfSandboxes = sandboxes.size();
                ArrayList<String> sandboxPaths = new ArrayList<String>();
                String eclipseWorkspace = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
                for (ISandbox sandbox : sandboxes) {
                    String sandboxPath = sandbox.getRoot().toOSString();
                    if (sandboxPath.equals(eclipseWorkspace)) {
                        sandboxPath = NLS.bind((String)Messages.FilesystemHTMLGenerator_183, (Object)eclipseWorkspace);
                    }
                    sandboxPaths.add(sandboxPath);
                }
                new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                if (numOfSandboxes == 1) {
                    new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_181).setFont(null, -1, false, true);
                } else {
                    new HTMLGenerator.Label((HTMLGenerator)this, composite, NLS.bind((String)Messages.FilesystemHTMLGenerator_182, (Object)numOfSandboxes)).setFont(null, -1, false, true);
                }
                new HTMLGenerator.Label((HTMLGenerator)this, composite, TableUtil.group(sandboxPaths, ", ", false));
            }
        }
    }

    void createControlBaselineGroup(HTMLGenerator.Composite composite, IBaselineGroup group, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_75).setFont(null, -1, false, true);
        IBaseline baseline = group.getBaseline();
        new HTMLGenerator.Label((HTMLGenerator)this, composite, this.sanitize(BaselineWrapper.getLabel(baseline)));
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_76).setFont(null, -1, false, true);
        new HTMLGenerator.Label((HTMLGenerator)this, composite, BaselineLabelProvider.getDate(baseline.getCreationDate()));
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        ITeamRepository repo = (ITeamRepository)baseline.getOrigin();
        try {
            IContributor creator = (IContributor)repo.itemManager().fetchCompleteItem((IItemHandle)baseline.getCreator(), 0, (IProgressMonitor)monitor.newChild(100));
            if (creator != null) {
                new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_77).setFont(null, -1, false, true);
                new HTMLGenerator.Label((HTMLGenerator)this, composite, this.sanitize(creator.getName()));
                new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
            }
        }
        catch (TeamRepositoryException creator) {
            // empty catch block
        }
        new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_78).setFont(null, -1, false, true);
        String comment = this.sanitize(baseline.getComment());
        if ("".equals(comment)) {
            comment = Messages.FilesystemHTMLGenerator_80;
        }
        new HTMLGenerator.Label((HTMLGenerator)this, composite, comment);
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
    }

    void createControlConflictItem(HTMLGenerator.Composite composite, IConflictItem conflictItem, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_81).setFont(null, -1, false, true);
        new HTMLGenerator.Label((HTMLGenerator)this, composite, LabelsUtil.getConflictType((IConflictItem)conflictItem, (boolean)true));
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_82).setFont(null, -1, false, true);
        new HTMLGenerator.Label((HTMLGenerator)this, composite, String.valueOf(LabelsUtil.getConflictInformation((IConflictItem)conflictItem, (boolean)true)) + LabelsUtil.getDetails((IConflictItem)conflictItem, (boolean)true, (boolean)true));
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        new HTMLGenerator.Label((HTMLGenerator)this, composite, LabelsUtil.getConflictLocalResource((IConflictItem)conflictItem, (boolean)true, (IProgressMonitor)monitor.newChild(15)));
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_83).setFont(null, -1, false, true);
        new HTMLGenerator.Label((HTMLGenerator)this, composite, String.valueOf(LabelsUtil.getConflictInformation((IConflictItem)conflictItem, (boolean)false)) + LabelsUtil.getDetails((IConflictItem)conflictItem, (boolean)false, (boolean)true));
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        new HTMLGenerator.Label((HTMLGenerator)this, composite, LabelsUtil.getConflictAcceptedResource((IConflictItem)conflictItem, (boolean)true, (IProgressMonitor)monitor.newChild(15)));
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        String resolveHint = LabelsUtil.getResolveHint((IConflictItem)conflictItem, (boolean)true);
        if (resolveHint != null && resolveHint.length() > 0) {
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_84).setFont(null, -1, false, true);
            new HTMLGenerator.Label((HTMLGenerator)this, composite, LabelsUtil.getResolveHint((IConflictItem)conflictItem, (boolean)true));
        }
    }

    void createControlUnmatchedHunk(HTMLGenerator.Composite composite, ApplyHunkOp hunk, IProgressMonitor progress) {
        new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_102).setFont(null, -1, false, true);
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_103);
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
    }

    void createControlPatchMerge(HTMLGenerator.Composite composite, AbstractStateChangeOp hunk, IProgressMonitor progress) {
        new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_104).setFont(null, -1, false, true);
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_105);
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
    }

    void createLocalChange(HTMLGenerator.Composite composite, ILocalChange localChange, IProgressMonitor progress) {
        new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_106).setFont(null, -1, false, true);
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        new HTMLGenerator.Label((HTMLGenerator)this, composite, LabelsUtil.getLocalChangeInformation((ILocalChange)localChange, (boolean)true));
    }

    void createUnresolvedSource(HTMLGenerator.Composite composite, IUnresolvedSource source, IProgressMonitor progress) {
        new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_175);
    }

    void createControlPatchModel(HTMLGenerator.Composite composite, PatchModel patch, IProgressMonitor progress) {
        new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_PATCHES_FOLDER_TOOLTIP);
    }

    void createControlOutgoingActivitySource(HTMLGenerator.Composite composite, IOutgoingActivitySource source, IProgressMonitor progress) {
        boolean isWorkspace = true;
        IWorkspaceConnection wc = source.getModel().getOutgoingTeamPlace();
        if (wc != null && wc.isStream()) {
            isWorkspace = false;
        }
        new HTMLGenerator.Label((HTMLGenerator)this, composite, isWorkspace ? Messages.FilesystemHTMLGenerator_OUTGOING_FOLDER_TOOLTIP : Messages.FilesystemHTMLGenerator_OUTGOING_FOLDER_FOR_STREAM_TOOLTIP);
    }

    void createControlIncomingActivitySource(HTMLGenerator.Composite composite, IIncomingActivitySource source, IProgressMonitor progress) {
        boolean isWorkspace = true;
        IWorkspaceConnection wc = source.getModel().getOutgoingTeamPlace();
        if (wc != null && wc.isStream()) {
            isWorkspace = false;
        }
        new HTMLGenerator.Label((HTMLGenerator)this, composite, isWorkspace ? Messages.FilesystemHTMLGenerator_INCOMING_FOLDER_TOOLTIP : Messages.FilesystemHTMLGenerator_INCOMING_FOLDER_FOR_STREAM_TOOLTIP);
    }

    void createControlSuspendedActivitySource(HTMLGenerator.Composite composite, ISuspendedActivitySource source, IProgressMonitor progress) {
        new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_SUSPENDED_FOLDER_TOOLTIP);
    }

    void createControlPortsNode(HTMLGenerator.Composite composite, PortsNode portNode, IProgressMonitor progress) {
        new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_PORTS_FOLDER_TOOLTIP);
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_PORTS_FOLDER_TOOLTIP_CURRENT_MERGE).setFont(null, -1, false, true);
        CurrentPortNode currentPort = portNode.getChildCurrentPortContainerNode().getChildCurrentPortNode();
        if (currentPort == null) {
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_PORTS_FOLDER_TOOLTIP_NO_CURRENT_MEREGE);
        } else {
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_PORTS_FOLDER_TOOLTIP_HAS_CURRENT_MERGE);
        }
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_PORTS_FOLDER_TOOLTIP_MERGE_QUEUE).setFont(null, -1, false, true);
        List pendingPorts = portNode.getChildPendingPortsContainerNode().getChildPendingPorts();
        int numPendingPorts = pendingPorts.size();
        if (numPendingPorts == 0) {
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_PORTS_FOLDER_TOOLTIP_NO_MERGE_QUEUE);
        } else if (numPendingPorts == 1) {
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_PORTS_FOLDER_TOOLTIP_ONE_MERGE_QUEUE);
        } else {
            try {
                long totalNumPendingPorts = portNode.getWorkspaceConnection().getAcceptQueueSize((IComponentHandle)portNode.getComponent());
                if (totalNumPendingPorts > (long)numPendingPorts) {
                    new HTMLGenerator.Label((HTMLGenerator)this, composite, NLS.bind((String)Messages.FilesystemHTMLGenerator_PORTS_FOLDER_TOOLTIP_PART_OF_MERGE_QUEUE, (Object)totalNumPendingPorts, (Object)numPendingPorts));
                } else {
                    new HTMLGenerator.Label((HTMLGenerator)this, composite, NLS.bind((String)Messages.FilesystemHTMLGenerator_PORTS_FOLDER_TOOLTIP_MANY_MERGE_QUEUE, (Object)numPendingPorts));
                }
            }
            catch (ComponentNotInWorkspaceException e) {
                new HTMLGenerator.Label((HTMLGenerator)this, composite, NLS.bind((String)Messages.FilesystemHTMLGenerator_PORTS_FOLDER_TOOLTIP_MANY_MERGE_QUEUE, (Object)numPendingPorts));
            }
        }
    }

    void createControlPlannedForWrapper(HTMLGenerator.Composite composite, PlannedForWrapper wrapper, IProgressMonitor progress) {
        new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.FilesystemHTMLGenerator_PLANNED_FOR).setFont(null, -1, false, true);
        HTMLGenerator.BulletList bulletList = new HTMLGenerator.BulletList((HTMLGenerator)this, composite);
        for (String plannedFor : wrapper.getPlannedForNames()) {
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)bulletList, plannedFor);
        }
    }
}

