/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.dashboard;

import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.jface.HistoryBin;
import com.ibm.team.jface.preview.DomainAdapter;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IBaseline;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class BaselineDomainAdapter
extends DomainAdapter {
    protected Object convertToDomainObject(Object object) {
        if (object instanceof BaselineWrapper) {
            return ((BaselineWrapper)object).getBaseline();
        }
        if (object instanceof IBaseline) {
            return object;
        }
        return null;
    }

    public void generateContentAsHTML(HashMap head, StringBuffer body, Object input, IDomainAdapter.Info info, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IBaseline baseline = (IBaseline)this.convertToDomainObject(input);
        body.append("<b>" + Messages.BaselineDomainAdapter_1 + "</b> " + XMLString.createFromPlainText((String)baseline.getName()).getXMLText() + " <br>");
        body.append("<b>" + Messages.BaselineDomainAdapter_5 + "</b> " + XMLString.createFromPlainText((String)baseline.getComment()).getXMLText() + "<br>");
        body.append("<b>" + Messages.BaselineDomainAdapter_9 + "</b> " + HistoryBin.formatDif((Date)baseline.getCreationDate(), (boolean)true, (boolean)true) + "<br>");
        ITeamRepository repo = (ITeamRepository)baseline.getOrigin();
        try {
            IContributor creator = (IContributor)repo.itemManager().fetchCompleteItem((IItemHandle)baseline.getCreator(), 0, (IProgressMonitor)monitor.newChild(100));
            if (creator != null) {
                body.append("<b>" + Messages.BaselineDomainAdapter_13 + "</b> " + NLS.bind((String)Messages.BaselineDomainAdapter_15, (Object)XMLString.createFromPlainText((String)creator.getName()).getXMLText(), (Object)XMLString.createFromPlainText((String)creator.getEmailAddress()).getXMLText()) + "<br>");
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
    }

    public void generateContentAsHTML(HashMap head, StringBuffer body, Object input, IDomainAdapter.Info info) {
        this.generateContentAsHTML(head, body, input, info, null);
    }

    public String generateTitle(Object input) {
        return Messages.BaselineDomainAdapter_17;
    }
}

