/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.corruption;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.operations.IMetadataRepairOperation;
import com.ibm.team.filesystem.client.operations.MetadataRepairDilemmaHandler;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.TeamServiceException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RebuildCFAJob {
    private final Collection<ISandbox> sandboxes;

    public static void repairSandboxes(Collection<ISandbox> sandboxes, final Button rebuild, IProgressMonitor monitor) throws FileSystemException {
        if (sandboxes.isEmpty()) {
            return;
        }
        if (sandboxes.size() == 1) {
            final ISandbox sandbox = sandboxes.iterator().next();
            if (!sandbox.isCorrupted(monitor)) {
                final boolean[] result = new boolean[1];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        result[0] = MessageDialog.openQuestion((Shell)rebuild.getShell(), (String)Messages.SourceControlPreferencePage_0, (String)NLS.bind((String)Messages.SandboxPreferencePage_OneSandboxNotCorrupt, (Object)sandbox.getRoot().toOSString()));
                    }
                });
                if (!result[0]) {
                    return;
                }
            }
        } else {
            ISandbox sandbox;
            boolean corrupt = false;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)sandboxes.size());
            Iterator<ISandbox> iterator = sandboxes.iterator();
            if (iterator.hasNext() && (sandbox = iterator.next()).isCorrupted((IProgressMonitor)progress.newChild(1))) {
                corrupt = true;
            }
            if (!corrupt) {
                final boolean[] result = new boolean[1];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        result[0] = MessageDialog.openQuestion((Shell)rebuild.getShell(), (String)Messages.SourceControlPreferencePage_0, (String)Messages.SandboxPreferencePage_MultipleSandboxesNotCorrupt);
                    }
                });
                if (!result[0]) {
                    return;
                }
            }
        }
        final RebuildCFAJob rebuildJob = new RebuildCFAJob(sandboxes){

            @Override
            public void success(IStatus status) {
                if (!rebuild.isDisposed()) {
                    rebuild.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!rebuild.isDisposed()) {
                                rebuild.setEnabled(true);
                            }
                        }
                    });
                }
            }

            @Override
            public void failure(IStatus status) {
                super.failure(status);
                this.success(status);
            }
        };
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                rebuildJob.schedule((Control)rebuild);
                rebuild.setEnabled(false);
            }
        });
    }

    public RebuildCFAJob(Collection<ISandbox> sandboxes) {
        this.sandboxes = sandboxes;
    }

    public void schedule(final Control control) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = control.getShell();
                if (!shell.isDisposed()) {
                    try {
                        new ProgressMonitorDialog(shell).run(true, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                RebuildCFAJob.this.run(monitor);
                            }
                        });
                    }
                    catch (InvocationTargetException e) {
                        RebuildCFAJob.this.failure(FileSystemStatusUtil.getStatusFor((Throwable)e.getTargetException()));
                    }
                    catch (InterruptedException e) {
                        RebuildCFAJob.this.failure(Status.CANCEL_STATUS);
                    }
                }
            }
        });
    }

    protected void run(IProgressMonitor progress) {
        try {
            IStatus status = this.doRun(progress);
            if (status.isOK()) {
                this.success(status);
            } else {
                this.failure(status);
            }
        }
        catch (OperationCanceledException e) {
            this.failure(Status.CANCEL_STATUS);
        }
    }

    public void failure(final IStatus status) {
        if (status.getSeverity() == 8) {
            return;
        }
        UiPlugin.getDefault().getLog().log(status);
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.RebuildCFAJob_7, (String)status.getMessage());
            }
        });
    }

    public void success(IStatus status) {
    }

    /*
     * Exception decompiling
     */
    private IStatus doRun(IProgressMonitor progress) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void ensureLogin(SubMonitor monitor) throws TeamRepositoryException, FileSystemException, LoginCancelledException, LoginFailedException {
        ITeamRepositoryService service = TeamPlatform.getTeamRepositoryService();
        ITeamRepository[] repos = service.getTeamRepositories();
        monitor.beginTask(Messages.RebuildCFAJob_2, repos.length);
        try {
            ITeamRepository[] iTeamRepositoryArray = repos;
            int n = repos.length;
            int n2 = 0;
            while (n2 < n) {
                ITeamRepository repo = iTeamRepositoryArray[n2];
                monitor.setTaskName(NLS.bind((String)Messages.RebuildCFAJob_3, (Object)repo.getName()));
                try {
                    if (!repo.loggedIn()) {
                        repo.login((IProgressMonitor)monitor.newChild(1));
                    } else {
                        monitor.worked(1);
                    }
                }
                catch (OperationCanceledException e) {
                    throw new LoginCancelledException(repo);
                }
                catch (TeamServiceException e) {
                    throw new LoginFailedException(repo, e);
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void repair(SubMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.sandboxes.size() * 100));
        progress.setTaskName(Messages.RebuildCFAJob_4);
        IStatus status = Status.OK_STATUS;
        boolean hasMissingDescriptors = false;
        for (ISandbox sandbox : this.sandboxes) {
            RebuildParticipant particpant = new RebuildParticipant(sandbox);
            IMetadataRepairOperation operation = IOperationFactory.instance.getMetadataRepairOperation(sandbox.getRoot(), (MetadataRepairDilemmaHandler)particpant, IRepositoryResolver.EXISTING_SHARED);
            operation.run((IProgressMonitor)progress.newChild(100));
            if (particpant.status.isOK()) {
                UiPlugin.getDefault().getLog().log((IStatus)new Status(1, "com.ibm.team.filesystem.ide.ui", NLS.bind((String)"Repair of ''{0}'' completed without errors", (Object)sandbox.getRoot().toOSString())));
            } else {
                status = particpant.status;
            }
            if (!particpant.noDescriptorsFound) continue;
            hasMissingDescriptors = true;
        }
        if (hasMissingDescriptors) {
            final Display display = Display.getDefault();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)display.getActiveShell(), (String)Messages.RebuildCFAJob_NoSharingInfoFoundTitle, (String)Messages.RebuildCFAJob_NoSharingInfoFoundDescription);
                }
            });
        } else if (!status.isOK()) {
            this.displayError(status);
        }
        progress.done();
    }

    private void displayError(final IStatus status) {
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.openError((Shell)display.getActiveShell(), (String)Messages.RebuildCFAJob_ErrorsOccurredTitle, (String)Messages.RebuildCFAJob_ErrorsOccurredDescription, (IStatus)status);
            }
        });
    }

    public static boolean requiresMigration(ILocation root) {
        return CopyFileAreaManager.instance.requiresMigration(root);
    }

    private static class LoginCancelledException
    extends RebuildLoginException {
        LoginCancelledException(ITeamRepository repo) {
            super(repo);
        }
    }

    private static class LoginFailedException
    extends RebuildLoginException {
        LoginFailedException(ITeamRepository repo, TeamServiceException e) {
            super(repo);
            this.initCause(e);
        }
    }

    private static class RebuildLoginException
    extends Exception {
        final ITeamRepository repo;

        RebuildLoginException(ITeamRepository repo) {
            this.repo = repo;
        }

        public ITeamRepository getRepository() {
            return this.repo;
        }
    }

    private class RebuildParticipant
    extends MetadataRepairDilemmaHandler {
        private boolean noDescriptorsFound;
        private ISandbox sandbox;
        private IStatus status = Status.OK_STATUS;

        public RebuildParticipant(ISandbox sandbox) {
            this.sandbox = sandbox;
        }

        public int ignoredErrors(IStatus status) {
            this.status = status;
            UiPlugin.getDefault().getLog().log(status);
            return 0;
        }

        public void noDescriptorsFound() {
            UiPlugin.getDefault().getLog().log(StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)"No sharing information has been found for ''{0}''. Projects for that sandbox will be disconnected and either need to be reshared or reloaded", (Object)this.sandbox.getRoot().toOSString())));
            this.noDescriptorsFound = true;
        }
    }
}

