/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.corruption;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaEvent;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaListener;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.ILocalSynchronizationManager;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.corruption.RebuildCFAJob;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class CorruptCopyFileAreaListener
implements ICorruptCopyFileAreaListener {
    boolean shouldTurnOnAutoCheckin = false;
    private PromptForRebuildJob prompter;
    private static final CorruptCopyFileAreaListener instance = new CorruptCopyFileAreaListener();

    public static CorruptCopyFileAreaListener getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void corrupt(ICorruptCopyFileAreaEvent event) {
        if (!event.isCorrupt()) {
            return;
        }
        if (this.isAutoCheckinEnabled()) {
            this.disableAutoCheckIn();
            CorruptCopyFileAreaListener corruptCopyFileAreaListener = this;
            synchronized (corruptCopyFileAreaListener) {
                this.shouldTurnOnAutoCheckin = true;
            }
        }
        this.getPrompter().promptToRebuild(event.getRoot());
    }

    private synchronized PromptForRebuildJob getPrompter() {
        if (this.prompter == null) {
            this.prompter = new PromptForRebuildJob();
        }
        return this.prompter;
    }

    private void dialogClosed(int returnCode, Set<ILocation> sandboxPaths, Shell shell) {
        switch (returnCode) {
            case 0: {
                this.repair(shell, sandboxPaths);
                break;
            }
            case -1: 
            case 1: {
                this.delayRepair();
                break;
            }
            default: {
                StatusUtil.log((Object)"com.ibm.team.filesystem.ide.ui", (String)("Unknown result " + returnCode));
                this.delayRepair();
            }
        }
    }

    private void repair(Shell shell, Set<ILocation> sandboxPaths) {
        ArrayList<ISandbox> sandboxes = new ArrayList<ISandbox>();
        for (ILocation sandboxPath : sandboxPaths) {
            ISandbox sandbox = FileSystemCore.getSharingManager().getSandbox(sandboxPath, true);
            sandboxes.add(sandbox);
        }
        new RebuildCFAJob(sandboxes){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void success(IStatus status) {
                boolean enable;
                CorruptCopyFileAreaListener corruptCopyFileAreaListener = CorruptCopyFileAreaListener.this;
                synchronized (corruptCopyFileAreaListener) {
                    enable = CorruptCopyFileAreaListener.this.shouldTurnOnAutoCheckin;
                    CorruptCopyFileAreaListener.this.shouldTurnOnAutoCheckin = false;
                }
                if (enable) {
                    CorruptCopyFileAreaListener.this.enableAutoCheckIn();
                }
            }
        }.schedule((Control)shell);
    }

    private boolean disableAutoCheckIn() {
        IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
        boolean oldValue = store.getBoolean("auto commit");
        store.setValue("auto commit", false);
        ILocalSynchronizationManager syncManager = FileSystemResourcesPlugin.getComponentSyncModel().getLocalSynchronizationManager();
        syncManager.setAutoSave(false);
        return oldValue;
    }

    private boolean isAutoCheckinEnabled() {
        IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("auto commit");
    }

    private void enableAutoCheckIn() {
        IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
        store.setValue("auto commit", true);
        ILocalSynchronizationManager syncManager = FileSystemResourcesPlugin.getComponentSyncModel().getLocalSynchronizationManager();
        syncManager.setAutoSave(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delayRepair() {
        boolean enabled;
        CorruptCopyFileAreaListener corruptCopyFileAreaListener = this;
        synchronized (corruptCopyFileAreaListener) {
            enabled = this.shouldTurnOnAutoCheckin;
            this.shouldTurnOnAutoCheckin = false;
        }
        if (enabled) {
            new ModelessMessageDialog(CorruptCopyFileAreaListener.getWin(), Messages.CorruptCopyFileAreaListener_TurnOffAutoCheckin, null, Messages.CorruptCopyFileAreaListener_AutoCheckinTurnedOff, 4, new String[]{IDialogConstants.OK_LABEL}, 0, null).open();
        }
    }

    static Shell getWin() {
        IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (win == null) {
            return null;
        }
        return win.getShell();
    }

    private static class ModelessMessageDialog
    extends MessageDialog {
        boolean inShellCloseEvent = false;
        ICloseHandler handler;

        public ModelessMessageDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, ICloseHandler handler) {
            super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
            this.setShellStyle(this.getShellStyle() & 0xFFFEFFFF);
            this.setBlockOnOpen(false);
            this.handler = handler;
        }

        public boolean close() {
            if (this.inShellCloseEvent) {
                this.setReturnCode(-1);
            }
            boolean result = super.close();
            if (this.handler != null) {
                this.handler.closed(this.getReturnCode());
            }
            return result;
        }

        protected void handleShellCloseEvent() {
            this.inShellCloseEvent = true;
            try {
                super.handleShellCloseEvent();
            }
            finally {
                this.inShellCloseEvent = false;
            }
        }

        static interface ICloseHandler {
            public void closed(int var1);
        }
    }

    private static class PromptForRebuildJob
    extends UIJob {
        private Set<ILocation> paths = new HashSet<ILocation>();
        private ModelessMessageDialog dialog;

        public PromptForRebuildJob() {
            super(Messages.CorruptCopyFileAreaListener_0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            String cancelButton;
            String okButton;
            String message;
            String title;
            boolean multiple;
            ILocation cfa;
            Set<ILocation> set = this.paths;
            synchronized (set) {
                if (this.paths.isEmpty()) {
                    return Status.OK_STATUS;
                }
                cfa = this.paths.iterator().next();
                multiple = this.paths.size() > 1;
            }
            if (RebuildCFAJob.requiresMigration(cfa)) {
                title = Messages.CorruptCopyFileAreaListener_MigrationTitle;
                message = Messages.CorruptCopyFileAreaListener_MigrationMessage;
                okButton = Messages.CorruptCopyFileAreaListener_MigrateNow;
                cancelButton = Messages.CorruptCopyFileAreaListener_MigrateLater;
            } else {
                title = Messages.CorruptCopyFileAreaListener_RepairTitle;
                if (multiple) {
                    int size;
                    Set<ILocation> set2 = this.paths;
                    synchronized (set2) {
                        size = this.paths.size();
                    }
                    message = NLS.bind((String)Messages.CorruptCopyFileAreaListener_RepairMessageMultiple, (Object)size);
                } else {
                    message = NLS.bind((String)Messages.CorruptCopyFileAreaListener_RepairMessage, (Object)cfa.toOSString());
                }
                okButton = Messages.CorruptCopyFileAreaListener_RepairNow;
                cancelButton = Messages.CorruptCopyFileAreaListener_RepairLater;
            }
            if (this.dialog == null) {
                this.dialog = new ModelessMessageDialog(Display.getDefault().getActiveShell(), title, null, message, 3, new String[]{okButton, cancelButton}, -1, new ModelessMessageDialog.ICloseHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void closed(int returnCode) {
                        HashSet toRepair = new HashSet();
                        Set set = paths;
                        synchronized (set) {
                            dialog = null;
                            toRepair.addAll(paths);
                            paths.clear();
                        }
                        CorruptCopyFileAreaListener.getInstance().dialogClosed(returnCode, toRepair, CorruptCopyFileAreaListener.getWin());
                    }
                });
                this.dialog.create();
                this.dialog.getShell().setVisible(true);
                this.dialog.getShell().setActive();
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void promptToRebuild(ILocation root) {
            Set<ILocation> set = this.paths;
            synchronized (set) {
                this.paths.add(root);
            }
            this.schedule(10000L);
        }

        public boolean shouldRun() {
            return !this.paths.isEmpty();
        }
    }
}

