/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.configuration;

import com.ibm.team.internal.filesystem.ui.configuration.HistoryListener;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.scm.client.IWorkspaceConnection;
import java.util.List;

public class TeamPlaceUtil {
    public static void addHistoryListener(IWorkspaceConnection teamPlace, HistoryListener changeListener) {
        DeliverAdapter toAdd = new DeliverAdapter(changeListener);
        teamPlace.addGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.AcceptChangeSets", (IListener)toAdd);
        teamPlace.addGenericListener((Object)"com.ibm.team.scm.Commit", (IListener)toAdd);
        teamPlace.addGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.DiscardChangeSet", (IListener)toAdd);
    }

    public static void removeHistoryListener(IWorkspaceConnection teamPlace, HistoryListener changeListener) {
        DeliverAdapter toRemove = new DeliverAdapter(changeListener);
        teamPlace.removeGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.AcceptChangeSets", (IListener)toRemove);
        teamPlace.removeGenericListener((Object)"com.ibm.team.scm.Commit", (IListener)toRemove);
        teamPlace.removeGenericListener((Object)"com.ibm.team.scm.ChangeHistoryEvent.DiscardChangeSet", (IListener)toRemove);
    }

    private static class DeliverAdapter
    implements IListener {
        private HistoryListener l;

        public DeliverAdapter(HistoryListener changeListener) {
            this.l = changeListener;
        }

        public void handleEvents(List events) {
            boolean removed = false;
            for (IEvent event : events) {
                if (event.getEventType() != "com.ibm.team.scm.ChangeHistoryEvent.DiscardChangeSet") continue;
                removed = true;
                break;
            }
            if (removed) {
                this.l.historyChanged();
            } else {
                this.l.newChangeSets();
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof DeliverAdapter) {
                DeliverAdapter adapter = (DeliverAdapter)obj;
                return adapter.l.equals(this.l);
            }
            return false;
        }

        public int hashCode() {
            return this.l.hashCode();
        }
    }
}

