/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.configuration;

import com.ibm.team.internal.filesystem.ui.configuration.ICacheValue;
import java.security.SecureRandom;
import java.util.LinkedList;

public class SnapshotCache {
    private static volatile SnapshotCache instance;
    private ICacheValue[] values;
    private SecureRandom rand;
    private LinkedList emptyIndices = new LinkedList();
    private int cacheMisses = 0;
    private int cacheHits = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SnapshotCache getInstance() {
        if (instance != null) return instance;
        Class<SnapshotCache> clazz = SnapshotCache.class;
        synchronized (SnapshotCache.class) {
            if (instance != null) return instance;
            instance = new SnapshotCache(10);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SnapshotCache(int cacheSize) {
        this.values = new ICacheValue[cacheSize];
        int i = 0;
        while (i < cacheSize) {
            this.emptyIndices.add(new Integer(i));
            ++i;
        }
        this.rand = new SecureRandom();
    }

    public int getCacheMisses() {
        return this.cacheMisses;
    }

    public int getCacheHits() {
        return this.cacheHits;
    }

    public synchronized void touch(ICacheValue value) {
        if (value.isCaching()) {
            ++this.cacheHits;
            return;
        }
        ++this.cacheMisses;
        if (this.emptyIndices.isEmpty()) {
            int toRemove = this.rand.nextInt(this.values.length);
            ICacheValue removed = this.values[toRemove];
            removed.flush();
            this.values[toRemove] = value;
            value.startCaching();
            return;
        }
        Integer whereToAdd = (Integer)this.emptyIndices.removeFirst();
        this.values[whereToAdd.intValue()] = value;
        value.startCaching();
    }

    public synchronized void remove(ICacheValue value) {
        int idx = this.indexOf(value);
        if (idx >= this.values.length) {
            return;
        }
        this.flushIdx(idx);
    }

    private void flushIdx(int idx) {
        if (this.values[idx] == null) {
            return;
        }
        this.values[idx].flush();
        this.values[idx] = null;
        this.emptyIndices.add(new Integer(idx));
    }

    private int indexOf(ICacheValue value) {
        int i = 0;
        while (i < this.values.length && this.values[i] != value) {
            ++i;
        }
        return i;
    }

    public synchronized void flush() {
        int i = 0;
        while (i < this.values.length) {
            this.flushIdx(i);
            ++i;
        }
    }
}

