/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.configuration;

import com.ibm.team.filesystem.client.internal.era.EraDescriptor;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.NullUtil;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class HistoryIndexer {
    private boolean initialized = false;
    private HashMap<EraDescriptor, Integer> knownIndices = NewCollection.hashMap();
    private EraDescriptor origin;
    private boolean indexOfFirstEraKnown = false;
    private int indexOfFirstEra;

    public synchronized int getIndexOf(EraDescriptor descriptor, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        EraDescriptor previous = descriptor.getPreviousEra((IProgressMonitor)progress.newChild(1));
        if (!this.initialized) {
            this.initialized = true;
            if (previous != null) {
                this.knownIndices.put(previous, 0);
            }
            this.origin = previous;
        }
        EraDescriptor ancestor = previous;
        int ancestorIndex = 0;
        LinkedList eraStack = NewCollection.linkedList();
        while (!NullUtil.equals((Object)ancestor, (Object)this.origin)) {
            if (ancestor == null) {
                progress.setWorkRemaining(10);
                ancestorIndex = this.getIndexOfFirstEra((IProgressMonitor)progress.newChild(1));
                break;
            }
            Integer knownIndex = this.knownIndices.get(previous);
            if (knownIndex != null) {
                ancestorIndex = knownIndex;
                break;
            }
            eraStack.addFirst(ancestor);
            progress.setWorkRemaining(10);
            ancestor = ancestor.getPreviousEra((IProgressMonitor)progress.newChild(1));
        }
        int index = ancestorIndex;
        for (EraDescriptor next : eraStack) {
            progress.setWorkRemaining(10);
            List changeSets = next.getChangeSets((IProgressMonitor)progress.newChild(1));
            this.knownIndices.put(next, index += changeSets.size());
        }
        List changeSets = descriptor.getChangeSets((IProgressMonitor)progress.newChild(1));
        return index += changeSets.size();
    }

    private int getIndexOfFirstEra(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!this.indexOfFirstEraKnown) {
            int currentIndex = 0;
            EraDescriptor current = this.origin;
            while (true) {
                progress.setWorkRemaining(20);
                currentIndex -= current.getChangeSets((IProgressMonitor)progress.newChild(1)).size();
                current = current.getPreviousEra((IProgressMonitor)progress.newChild(1));
                if (current == null) break;
                this.knownIndices.put(current, currentIndex);
            }
            this.indexOfFirstEraKnown = true;
            this.indexOfFirstEra = currentIndex;
        }
        return this.indexOfFirstEra;
    }
}

