/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.configuration;

import java.util.HashMap;
import java.util.Set;

public final class HistogramData {
    private HashMap data = new HashMap();
    private int totalSamples = 0;

    private HistogramData(HashMap hm, int totalSamples2) {
        this.data = hm;
        this.totalSamples = totalSamples2;
    }

    public HistogramData() {
    }

    public HistogramData copy() {
        HashMap hm = new HashMap();
        hm.putAll(this.data);
        return new HistogramData(hm, this.totalSamples);
    }

    public void put(Object o, int value) {
        this.totalSamples = this.totalSamples - this.get(o) + value;
        if (value == 0) {
            this.data.remove(o);
            return;
        }
        this.data.put(o, new Integer(value));
    }

    public int get(Object o) {
        Integer result = (Integer)this.data.get(o);
        if (result == null) {
            return 0;
        }
        return result;
    }

    public void add(Object o, int toAdd) {
        this.put(o, this.get(o) + toAdd);
    }

    public void add(HistogramData toAdd) {
        for (Object next : toAdd.keySet()) {
            this.add(next, toAdd.get(next));
        }
    }

    public void subtract(HistogramData toAdd) {
        for (Object next : toAdd.keySet()) {
            this.subtract(next, toAdd.get(next));
        }
    }

    public void subtract(Object next, int i) {
        this.put(next, this.get(next) - i);
    }

    public void increment(Object o) {
        ++this.totalSamples;
        this.put(o, this.get(o) + 1);
    }

    public void decrement(Object o) {
        --this.totalSamples;
        this.put(o, this.get(o) - 1);
    }

    public Set keySet() {
        return this.data.keySet();
    }

    public int getTotalSamples() {
        return this.totalSamples;
    }

    public int totalKeys() {
        return this.data.size();
    }
}

