/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.changes;

import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.configuration.LocalConfiguration;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.changes.ColorRegistry;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;

public class CustomTreeViewer
extends TreeViewer {
    TextStyle[] styles;
    TextLayout textLayout;
    ColorRegistry colorRegistry;
    Parser parser;
    LocalConfiguration configuration;
    Font defaultFont;
    Image[] icons;
    private ResourceManager resources;
    LocalWorkspaceOwnerDrawLabelProvider odlp;
    IPropertyChangeListener colorRegistryListener;
    static final int ICON_WIDTH = 25;
    public static final String CUSTOM_TREE_ITEM_MAIN_IMAGE_BOUNDS = "com.ibm.team.internal.filesystem.ui.changes.CustomTreeViewer.TREE_ITEM_MAIN_IMAGE_BOUNDS";

    public CustomTreeViewer(final Tree tree) {
        super(tree);
        Display display = tree.getDisplay();
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)tree);
        this.colorRegistry = UiPlugin.getDefault().getColorRegistry();
        this.textLayout = new TextLayout((Device)display);
        this.colorRegistryListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String property = e.getProperty();
                if (property.equals("com.ibm.team.internal.filesystem.ui.ColorDefinitions.PENDING_CHANGES_CONFLICT_DESCRIPTION_COLOR") || property.equals("com.ibm.team.internal.filesystem.ui.ColorDefinitions.PENDING_CHANGES_DATE_COLOR") || property.equals("com.ibm.team.internal.filesystem.ui.ColorDefinitions.PENDING_CHANGES_CONTRIBUTOR_NAME_COLOR") || property.equals("com.ibm.team.internal.filesystem.ui.ColorDefinitions.PENDING_CHANGES_LOCKED_BY_OTHER_COLOR") || property.equals("com.ibm.team.internal.filesystem.ui.ColorDefinitions.PENDING_CHANGES_LOCKED_BY_ME_COLOR")) {
                    CustomTreeViewer.this.updateStyles(true);
                    tree.redraw();
                }
            }
        };
        JFaceResources.getColorRegistry().addListener(this.colorRegistryListener);
        this.styles = new TextStyle[11];
        this.updateStyles(true);
        this.createIcons();
        this.parser = new Parser(this.styles, this.icons);
        tree.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                JFaceResources.getColorRegistry().removeListener(CustomTreeViewer.this.colorRegistryListener);
                CustomTreeViewer.this.textLayout.dispose();
                DecoratingLabelProvider dlp = CustomTreeViewer.this.odlp.getDecoratingLabelProvider();
                CustomTreeViewer.this.odlp.dispose();
                dlp.dispose();
                CustomTreeViewer.this.disposeIcons();
            }
        });
    }

    public void init(DecoratingLabelProvider dlp) {
        if (this.odlp != null) {
            throw new IllegalStateException();
        }
        this.odlp = new LocalWorkspaceOwnerDrawLabelProvider(dlp);
        this.setLabelProvider((IBaseLabelProvider)this.odlp);
        LocalWorkspaceOwnerDrawLabelProvider.setUpOwnerDraw((ColumnViewer)this);
    }

    private void createIcons() {
        this.icons = new Image[6];
        this.icons[0] = ImagePool.INCOMING_CHANGE_ICON.createImage();
        this.icons[1] = ImagePool.INCOMING_CHANGE_DISABLED_ICON.createImage();
        this.icons[2] = ImagePool.OUTGOING_CHANGE_ICON.createImage();
        this.icons[3] = ImagePool.OUTGOING_CHANGE_DISABLED_ICON.createImage();
        this.icons[4] = ImagePool.OUTGOING_CHANGE_NONE_ICON.createImage();
        this.icons[5] = ImagePool.INCOMING_CHANGE_NONE_ICON.createImage();
    }

    private void disposeIcons() {
        Image[] imageArray = this.icons;
        int n = this.icons.length;
        int n2 = 0;
        while (n2 < n) {
            Image icon = imageArray[n2];
            icon.dispose();
            ++n2;
        }
    }

    private boolean updateStyles(boolean force) {
        Tree tree = this.getTree();
        Font treeFont = tree.getFont();
        if (!force && treeFont.equals((Object)this.defaultFont)) {
            return false;
        }
        FontDescriptor fd = FontDescriptor.createFrom((Font)treeFont);
        fd = fd.setStyle(2);
        Font italicFont = this.resources.createFont(fd);
        fd = FontDescriptor.createFrom((Font)treeFont);
        fd = fd.setStyle(1);
        Font boldFont = this.resources.createFont(fd);
        this.styles[0] = new TextStyle(treeFont, null, null);
        this.styles[1] = new TextStyle(treeFont, JFaceResources.getColorRegistry().get("com.ibm.team.internal.filesystem.ui.ColorDefinitions.PENDING_CHANGES_CONTRIBUTOR_NAME_COLOR"), null);
        this.styles[2] = new TextStyle(treeFont, JFaceResources.getColorRegistry().get("com.ibm.team.internal.filesystem.ui.ColorDefinitions.PENDING_CHANGES_DATE_COLOR"), null);
        this.styles[3] = new TextStyle(italicFont, JFaceResources.getColorRegistry().get("com.ibm.team.internal.filesystem.ui.ColorDefinitions.PENDING_CHANGES_DATE_COLOR"), null);
        this.styles[4] = new TextStyle(italicFont, null, null);
        this.styles[5] = new TextStyle(treeFont, JFaceResources.getColorRegistry().get("com.ibm.team.internal.filesystem.ui.ColorDefinitions.PENDING_CHANGES_CONFLICT_DESCRIPTION_COLOR"), null);
        this.styles[6] = new TextStyle(treeFont, JFaceResources.getColorRegistry().get("com.ibm.team.internal.filesystem.ui.ColorDefinitions.PENDING_CHANGES_LOCKED_BY_OTHER_COLOR"), null);
        this.styles[7] = new TextStyle(treeFont, JFaceResources.getColorRegistry().get("com.ibm.team.internal.filesystem.ui.ColorDefinitions.PENDING_CHANGES_LOCKED_BY_ME_COLOR"), null);
        this.styles[8] = new TextStyle(treeFont, JFaceResources.getColorRegistry().get("com.ibm.team.internal.filesystem.ui.ColorDefinitions.PENDING_CHANGES_DATE_COLOR"), null);
        this.styles[8].strikeout = true;
        this.styles[9] = new TextStyle(boldFont, null, null);
        this.styles[10] = new TextStyle(treeFont, JFaceResources.getColorRegistry().get("DECORATIONS_COLOR"), null);
        this.defaultFont = treeFont;
        return true;
    }

    public void setLocalConfiguration(LocalConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void handleOpen(SelectionEvent event) {
        Item item;
        Item[] items;
        Control control = this.getControl();
        if (control != null && !control.isDisposed() && (items = this.getSelection(this.getControl())).length > 0 && (item = items[0]) != event.item) {
            return;
        }
        super.handleOpen(event);
    }

    static String convertToSingleLine(String string) {
        return string.replace('\r', ' ').replace('\n', ' ');
    }

    public static String markupName(String text, boolean custom) {
        return custom ? "%1\r\n" + CustomTreeViewer.removeMarkup(text) + "%1\r\n" : text;
    }

    public static String markupDate(String text, boolean custom) {
        return custom ? "%2\r\n" + CustomTreeViewer.removeMarkup(text) + "%2\r\n" : text;
    }

    public static String markupInaccessible(String text, boolean custom) {
        return custom ? "%2\r\n" + CustomTreeViewer.removeMarkup(text) + "%2\r\n" : text;
    }

    public static String markupSpecial(String text, boolean custom) {
        return custom ? "%3\r\n" + CustomTreeViewer.removeMarkup(text) + "%3\r\n" : text;
    }

    public static String markupBusy(String text, boolean custom) {
        return custom ? "%4\r\n" + CustomTreeViewer.removeMarkup(text) + "%4\r\n" : text;
    }

    public static String markupConflict(String text, boolean custom) {
        return custom ? "%5\r\n" + CustomTreeViewer.removeMarkup(text) + "%5\r\n" : text;
    }

    public static String markupLockedByOther(String text, boolean custom) {
        return custom ? "%6\r\n" + CustomTreeViewer.removeMarkup(text) + "%6\r\n" : text;
    }

    public static String markupLockedByMe(String text, boolean custom) {
        return custom ? "%7\r\n" + CustomTreeViewer.removeMarkup(text) + "%7\r\n" : text;
    }

    public static String markupGrayStrikeout(String text, boolean custom) {
        return custom ? "%8\r\n" + CustomTreeViewer.removeMarkup(text) + "%8\r\n" : text;
    }

    public static String markupBold(String text, boolean custom) {
        return custom ? "%9\r\n" + CustomTreeViewer.removeMarkup(text) + "%9\r\n" : text;
    }

    public static String markupDecorations(String text, boolean custom) {
        return custom ? "%10\r\n" + CustomTreeViewer.removeMarkup(text) + "%10\r\n" : text;
    }

    public static String markupIconIncomingChange(boolean custom) {
        return custom ? "%icon0\r\n" : "";
    }

    public static String markupIconIncomingChangeDisabled(boolean custom) {
        return custom ? "%icon1\r\n" : "";
    }

    public static String markupIconIncomingChangeNone(boolean custom) {
        return custom ? "%icon5\r\n" : "";
    }

    public static String markupIconOutgoingChange(boolean custom) {
        return custom ? "%icon2\r\n" : "";
    }

    public static String markupIconOutgoingChangeDisabled(boolean custom) {
        return custom ? "%icon3\r\n" : "";
    }

    public static String markupIconOutgoingChangeNone(boolean custom) {
        return custom ? "%icon4\r\n" : "";
    }

    public static String removeMarkup(String text) {
        String substitute = "";
        if (text == null) {
            return substitute;
        }
        return text.replace("%1\r\n", substitute).replace("%2\r\n", substitute).replace("%3\r\n", substitute).replace("%4\r\n", substitute).replace("%5\r\n", substitute).replace("%6\r\n", substitute).replace("%7\r\n", substitute).replace("%8\r\n", substitute).replace("%9\r\n", substitute).replace("%10\r\n", substitute);
    }

    class FormatData {
        TextLayout textLayout;
        String text;
        GC gc;
        int[] imageOffsets;
        int[] imageIds;

        FormatData() {
        }
    }

    class IconInfo {
        Image icon;
        int offset;

        IconInfo() {
        }
    }

    private final class LocalWorkspaceOwnerDrawLabelProvider
    extends OwnerDrawLabelProvider
    implements ILabelProvider {
        DecoratingLabelProvider dlp;
        private ILabelProviderListener nestedLabelProviderListener = new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                LabelProviderChangedEvent toSend = new LabelProviderChangedEvent((IBaseLabelProvider)LocalWorkspaceOwnerDrawLabelProvider.this, event.getElements());
                LocalWorkspaceOwnerDrawLabelProvider.this.fireLabelProviderChanged(toSend);
            }
        };

        public LocalWorkspaceOwnerDrawLabelProvider(DecoratingLabelProvider dlp) {
            this.dlp = dlp;
            dlp.addListener(this.nestedLabelProviderListener);
        }

        public void dispose() {
            this.dlp.removeListener(this.nestedLabelProviderListener);
            super.dispose();
        }

        public DecoratingLabelProvider getDecoratingLabelProvider() {
            return this.dlp;
        }

        protected void measure(Event event, Object element) {
            if (element == null) {
                return;
            }
            String text = this.dlp.getText(element);
            if (text == null) {
                StatusUtil.log((Object)((Object)this), (String)("PC Label provider returns null for element " + element));
                return;
            }
            FormatData data = new FormatData();
            data.textLayout = CustomTreeViewer.this.textLayout;
            data.text = text;
            CustomTreeViewer.this.parser.format(data);
            Rectangle textLayoutBounds = CustomTreeViewer.this.textLayout.getBounds();
            event.width = textLayoutBounds.width + 2 + 25;
            event.height = textLayoutBounds.height + 2;
        }

        protected void paint(Event event, Object element) {
            if (element == null) {
                return;
            }
            CustomTreeViewer.this.updateStyles(false);
            String text = this.dlp.getText(element);
            if (text == null) {
                StatusUtil.log((Object)((Object)this), (String)("PC Label provider returns null for element " + element));
                return;
            }
            boolean selected = (event.detail & 2) != 0 && CustomTreeViewer.this.getTree().isFocusControl();
            FormatData data = new FormatData();
            data.textLayout = CustomTreeViewer.this.textLayout;
            data.text = text;
            data.gc = selected ? event.gc : null;
            CustomTreeViewer.this.parser.format(data);
            Image image = this.dlp.getImage(element);
            if (image != null) {
                int x = event.x;
                int y = event.y + (event.height - image.getBounds().height) / 2;
                event.gc.drawImage(image, x, y);
                if (event.item != null) {
                    Rectangle rect = image.getBounds();
                    Rectangle bounds = new Rectangle(x, y, rect.width, rect.height);
                    event.item.setData(CustomTreeViewer.CUSTOM_TREE_ITEM_MAIN_IMAGE_BOUNDS, (Object)bounds);
                }
            }
            CustomTreeViewer.this.textLayout.draw(event.gc, event.x + 25, event.y + (event.height - CustomTreeViewer.this.textLayout.getBounds().height) / 2);
            IconInfo[] iconInfoArray = CustomTreeViewer.this.parser.getIconInfos();
            int n = iconInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IconInfo info = iconInfoArray[n2];
                Point pt = CustomTreeViewer.this.textLayout.getLocation(info.offset, false);
                event.gc.drawImage(info.icon, event.x + pt.x + 25, event.y + (event.height - image.getBounds().height) / 2);
                ++n2;
            }
        }

        protected void erase(Event event, Object element) {
            Color color;
            if (element == null) {
                return;
            }
            GC gc = event.gc;
            if (CustomTreeViewer.this.configuration != null && (color = CustomTreeViewer.this.configuration.getBackgroundColor(element)) != null) {
                Rectangle area = CustomTreeViewer.this.getTree().getClientArea();
                int columnCount = CustomTreeViewer.this.getTree().getColumnCount();
                if (event.index == columnCount - 1 || columnCount == 0) {
                    int width = area.x + area.width - event.x;
                    if (width > 0) {
                        Region region = new Region();
                        gc.getClipping(region);
                        region.add(event.x, event.y, width, event.height);
                        gc.setClipping(region);
                        region.dispose();
                    }
                    gc.setBackground(color);
                    gc.fillRectangle(event.x, event.y, width, event.height);
                }
            }
            event.detail &= 0xFFFFFFEF;
        }

        public void update(ViewerCell cell) {
            super.update(cell);
            Object element = cell.getElement();
            cell.setText(CustomTreeViewer.convertToSingleLine(CustomTreeViewer.removeMarkup(this.dlp.getText(element))));
        }

        public Image getImage(Object element) {
            return this.dlp.getImage(element);
        }

        public String getText(Object element) {
            return this.dlp.getText(element);
        }
    }

    class Parser {
        TextStyle[] styles;
        List<String> contents;
        List<TextStyle> contentStyles;
        String[] types;
        String userText;
        Image[] icons;
        String[] iconTypes;
        List<IconInfo> iconInfos;

        public Parser(TextStyle[] styles, Image[] icons) {
            this.styles = styles;
            this.icons = icons;
            this.contents = new ArrayList<String>();
            this.contentStyles = new ArrayList<TextStyle>();
            this.types = new String[styles.length];
            this.iconTypes = new String[icons.length];
            int i = 0;
            while (i < this.types.length) {
                this.types[i] = "%" + i + "\r\n";
                ++i;
            }
            i = 0;
            while (i < this.iconTypes.length) {
                this.iconTypes[i] = "%icon" + i + "\r\n";
                ++i;
            }
            this.iconInfos = new ArrayList<IconInfo>();
        }

        TextStyle[] getContentStyle() {
            return this.contentStyles.toArray(new TextStyle[this.contentStyles.size()]);
        }

        String[] getContent() {
            return this.contents.toArray(new String[this.contents.size()]);
        }

        IconInfo[] getIconInfos() {
            return this.iconInfos.toArray(new IconInfo[this.iconInfos.size()]);
        }

        boolean hasMarkup(String text) {
            int iconType;
            int type;
            if (text == null) {
                return false;
            }
            int beginIndex = -1;
            do {
                if ((beginIndex = text.indexOf("%", beginIndex + 1)) == -1) {
                    return false;
                }
                type = this.getType(text, beginIndex);
                iconType = this.getIconType(text, beginIndex);
            } while (type == -1 && iconType == -1);
            if (type != -1) {
                return text.indexOf(this.types[type], beginIndex + this.types[type].length()) != -1;
            }
            return text.indexOf(this.iconTypes[iconType], beginIndex + this.iconTypes[iconType].length()) != -1;
        }

        void format(FormatData data) {
            this.parseContent(data.text);
            int beginIndex = 0;
            CustomTreeViewer.this.textLayout.setText(this.userText);
            Iterator<String> i1 = this.contents.iterator();
            Iterator<TextStyle> i2 = this.contentStyles.iterator();
            int i = 0;
            while (i < this.contents.size()) {
                String content = i1.next();
                int endIndex = beginIndex + content.length();
                TextStyle style = i2.next();
                if (data.gc != null) {
                    boolean isStrikeout = style.strikeout;
                    style = new TextStyle(style.font, data.gc.getForeground(), null);
                    style.strikeout = isStrikeout;
                }
                CustomTreeViewer.this.textLayout.setStyle(style, beginIndex, endIndex);
                beginIndex = endIndex;
                ++i;
            }
            for (IconInfo info : this.iconInfos) {
                TextStyle imageStyle = new TextStyle(null, null, null);
                Rectangle bounds = info.icon.getBounds();
                FontMetrics fm = CustomTreeViewer.this.textLayout.getLineMetrics(0);
                imageStyle.metrics = new GlyphMetrics(fm.getAscent(), fm.getDescent(), bounds.width);
                CustomTreeViewer.this.textLayout.setStyle(imageStyle, info.offset, info.offset);
            }
        }

        int getType(String text, int toOffset) {
            if (toOffset == -1) {
                return -1;
            }
            int i = 0;
            while (i < this.types.length) {
                if (text.startsWith(this.types[i], toOffset)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        int getIconType(String text, int toOffset) {
            if (toOffset == -1) {
                return -1;
            }
            int i = 0;
            while (i < this.iconTypes.length) {
                if (text.startsWith(this.iconTypes[i], toOffset)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        void parseContent(String text) {
            this.contents.clear();
            this.contentStyles.clear();
            this.iconInfos.clear();
            int beginIndex = -1;
            this.userText = "";
            while ((beginIndex = text.indexOf("%", beginIndex + 1)) != -1) {
                int type = this.getType(text, beginIndex);
                int iconType = this.getIconType(text, beginIndex);
                if (type != -1) {
                    String content;
                    int endIndex = text.indexOf(this.types[type], beginIndex + this.types[type].length());
                    if (endIndex == -1) break;
                    if (beginIndex != 0) {
                        content = CustomTreeViewer.convertToSingleLine(text.substring(0, beginIndex));
                        this.userText = String.valueOf(this.userText) + content;
                        this.contents.add(content);
                        this.contentStyles.add(this.styles[0]);
                    }
                    content = CustomTreeViewer.convertToSingleLine(text.substring(beginIndex + this.types[type].length(), endIndex));
                    this.userText = String.valueOf(this.userText) + content;
                    this.contents.add(content);
                    this.contentStyles.add(this.styles[type]);
                    text = text.substring(endIndex + this.types[type].length());
                    beginIndex = -1;
                    continue;
                }
                if (iconType == -1) continue;
                IconInfo info = new IconInfo();
                info.icon = this.icons[iconType];
                info.offset = this.userText.length() + beginIndex;
                this.iconInfos.add(info);
                text = String.valueOf(text.substring(0, beginIndex)) + '\ufffc' + text.substring(beginIndex + this.iconTypes[iconType].length());
                beginIndex = -1;
            }
            if (text.length() != 0) {
                String content = CustomTreeViewer.convertToSingleLine(text);
                this.userText = String.valueOf(this.userText) + content;
                this.contents.add(content);
                this.contentStyles.add(this.styles[0]);
            }
        }
    }
}

