/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.adapters.persistance;

import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.MementoUtil;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IMemento;

public class ItemPersistence {
    public static final String UUID_ID = "uuid";
    public static final String TYPE_NAME_ID = "type";
    public static final String TYPE_NAMESPACE_ID = "namespace";
    private static final String ITEM_ID = "ItemId";
    private static final String NAMESPACE_ID = "Namespace";
    public static final String STATE_ID = "StateId";

    public static UUID getUUID(IMemento memento, String elementId) throws CoreException {
        String uuidValue = MementoUtil.getString((IMemento)memento, (String)elementId);
        try {
            UUID uuid = UUID.valueOf((String)uuidValue);
            return uuid;
        }
        catch (IllegalArgumentException e) {
            throw new CoreException(StatusUtil.newStatus(ItemPersistence.class, (Throwable)e));
        }
    }

    public static ItemId loadItemId(IMemento memento) throws CoreException {
        UUID uuid = ItemPersistence.getUUID(memento, UUID_ID);
        String type = MementoUtil.getString((IMemento)memento, (String)TYPE_NAME_ID, (String)"");
        String typeNamespace = MementoUtil.getString((IMemento)memento, (String)TYPE_NAMESPACE_ID, (String)"");
        IItemType itemType = IItemType.IRegistry.INSTANCE.getItemType(type, typeNamespace);
        return new ItemId(itemType, uuid);
    }

    public static Object loadState(IMemento memento, String factoryId) throws CoreException {
        if (factoryId.equals(ItemId.class.getName())) {
            return ItemPersistence.loadItemId(memento);
        }
        if (factoryId.equals(ItemLocator.class.getName())) {
            ItemId item = (ItemId)MementoUtil.loadRequiredChild((IMemento)memento, (String)ITEM_ID, ItemId.class);
            ItemNamespace namespace = (ItemNamespace)MementoUtil.loadRequiredChild((IMemento)memento, (String)NAMESPACE_ID, ItemNamespace.class);
            return ItemLocator.create((ItemNamespace)namespace, (ItemId)item);
        }
        if (factoryId.equals(StateId.class.getName())) {
            UUID stateId = ItemPersistence.getUUID(memento, STATE_ID);
            ItemId itemId = ItemPersistence.loadItemId(memento);
            return new StateId(itemId, stateId);
        }
        return null;
    }

    public static String saveState(ItemId theItem, IMemento memento) {
        memento.putString(UUID_ID, theItem.getItemUUID().getUuidValue());
        memento.putString(TYPE_NAME_ID, theItem.getItemType().getName());
        memento.putString(TYPE_NAMESPACE_ID, theItem.getItemType().getNamespaceURI());
        return null;
    }

    public static String saveState(ItemLocator toSave, IMemento memento) {
        MementoUtil.saveChild((IMemento)memento, (String)NAMESPACE_ID, (Object)toSave.getNamespace());
        MementoUtil.saveChild((IMemento)memento, (String)ITEM_ID, (Object)toSave.getItemId());
        return null;
    }

    public static String saveState(StateId theState, IMemento memento) throws CoreException {
        memento.putString(STATE_ID, theState.getStateUUID().getUuidValue());
        ItemPersistence.saveState(theState.getItemId(), memento);
        return null;
    }

    public static void putUUID(IMemento memento, String string, UUID itemUUID) {
        memento.putString(string, itemUUID.getUuidValue());
    }

    public static void putRepository(IMemento memento, String repoId, ITeamRepository repo) {
        memento.putString(repoId, repo.getRepositoryURI());
    }

    public static ItemId<IComponent> getComponent(IMemento memento, String id) throws CoreException {
        UUID componentId = ItemPersistence.getUUID(memento, id);
        return new ItemId(IComponent.ITEM_TYPE, componentId);
    }

    public static void putComponent(IMemento memento, String id, ItemId<IComponent> component) {
        memento.putString(id, component.getItemUUID().getUuidValue());
    }
}

