/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.adapters;

import com.ibm.team.filesystem.client.internal.namespace.BaselineNamespace;
import com.ibm.team.filesystem.client.internal.namespace.EraNamespace;
import com.ibm.team.filesystem.client.internal.namespace.ItemFetcher;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.BaselineId;
import com.ibm.team.filesystem.client.internal.snapshot.BaselineSetId;
import com.ibm.team.filesystem.client.internal.snapshot.NamespaceSetId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.WorkspaceId;
import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISubcomponentChange;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.ui.configuration.IHistoryEntry;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.RawSnapshotWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.PendingChangesUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.ISimpleItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class WrapperUtil {
    public static Object createWrapperFromNamespace(ItemNamespace namespace, IProgressMonitor monitor) throws TeamRepositoryException {
        return WrapperUtil.createWrapperFromNamespace(Collections.singleton(namespace), monitor).get(namespace);
    }

    public static Map<ItemNamespace, Object> createWrapperFromNamespace(Collection<ItemNamespace> namespaces, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repo;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashSet<ItemLocator> itemsToFetch = new HashSet<ItemLocator>();
        HashSet<ItemLocator> workspaceConnectionsToObtain = new HashSet<ItemLocator>();
        for (ItemNamespace next : namespaces) {
            ITeamRepository repo2 = next.getRepository();
            if (next instanceof WorkspaceNamespace) {
                WorkspaceNamespace workspace = (WorkspaceNamespace)next;
                workspaceConnectionsToObtain.add(ItemLocator.create((ITeamRepository)repo2, (ItemId)workspace.getWorkspaceId()));
                itemsToFetch.add(ItemLocator.create((ITeamRepository)repo2, (ItemId)workspace.getComponentId()));
                continue;
            }
            if (!(next instanceof BaselineNamespace)) continue;
            BaselineNamespace bn = (BaselineNamespace)next;
            itemsToFetch.add(ItemLocator.create((ITeamRepository)repo2, (ItemId)bn.getBaselineId()));
        }
        Map fetched = ItemFetcher.fetchCurrents(itemsToFetch, (boolean)false, (IProgressMonitor)progress.newChild(70));
        HashSet<ItemLocator> componentsToFetch = new HashSet<ItemLocator>();
        for (ItemNamespace next : namespaces) {
            BaselineNamespace bn;
            Object baseline;
            IBaseline fetchedBaseline;
            ItemLocator component;
            ITeamRepository repo3 = next.getRepository();
            if (!(next instanceof BaselineNamespace) || fetched.containsKey(component = ItemLocator.create((ITeamRepository)repo3, (ItemId)ItemUtil.getComponent((IComponentHandle)(fetchedBaseline = (IBaseline)fetched.get(baseline = ItemLocator.create((ITeamRepository)repo3, (ItemId)(bn = (BaselineNamespace)next).getBaselineId()))).getComponent())))) continue;
            ItemLocator toFetch = ItemLocator.upcast((ItemLocator)component);
            componentsToFetch.add(toFetch);
        }
        fetched.putAll(ItemFetcher.fetchCurrents(componentsToFetch, (boolean)false, (IProgressMonitor)progress.newChild(10)));
        HashMap<ItemLocator, IWorkspaceConnection> fetchedWorkspaceConnections = new HashMap<ItemLocator, IWorkspaceConnection>();
        SubMonitor workspaceFetchProgress = progress.newChild(15).setWorkRemaining(workspaceConnectionsToObtain.size());
        Map workspacesByRepository = ItemLocator.groupByNamespace(workspaceConnectionsToObtain);
        for (ItemNamespace repository : workspacesByRepository.keySet()) {
            List workspaces = (List)workspacesByRepository.get(repository);
            repo = repository.getRepository();
            IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            List connections = mgr.getWorkspaceConnections(ItemLists.idsToHandles((Collection)workspaces), (IProgressMonitor)workspaceFetchProgress.newChild(workspaces.size()));
            for (IWorkspaceConnection next : connections) {
                if (next == null) continue;
                ItemLocator wid = ItemLocator.create((ITeamRepository)next.teamRepository(), (ISimpleItemHandle)next.getResolvedWorkspace());
                fetchedWorkspaceConnections.put(wid, next);
            }
        }
        HashMap<ItemNamespace, Object> result = new HashMap<ItemNamespace, Object>();
        for (ItemNamespace next : namespaces) {
            IComponent component;
            BaselineNamespace bn;
            ItemLocator baselineId;
            IBaseline baseline;
            repo = next.getRepository();
            if (next instanceof WorkspaceNamespace) {
                WorkspaceNamespace workspace = (WorkspaceNamespace)next;
                ItemLocator workspaceLocator = ItemLocator.create((ITeamRepository)repo, (ItemId)workspace.getWorkspaceId());
                ItemLocator componentId = ItemLocator.create((ITeamRepository)repo, (ItemId)workspace.getComponentId());
                IWorkspaceConnection conn = (IWorkspaceConnection)fetchedWorkspaceConnections.get(workspaceLocator);
                IComponent component2 = (IComponent)fetched.get(componentId);
                if (conn != null && component2 != null) {
                    result.put(next, WorkspaceComponentWrapper.newWrapper(conn, component2));
                    continue;
                }
            }
            if (next instanceof BaselineNamespace && (baseline = (IBaseline)fetched.get(baselineId = ItemLocator.create((ITeamRepository)repo, (ItemId)(bn = (BaselineNamespace)next).getBaselineId()))) != null && (component = (IComponent)fetched.get(ItemLocator.create((ITeamRepository)repo, (IAuditableHandle)baseline.getComponent()))) != null) {
                result.put(next, new BaselineWrapper(repo, baseline, component));
                continue;
            }
            if (next instanceof EraNamespace) {
                ItemId componentId = next.fetchComponentId((IProgressMonitor)progress.newChild(2));
                result.put(next, (Object)ComponentWrapper.createFrom(repo, (ItemId<IComponent>)componentId, (IProgressMonitor)progress.newChild(3)));
                continue;
            }
            result.put(next, Messages.WrapperUtil_0);
        }
        return result;
    }

    public static ItemNamespace getNamespaceFor(Object wrapper) {
        IHistoryEntry entry;
        ISubcomponentChange change;
        IWorkspaceConnection wc;
        if (wrapper instanceof IComponentSyncContext) {
            IComponentSyncContext context = (IComponentSyncContext)wrapper;
            if (context.isOfType(32)) {
                return PendingChangesUtil.getRemoteOutgoingNamespace(context);
            }
            if (context.isOfType(64)) {
                return PendingChangesUtil.getRemoteIncomingNamespace(context);
            }
            return PendingChangesUtil.getLocalNamespace(context);
        }
        if (wrapper instanceof ISubcomponentChange && (wc = (change = (ISubcomponentChange)wrapper).getContainingWorkspaceConnection()) != null && !change.isComponentInaccessible() && !change.isComponentMissingFromWorkspace()) {
            return WorkspaceNamespace.create((ITeamRepository)change.getRemoteActivity().getActivitySource().getTeamRepository(), (IWorkspaceHandle)wc.getResolvedWorkspace(), (IComponentHandle)change.getComponentHandle());
        }
        if (wrapper instanceof BaselineWrapper) {
            BaselineWrapper bw = (BaselineWrapper)wrapper;
            return BaselineNamespace.create((ITeamRepository)bw.getRepository(), (IBaselineHandle)bw.getBaseline());
        }
        if (wrapper instanceof WorkspaceComponentWrapper) {
            WorkspaceComponentWrapper wcw = (WorkspaceComponentWrapper)wrapper;
            return WorkspaceNamespace.create((ITeamRepository)wcw.getRepository(), (IWorkspaceHandle)wcw.getWorkspace(), (IComponentHandle)wcw.getComponent());
        }
        if (wrapper instanceof IHistoryEntry && (entry = (IHistoryEntry)wrapper).hasSnapshot()) {
            return entry.getStaticNamespace();
        }
        return null;
    }

    public static SnapshotId getSnapshotFromWrapper(Object wrapper) {
        if (wrapper != null && Adapters.hasAdapter((Object)wrapper, AbstractPlaceWrapper.class)) {
            AbstractPlaceWrapper apw = (AbstractPlaceWrapper)((Object)Adapters.getAdapter((Object)wrapper, AbstractPlaceWrapper.class));
            return WorkspaceId.create((ITeamRepository)apw.getRepository(), (IWorkspaceHandle)apw.getWorkspace());
        }
        if (wrapper != null && Adapters.hasAdapter((Object)wrapper, RawSnapshotWrapper.class)) {
            RawSnapshotWrapper sw = (RawSnapshotWrapper)((Object)Adapters.getAdapter((Object)wrapper, RawSnapshotWrapper.class));
            return BaselineSetId.create((ITeamRepository)sw.getRepository(), (IBaselineSetHandle)sw.getSnapshot());
        }
        if (wrapper instanceof BaselineWrapper) {
            BaselineWrapper bw = (BaselineWrapper)wrapper;
            return BaselineId.create((ITeamRepository)bw.getRepository(), (IBaselineHandle)bw.getBaseline());
        }
        if (wrapper instanceof IWorkspaceSyncContext) {
            IWorkspaceSyncContext wcs = (IWorkspaceSyncContext)wrapper;
            return PendingChangesUtil.getLocalSnapshot(wcs);
        }
        ItemNamespace namespace = WrapperUtil.getNamespaceFor(wrapper);
        if (namespace != null) {
            return NamespaceSetId.create((ItemNamespace)namespace);
        }
        return null;
    }

    public static Map<SnapshotId, Object> createWrappersFromSnapshots(Collection<SnapshotId> snapshots, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashSet<ItemLocator> toFetch = new HashSet<ItemLocator>();
        for (SnapshotId next : snapshots) {
            ItemLocator loc;
            if (next instanceof BaselineSetId) {
                BaselineSetId baselineSet = (BaselineSetId)next;
                loc = ItemLocator.upcast((ItemLocator)baselineSet.getId());
                toFetch.add(loc);
            }
            if (next instanceof WorkspaceId) {
                WorkspaceId wid = (WorkspaceId)next;
                loc = ItemLocator.upcast((ItemLocator)wid.getId());
                toFetch.add(loc);
            }
            if (!(next instanceof BaselineId)) continue;
            BaselineId bid = (BaselineId)next;
            loc = ItemLocator.upcast((ItemLocator)bid.getId());
            toFetch.add(loc);
        }
        Map fetched = ItemFetcher.fetchCurrents(toFetch, (boolean)false, (IProgressMonitor)progress.newChild(80));
        HashSet<ItemLocator> componentsToFetch = new HashSet<ItemLocator>();
        HashMap<SnapshotId, Object> result = new HashMap<SnapshotId, Object>();
        for (SnapshotId next : snapshots) {
            ItemLocator loc;
            if (next instanceof BaselineSetId) {
                BaselineSetId baselineSet = (BaselineSetId)next;
                loc = ItemLocator.upcast((ItemLocator)baselineSet.getId());
                IBaselineSet baselineSetSharedItem = (IBaselineSet)fetched.get(loc);
                result.put(next, (Object)new RawSnapshotWrapper(baselineSetSharedItem));
            }
            if (next instanceof WorkspaceId) {
                WorkspaceId wid = (WorkspaceId)next;
                loc = ItemLocator.upcast((ItemLocator)wid.getId());
                IWorkspace workspace = (IWorkspace)fetched.get(loc);
                result.put(next, (Object)AbstractPlaceWrapper.newWrapper(workspace));
            }
            if (!(next instanceof BaselineId)) continue;
            BaselineId bid = (BaselineId)next;
            loc = ItemLocator.upcast((ItemLocator)bid.getId());
            IBaseline baseline = (IBaseline)fetched.get(loc);
            componentsToFetch.add(ItemLocator.create((ITeamRepository)loc.getRepository(), (IAuditableHandle)baseline.getComponent()));
        }
        Map fetchedComponents = ItemFetcher.fetchCurrents(componentsToFetch, (boolean)false, (IProgressMonitor)progress.newChild(20));
        for (SnapshotId next : snapshots) {
            if (!(next instanceof BaselineId)) continue;
            BaselineId bid = (BaselineId)next;
            ItemLocator loc = ItemLocator.upcast((ItemLocator)bid.getId());
            IBaseline baseline = (IBaseline)fetched.get(loc);
            ItemLocator componentId = ItemLocator.create((ITeamRepository)loc.getRepository(), (IAuditableHandle)baseline.getComponent());
            IComponent component = (IComponent)fetchedComponents.get(componentId);
            result.put(next, new BaselineWrapper(bid.getRepository(), baseline, component));
        }
        return result;
    }

    public static Object createWrapperFromSnapshot(SnapshotId snapshot, IProgressMonitor monitor) throws TeamRepositoryException {
        return WrapperUtil.createWrappersFromSnapshots(Collections.singleton(snapshot), monitor).get(snapshot);
    }
}

