/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.adapters;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IFileSystemWorkItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISourceChangeSet;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ChangeSetNode;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetInContextWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWithLinksWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.links.common.ILink;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.ui.internal.utils.EclipseAdapterFactory;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdapterFactory;

public class SourceChangeSetAdapter
extends EclipseAdapterFactory
implements IAdapterFactory {
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof ISourceChangeSet) {
            ISourceChangeSet sourceChangeSet = (ISourceChangeSet)adaptableObject;
            if (adapterType == ChangeSetInContextWrapper.class) {
                return SourceChangeSetAdapter.convertToChangeSetInContextWrapper(sourceChangeSet);
            }
            if (adapterType == ChangeSetWithLinksWrapper.class) {
                return SourceChangeSetAdapter.convertToChangeSetWithLinksWrapper(sourceChangeSet);
            }
            if (adapterType == ChangeSetWrapper.class) {
                return SourceChangeSetAdapter.convertToChangeSetInContextWrapper(sourceChangeSet);
            }
        }
        return null;
    }

    public static List<ChangeSetWrapper> convertToChangeSetWrappers(List<ISourceChangeSet> sourceChangeSets) {
        ArrayList result = NewCollection.arrayList();
        for (ISourceChangeSet next : sourceChangeSets) {
            result.add(SourceChangeSetAdapter.convertToChangeSetWrapper(next));
        }
        return result;
    }

    public static ChangeSetWrapper convertToChangeSetWrapper(ISourceChangeSet sourceChangeSet) {
        ITeamRepository repo = sourceChangeSet.getRemoteActivity().getActivitySource().getModel().localTeamRepository();
        IChangeSet changeSet = sourceChangeSet.getChangeSet();
        return changeSet != null ? new ChangeSetWrapper(repo, changeSet, true) : null;
    }

    public static ChangeSetInContextWrapper convertToChangeSetInContextWrapper(ISourceChangeSet sourceChangeSet) {
        ItemNamespace namespace = SourceChangeSetAdapter.getNamespaceFor(sourceChangeSet);
        IChangeSet changeSet = sourceChangeSet.getChangeSet();
        return changeSet != null && namespace != null ? new ChangeSetInContextWrapper(namespace, changeSet, true) : null;
    }

    public static ChangeSetWithLinksWrapper convertToChangeSetWithLinksWrapper(ISourceChangeSet sourceChangeSet) {
        IChangeSet changeSet = sourceChangeSet.getChangeSet();
        if (changeSet == null) {
            return null;
        }
        List linkProxies = sourceChangeSet.getWorkItems();
        ArrayList<ILink> links = new ArrayList<ILink>();
        for (IFileSystemWorkItem link : linkProxies) {
            links.add(link.getLink());
        }
        ItemNamespace namespace = SourceChangeSetAdapter.getNamespaceFor(sourceChangeSet);
        return namespace != null ? new ChangeSetWithLinksWrapper(namespace, changeSet, links, true) : null;
    }

    public static ItemNamespace getNamespaceFor(ISourceChangeSet sourceChangeSet) {
        IActivitySource source = sourceChangeSet.getRemoteActivity().getActivitySource();
        IComponentSyncContext context = source.getModel();
        IWorkspace workspace = source.getWorkspace();
        IWorkspace connectionHandle = workspace != null ? workspace : source.getBaseline();
        ITeamRepository repo = context.localTeamRepository();
        if (sourceChangeSet instanceof ChangeSetNode) {
            repo = ((ChangeSetNode)sourceChangeSet).teamPlace.teamRepository();
        }
        return connectionHandle != null ? ItemNamespace.getNamespace((ITeamRepository)repo, (IContextHandle)connectionHandle, (IComponentHandle)context.getComponent()) : null;
    }
}

