/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.adapters;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IFileSystemWorkItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ChangeSetNode;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetInContextWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWithLinksWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.links.common.ILink;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.ui.internal.utils.EclipseAdapterFactory;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdapterFactory;

public class RemoteActivityAdapter
extends EclipseAdapterFactory
implements IAdapterFactory {
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IRemoteActivity) {
            IRemoteActivity activity = (IRemoteActivity)adaptableObject;
            if (adapterType == ChangeSetInContextWrapper.class) {
                return RemoteActivityAdapter.convertToChangeSetInContextWrapper(activity);
            }
            if (adapterType == ChangeSetWithLinksWrapper.class) {
                return RemoteActivityAdapter.convertToChangeSetWithLinksWrapper(activity);
            }
            if (adapterType == ChangeSetWrapper.class) {
                return RemoteActivityAdapter.convertToChangeSetInContextWrapper(activity);
            }
        }
        return null;
    }

    public static List<ChangeSetWrapper> convertToChangeSetWrappers(List<IRemoteActivity> activities) {
        ArrayList result = NewCollection.arrayList();
        for (IRemoteActivity next : activities) {
            result.add(RemoteActivityAdapter.convertToChangeSetWrapper(next));
        }
        return result;
    }

    public static ChangeSetWrapper convertToChangeSetWrapper(IRemoteActivity activity) {
        ITeamRepository repo = activity.getActivitySource().getModel().localTeamRepository();
        IChangeSet changeSet = activity.getChangeSet();
        return changeSet != null ? new ChangeSetWrapper(repo, changeSet) : null;
    }

    public static ChangeSetInContextWrapper convertToChangeSetInContextWrapper(IRemoteActivity activity) {
        ItemNamespace namespace = RemoteActivityAdapter.getNamespaceFor(activity);
        IChangeSet changeSet = activity.getChangeSet();
        return changeSet != null && namespace != null ? new ChangeSetInContextWrapper(namespace, changeSet) : null;
    }

    public static ChangeSetWithLinksWrapper convertToChangeSetWithLinksWrapper(IRemoteActivity activity) {
        IChangeSet changeSet = activity.getChangeSet();
        if (changeSet == null) {
            return null;
        }
        List linkProxies = activity.getWorkItems();
        ArrayList<ILink> links = new ArrayList<ILink>();
        for (IFileSystemWorkItem link : linkProxies) {
            links.add(link.getLink());
        }
        ItemNamespace namespace = RemoteActivityAdapter.getNamespaceFor(activity);
        return namespace != null ? new ChangeSetWithLinksWrapper(namespace, changeSet, links) : null;
    }

    public static ItemNamespace getNamespaceFor(IRemoteActivity activity) {
        IActivitySource source = activity.getActivitySource();
        IComponentSyncContext context = source.getModel();
        IWorkspace workspace = source.getWorkspace();
        IWorkspace connectionHandle = workspace != null ? workspace : source.getBaseline();
        ITeamRepository repo = context.localTeamRepository();
        if (activity instanceof ChangeSetNode) {
            repo = ((ChangeSetNode)activity).teamPlace.teamRepository();
        }
        return connectionHandle != null ? ItemNamespace.getNamespace((ITeamRepository)repo, (IContextHandle)connectionHandle, (IComponentHandle)context.getComponent()) : null;
    }
}

