/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.adapters;

import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.filesystem.ui.configuration.IHistoryEntry;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.adapters.IChangeSetSelector;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jface.viewers.IFilter;

public class ChangeSetSelectionTester
implements IFilter,
IChangeSetSelector {
    private Set<ItemId<IChangeSet>> selection;
    private ItemId<IChangeSet> visibleChangeSet;

    public ChangeSetSelectionTester(Set<ItemId<IChangeSet>> toSelect) {
        this.selection = toSelect;
        this.visibleChangeSet = toSelect.isEmpty() ? ItemId.getNullItem((IItemType)IChangeSet.ITEM_TYPE) : toSelect.iterator().next();
    }

    public ChangeSetSelectionTester(ItemId<IChangeSet> toSelect) {
        this(Collections.singleton(toSelect));
    }

    public boolean select(Object object) {
        IHistoryEntry entry = (IHistoryEntry)object;
        ChangeSetWrapper csw = entry.getChangeSet();
        ItemId changeSet = ChangeSetUtil.getChangeSet((IChangeSetHandle)(csw == null ? null : csw.getChangeSet()));
        return this.selection.contains(changeSet);
    }

    @Override
    public ItemId<IChangeSet> getSelectedChangeSet() {
        return this.visibleChangeSet;
    }
}

