/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.adapters;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IActionFilter;

public abstract class AbstractAdaptableRemoteResource
implements IAdaptable,
IActionFilter {
    private static final String RESOURCE_TYPE = "resourceType";
    private static final String RESOURCE_TYPE_FILE = "file";
    private static final String RESOURCE_TYPE_FOLDER = "folder";
    private static final String RESOURCE_TYPE_SYMLINK = "symlink";
    static final String IS_UNSHARED = "isUnshared";
    static final String IS_CONTRIBUTE_TEAM_ACTIONS = "isContributeTeamActions";
    private boolean contributeTeamActions = true;

    public AbstractAdaptableRemoteResource() {
    }

    public AbstractAdaptableRemoteResource(boolean contributeActions) {
        this.contributeTeamActions = contributeActions;
    }

    public abstract ILocation getLocation();

    public abstract AbstractAdaptableRemoteResource getParent();

    public abstract ResourceType getType();

    protected final IShareable findExistingShareable(ILocation shareableLocation, ResourceType type) {
        return SharingManager.getInstance().findShareable(shareableLocation, type);
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (target instanceof AbstractAdaptableRemoteResource) {
            AbstractAdaptableRemoteResource remote = (AbstractAdaptableRemoteResource)target;
            if (RESOURCE_TYPE.equals(name)) {
                ResourceType type = remote.getType();
                if (RESOURCE_TYPE_FILE.equals(value)) {
                    return type == ResourceType.FILE;
                }
                if (RESOURCE_TYPE_FOLDER.equals(value)) {
                    return type == ResourceType.FOLDER;
                }
                if (RESOURCE_TYPE_SYMLINK.equals(value)) {
                    return type == ResourceType.SYMBOLIC_LINK;
                }
            } else {
                if (IS_UNSHARED.equals(name)) {
                    return remote.isUnshared() == Boolean.valueOf(value).booleanValue();
                }
                if (IS_CONTRIBUTE_TEAM_ACTIONS.equals(name)) {
                    return this.isContributeActions() == Boolean.valueOf(value).booleanValue();
                }
            }
        }
        return false;
    }

    final boolean isContributeActions() {
        return this.contributeTeamActions;
    }

    public boolean isUnshared() {
        ILocation remoteLocation = this.getLocation();
        for (ISandbox sandbox : FileSystemCore.getSharingManager().getRegisteredSandboxes()) {
            ILocation sandboxRoot = sandbox.getRoot();
            if (!sandboxRoot.isPrefixOf(remoteLocation) || sandboxRoot.equals((Object)remoteLocation)) continue;
            return false;
        }
        return true;
    }

    public final IShareable createShareableToShare() {
        ILocation parentLocation = this.getParent().getLocation();
        Sandbox sandbox = new Sandbox(parentLocation);
        return new Shareable((ISandbox)sandbox, this.getLocation().getLocationRelativeTo(sandbox.getRoot()), this.getType());
    }
}

