/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.actions.components;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.IUnshareOperation;
import com.ibm.team.filesystem.client.operations.UnshareDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.OfflineManager;
import com.ibm.team.filesystem.ui.actions.teamplace.UnloadAction;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnUnShareUser;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class UnloadConfigurationDescriptorAction
extends AbstractActionDelegate {
    public void run(final Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        if (selection.size() == 0) {
            return;
        }
        List selectionList = selection.toList();
        final List<LoadedConfigurationDescriptor> lcds = this.getLoadedConfigurationDescriptors(selectionList);
        String message = lcds.size() == 1 ? Messages.UnLoadComponentsAction_0 : NLS.bind((String)Messages.UnLoadComponentsAction_1, (Object)lcds.size());
        final UnloadAction.UnshareWarningResults promptResults = UnloadAction.promptIfNeeded(shell, Messages.UnLoadComponentsAction_2, message, (IStructuredSelection)new StructuredSelection(lcds), false, true);
        if (promptResults.isCancelled()) {
            return;
        }
        this.getOperationRunner().enqueue(Messages.UnloadConfigurationDescriptorAction_0, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                try {
                    IUnshareOperation op = IOperationFactory.instance.getUnshareOperation((UnshareDilemmaHandler)new WarnUnShareUser(shell, Messages.UnLoadAction_UnShareOperationTitle, promptResults.isDeleteContent()), IRepositoryResolver.EXISTING_SHARED);
                    op.requestUnshare((Collection)lcds);
                    op.setDeleteContent(promptResults.isDeleteContent());
                    op.run(monitor);
                }
                catch (FileSystemException e) {
                    throw new OperationFailedException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
                }
            }
        });
        boolean refreshUnreachable = false;
        for (Object obj : selectionList) {
            IContextHandle wsHandle;
            if (!(obj instanceof OfflineManager.UnreachableWorkspace) || !((wsHandle = ((OfflineManager.UnreachableWorkspace)obj).getHandle()) instanceof IWorkspaceHandle)) continue;
            refreshUnreachable = true;
            FileSystemResourcesPlugin.getActiveWorkspaceManager().deactivate((IWorkspaceHandle)wsHandle);
        }
        if (refreshUnreachable) {
            OfflineManager.getInstance().requestUpdate();
        }
    }

    List<LoadedConfigurationDescriptor> getLoadedConfigurationDescriptors(List elements) {
        ArrayList<LoadedConfigurationDescriptor> result = new ArrayList<LoadedConfigurationDescriptor>();
        for (Object element : elements) {
            if (element instanceof LoadedConfigurationDescriptor) {
                result.add((LoadedConfigurationDescriptor)element);
            }
            if (!(element instanceof OfflineManager.UnreachableWorkspace)) continue;
            result.addAll(OfflineManager.getInstance().getUnreachableDescriptors((OfflineManager.UnreachableWorkspace)element));
        }
        return result;
    }
}

