/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.actions.components;

import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.operations.IUnshareOperation;
import com.ibm.team.filesystem.client.operations.UnshareDilemmaHandler;
import com.ibm.team.filesystem.ui.actions.teamplace.CommonAction;
import com.ibm.team.filesystem.ui.actions.teamplace.UnloadAction;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnUnShareUser;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class UnLoadComponentsAction
extends CommonAction {
    public void run(final Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        if (selection.size() == 0) {
            return;
        }
        String message = selection.size() == 1 ? Messages.UnLoadComponentsAction_0 : NLS.bind((String)Messages.UnLoadComponentsAction_1, (Object)selection.size());
        final UnloadAction.UnshareWarningResults promptResults = UnloadAction.promptIfNeeded(shell, Messages.UnLoadComponentsAction_2, message, selection, false, true);
        if (promptResults.isCancelled()) {
            return;
        }
        this.runOnSelection(selection, new CommonAction.ITeamPlaceRunnable(){

            @Override
            public IStatus run(IWorkspaceConnection connection, Object[] selection, IProgressMonitor monitor) {
                try {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.UnLoadComponentsAction_3, (Object)connection.getName()), (int)1);
                    ArrayList<IComponent> components = new ArrayList<IComponent>();
                    int i = 0;
                    while (i < selection.length) {
                        if (selection[i] instanceof WorkspaceComponentWrapper) {
                            WorkspaceComponentWrapper component = (WorkspaceComponentWrapper)selection[i];
                            components.add(component.getComponent());
                        }
                        ++i;
                    }
                    IUnshareOperation op = IOperationFactory.instance.getUnshareOperation((UnshareDilemmaHandler)new WarnUnShareUser(shell, Messages.UnLoadAction_UnShareOperationTitle, promptResults.isDeleteContent()), IRepositoryResolver.EXISTING_SHARED);
                    op.requestUnshare((IConnection)connection, components);
                    op.setDeleteContent(promptResults.isDeleteContent());
                    op.run((IProgressMonitor)progress.newChild(1));
                    progress.done();
                    return Status.OK_STATUS;
                }
                catch (TeamRepositoryException e) {
                    return StatusUtil.newStatus((Object)this, (Throwable)e);
                }
            }
        });
    }

    @Override
    protected String getOperationName() {
        return Messages.UnLoadComponentsAction_4;
    }
}

