/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.actions.components;

import com.ibm.team.filesystem.ui.item.AdapterUtil;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.OwnerPicker;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IReadScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class SetComponentOwnerAction
extends AbstractActionDelegate {
    public static final String ACTION_ID = "com.ibm.team.filesystem.actions.setowner";

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        List<ComponentWrapper> components = AdapterUtil.adaptList(selection.toList(), ComponentWrapper.class);
        SetComponentOwnerAction.changeOwner(shell, components, false, this.getOperationRunner());
    }

    public static IAuditableHandle changeOwner(Shell shell, List<ComponentWrapper> wrappers, boolean previewOnly, IOperationRunner runner) {
        final ArrayList<IComponent> components = new ArrayList<IComponent>();
        ITeamRepository componentRepo = null;
        for (ComponentWrapper wrapper : wrappers) {
            components.add(wrapper.getComponent());
            if (wrapper.getRepository().equals(componentRepo)) continue;
            if (componentRepo == null) {
                componentRepo = wrapper.getRepository();
                continue;
            }
            componentRepo = null;
            break;
        }
        final ITeamRepository repo = componentRepo;
        if (repo == null) {
            MessageDialog.openInformation((Shell)shell, (String)Messages.SetComponentOwnerAction_2, (String)Messages.SetComponentOwnerAction_3);
            return null;
        }
        String pickerDescription = null;
        pickerDescription = components.size() == 1 ? NLS.bind((String)Messages.SetComponentOwnerAction_OwnerDialogMessageSingle, (Object)((IComponent)components.get(0)).getName()) : Messages.SetComponentOwnerAction_OwnerDialogMessagePlural;
        OwnerPicker ownerPicker = new OwnerPicker(shell, repo, pickerDescription);
        if (ownerPicker.open() == 0) {
            IAuditable newOwner = ownerPicker.getOwner();
            IReadScope readScope = ownerPicker.getReadScope();
            if (newOwner != null && !previewOnly) {
                runner.enqueue(Messages.SetComponentOwnerAction_1, (Operation)new RepositoryOperation((IAuditableHandle)newOwner, readScope){
                    private final /* synthetic */ IAuditableHandle val$newOwner;
                    private final /* synthetic */ IReadScope val$readScope;
                    {
                        this.val$newOwner = iAuditableHandle;
                        this.val$readScope = iReadScope;
                    }

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                        SubMonitor componentProgress = progress.newChild(80);
                        componentProgress.setWorkRemaining(components.size());
                        for (IComponent component : components) {
                            mgr.setComponentOwnerAndVisibility((IComponentHandle)component, this.val$newOwner, this.val$readScope, (IProgressMonitor)componentProgress.newChild(1));
                        }
                        repo.itemManager().refreshSharedItems(Collections.unmodifiableList(components), (IProgressMonitor)progress.newChild(20));
                    }
                });
            }
            return newOwner;
        }
        return null;
    }
}

