/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.actions.components;

import com.ibm.team.filesystem.ui.item.AdapterUtil;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class RenameComponentAction
extends AbstractActionDelegate {
    public static final String ACTION_ID = "com.ibm.team.filesystem.actions.renamecomponent";

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        String dialogTitle = Messages.RenameComponentAction_0;
        String dialogMessage = Messages.RenameComponentAction_DialogMessage;
        List<ComponentWrapper> components = AdapterUtil.adaptList(selection.toList(), ComponentWrapper.class);
        final ComponentWrapper cw = components.get(0);
        final IComponent component = cw.getComponent();
        String originalName = component.getName();
        InputDialog dialog = new InputDialog(shell, dialogTitle, dialogMessage, originalName, new IInputValidator(){

            public String isValid(String newText) {
                if (newText.equals("")) {
                    return "";
                }
                if (!newText.trim().equals(newText)) {
                    return Messages.RenameComponentAction_WhitespaceErrorMessage;
                }
                return null;
            }
        });
        if (dialog.open() != 0 || dialog.getValue() == null) {
            return;
        }
        final String newName = dialog.getValue();
        if (!newName.equals(originalName)) {
            this.getOperationRunner().enqueue(Messages.RenameComponentAction_2, (Operation)new RepositoryOperation(){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)cw.getRepository());
                    mgr.renameComponent((IComponentHandle)component, newName, (IProgressMonitor)progress.newChild(50));
                    cw.getRepository().itemManager().refreshSharedItems(Collections.singletonList(component), (IProgressMonitor)progress.newChild(50));
                }
            });
        }
    }
}

