/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.actions.components;

import com.ibm.team.filesystem.ui.views.SimplePartInput;
import com.ibm.team.filesystem.ui.views.TeamAreaTreeProvider;
import com.ibm.team.filesystem.ui.wrapper.ContributorWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.actions.components.ContributorsInTeamAreaTreeProvider;
import com.ibm.team.internal.filesystem.ui.actions.components.PartyHandlePartInput;
import com.ibm.team.internal.filesystem.ui.actions.components.PartyHandleSorter;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.ui.internal.viewers.ButtonBar;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreePathRunnable;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreeProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTreeViewer;
import com.ibm.team.repository.rcp.ui.parts.AbstractPart;
import com.ibm.team.repository.rcp.ui.parts.IBusyHandler;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.IPartFactory;
import com.ibm.team.repository.rcp.ui.parts.PartFactory;
import com.ibm.team.repository.rcp.ui.parts.Parts;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class PartyHandlePart
extends AbstractPart {
    private SimpleTreeViewer viewer;
    private SimplePartInput<PartyHandlePartInput, List<ItemId<IAuditable>>> input;
    private Button okayButton;

    public PartyHandlePart(IControlSite site, SimplePartInput<PartyHandlePartInput, List<ItemId<IAuditable>>> newInput) {
        super(site, newInput);
        PartyHandlePartInput partInput = newInput.getInput();
        if (partInput.allowsContributors() && partInput.allowsTeamAreas()) {
            site.getNameable().setName(Messages.PartyHandlePart_0);
        } else if (partInput.allowsContributors()) {
            site.getNameable().setName(Messages.PartyHandlePart_1);
        } else {
            site.getNameable().setName(Messages.PartyHandlePart_2);
        }
        WidgetToolkit toolkit = site.getToolkit();
        String message = newInput.getInput().getMessage();
        if (!message.equals("")) {
            toolkit.createLabel(site.getParent(), message, 64);
        }
        int flags = newInput.getInput().isMulti() ? 2 : 0;
        Tree theTree = toolkit.createTree(site.getParent(), flags);
        Object tree = newInput.getInput().allowsContributors() ? new ContributorsInTeamAreaTreeProvider(site.getOperationRunner()) : new TeamAreaTreeProvider(site.getOperationRunner());
        this.viewer = new SimpleTreeViewer(theTree, (ITreeProvider)tree).setProgressService((IBusyHandler)site);
        this.viewer.setSorter((Comparator)((Object)new PartyHandleSorter()));
        this.viewer.setDoubleClickHandler(new ITreePathRunnable(){

            public void run(TreePath selectedObject, Shell targetShell) {
                PartyHandlePart.this.doDoubleClick();
            }
        });
        this.viewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PartyHandlePart.this.updateSelection();
            }
        });
        ButtonBar theButtonBar = new ButtonBar(site.getParent(), MessageDialogFactory.getChoicesForType((int)5), new IPartResult(){

            public void setResult(Object result) {
                if (result == MessageDialogFactory.OKAY.getValue()) {
                    PartyHandlePart.this.okayClicked();
                } else {
                    PartyHandlePart.this.getControlSite().close();
                }
            }
        });
        this.okayButton = theButtonBar.getButton(MessageDialogFactory.OKAY.getValue());
        site.setDefaultButton(this.okayButton);
        site.setSelectionProvider(this.viewer.getSelectionProvider());
        GridLayoutFactory.fillDefaults().generateLayout(this.getControlSite().getParent());
        this.handleInput(newInput);
        this.updateSelection();
    }

    private void updateSelection() {
        List<ItemId<IAuditable>> selectedParties = this.selectedContributorTeamAreaHandles();
        this.okayButton.setEnabled(!selectedParties.isEmpty());
    }

    private List<ItemId<IAuditable>> selectedContributorTeamAreaHandles() {
        ArrayList result = NewCollection.arrayList();
        List selection = this.viewer.getSelection().toList();
        for (Object next : selection) {
            if (next instanceof IProcessArea && this.input.getInput().allowsTeamAreas()) {
                IProcessArea ta = (IProcessArea)next;
                result.add(new ItemId((IItemHandle)ta));
            }
            if (!(next instanceof ContributorWrapper) || !this.input.getInput().allowsContributors()) continue;
            ContributorWrapper cw = (ContributorWrapper)((Object)next);
            result.add(new ItemId((IItemHandle)cw.getItem()));
        }
        return result;
    }

    protected void okayClicked() {
        if (!this.okayButton.isEnabled()) {
            return;
        }
        List<ItemId<IAuditable>> selectedParties = this.selectedContributorTeamAreaHandles();
        this.input.setResult(selectedParties);
        this.getControlSite().close();
    }

    protected void doDoubleClick() {
        this.okayClicked();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.viewer.getSelectionProvider();
    }

    private void handleInput(SimplePartInput<PartyHandlePartInput, List<ItemId<IAuditable>>> newInput) {
        this.input = newInput;
        this.viewer.setInput((Object)this.input.getInput().getRepo());
    }

    public static void pickPartyHandle(Shell parentShell, PartyHandlePartInput input, IPartResult<List<ItemId<IAuditable>>> result) {
        Parts.openModalDialog((Shell)parentShell, SimplePartInput.forInput(input, result), (IPartFactory)new PartFactory(PartyHandlePart.class));
    }
}

