/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.actions.components;

import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.operations.CreateSnapshotDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICreateSnapshotOperation;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.NewSnapshotDialog;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.views.SnapshotEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlacePart2;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnCreateSnapshotDilemmaHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class NewSnapshotAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        if (selection.size() != 1) {
            return;
        }
        Object obj = selection.getFirstElement();
        ITeamRepository repo = null;
        IWorkspace workspace = null;
        if (obj != null && Adapters.hasAdapter((Object)obj, AbstractPlaceWrapper.class)) {
            final AbstractPlaceWrapper wrapper = (AbstractPlaceWrapper)((Object)Adapters.getAdapter((Object)obj, AbstractPlaceWrapper.class));
            repo = wrapper.getRepository();
            workspace = wrapper.getWorkspace();
            final boolean[] containsComponents = new boolean[]{true};
            ProgressMonitorDialog componentLookup = new ProgressMonitorDialog(shell);
            try {
                componentLookup.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            containsComponents[0] = wrapper.getWorkspaceConnection(monitor, true).getComponents().size() > 0;
                        }
                        catch (TeamRepositoryException e) {
                            StatusUtil.log((Object)((Object)UiPlugin.getDefault()), (Throwable)e);
                        }
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!containsComponents[0]) {
                this.showNoComponentsDialog(shell);
                return;
            }
        } else if (obj instanceof IWorkspaceSyncContext) {
            IWorkspaceSyncContext context = (IWorkspaceSyncContext)obj;
            repo = context.teamRepository();
            workspace = context.getLocal().getResolvedWorkspace();
            try {
                if (context.getLocal().getComponents().size() == 0) {
                    this.showNoComponentsDialog(shell);
                    return;
                }
            }
            catch (TeamRepositoryException e) {
                StatusUtil.log((Object)((Object)UiPlugin.getDefault()), (Throwable)e);
            }
        }
        if (repo != null && workspace != null) {
            this.promptAndCreate(shell, page, repo, workspace);
        }
    }

    private void showNoComponentsDialog(Shell shell) {
        MessageDialog.openError((Shell)shell, (String)Messages.NewSnapshotAction_NoComponentsDialog_Title, (String)Messages.NewSnapshotAction_NoComponentsDialog_Message);
    }

    private void promptAndCreate(Shell shell, IWorkbenchPage page, ITeamRepository repo, IWorkspace workspace) {
        NewSnapshotDialog dialog = new NewSnapshotDialog(shell, NLS.bind((String)Messages.NewSnapshotAction_0, (Object)workspace.getName()), repo, workspace);
        if (dialog.open() == 0) {
            String name = dialog.getName();
            String comment = dialog.getComment();
            int flags = dialog.getBaselineSetFlags();
            this.createSnapshot(shell, page, repo, workspace, name, comment, flags, dialog.getExcludedComponents());
        }
    }

    private void createSnapshot(Shell shell, final IWorkbenchPage page, final ITeamRepository repo, final IWorkspace workspace, final String name, final String comment, final int baselineSetFlags, final Collection<? extends IComponentHandle> excludedComponents) {
        final Display display = shell.isDisposed() ? Display.getDefault() : shell.getDisplay();
        this.getOperationRunner().enqueue(Messages.NewSnapshotAction_1, (Operation)new RepositoryOperation(repo){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                IWorkspaceConnection wc = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)workspace, (IProgressMonitor)progress.newChild(15));
                WarnCreateSnapshotDilemmaHandler dilemmaHandler = new WarnCreateSnapshotDilemmaHandler(wc.isStream());
                ICreateSnapshotOperation op = IOperationFactory.instance.getCreateSnapshotOperation((CreateSnapshotDilemmaHandler)dilemmaHandler);
                op.createSnapshotRequest(wc, excludedComponents, baselineSetFlags, name, comment);
                op.run((IProgressMonitor)progress.newChild(70));
                IBaselineSetHandle snapshotHandle = op.getSnapshotCreated();
                if (snapshotHandle != null) {
                    NewSnapshotAction.this.openSnapshotInEditor(repo, snapshotHandle, display, page, (IProgressMonitor)progress.newChild(15));
                }
            }
        });
    }

    private void openSnapshotInEditor(ITeamRepository repo, IBaselineSetHandle snapshotHandle, Display display, final IWorkbenchPage page, IProgressMonitor monitor) throws TeamRepositoryException {
        IFetchResult fetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(Arrays.asList(snapshotHandle), 0, monitor);
        if (fetchResult.getRetrievedItems().size() == 1) {
            Object result = fetchResult.getRetrievedItems().get(0);
            final IBaselineSet snapshot = (IBaselineSet)result;
            if (result instanceof IBaselineSet && !display.isDisposed()) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TeamPlacePart2.open(page, SnapshotEditorInput.newForEdit(snapshot));
                    }
                });
            }
        }
    }

    private boolean shouldEnable(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        Object obj = selection.getFirstElement();
        if (obj == null) {
            return false;
        }
        IWorkspaceSyncContext workspaceSyncContext = ComponentSyncUtil.getWorkspaceContext((Object)obj);
        if (workspaceSyncContext == null) {
            return true;
        }
        IWorkspaceConnection workspaceConnection = workspaceSyncContext.getLocal();
        IActiveWorkspaceManager manager = FileSystemResourcesPlugin.getActiveWorkspaceManager();
        return manager.isWorkspaceTracked((IWorkspaceHandle)workspaceConnection.getResolvedWorkspace());
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(this.shouldEnable((IStructuredSelection)selection));
    }
}

