/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.actions.components;

import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.operations.CreateBaselineDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICreateBaselineOperation;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.NewBaselineDialog;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingActivitySource;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnCreateBaselineDilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class NewBaselineAction
extends AbstractActionDelegate {
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(selection != null && selection instanceof IStructuredSelection && !this.extractConfigurations((IStructuredSelection)selection).isEmpty());
    }

    private Map<IWorkspaceConnection, Map<UUID, IComponent>> extractConfigurations(IStructuredSelection selection) {
        HashMap<IWorkspaceConnection, Map<UUID, IComponent>> configurations = new HashMap<IWorkspaceConnection, Map<UUID, IComponent>>();
        for (Object o : selection.toList()) {
            IOutgoingActivitySource activitySource;
            IComponentSyncContext componentsyncContext;
            if (o instanceof WorkspaceComponentWrapper) {
                WorkspaceComponentWrapper wrapper = (WorkspaceComponentWrapper)o;
                this.addToMap(configurations, wrapper.getWorkspaceConnection(), wrapper.getComponent());
                continue;
            }
            if (o instanceof IComponentSyncContext) {
                IComponentSyncContext componentsyncContext2 = (IComponentSyncContext)o;
                if (componentsyncContext2.getComponent() == null || !componentsyncContext2.isLocal()) continue;
                this.addToMap(configurations, componentsyncContext2.getComponentSyncInfo().getLocalWorkspaceConnection(), componentsyncContext2.getComponent());
                continue;
            }
            if (!(o instanceof IOutgoingActivitySource) || (componentsyncContext = (activitySource = (IOutgoingActivitySource)o).getModel()).getComponent() == null || !componentsyncContext.isLocal()) continue;
            this.addToMap(configurations, componentsyncContext.getComponentSyncInfo().getLocalWorkspaceConnection(), componentsyncContext.getComponent());
        }
        return configurations;
    }

    private void addToMap(Map<IWorkspaceConnection, Map<UUID, IComponent>> configurations, IWorkspaceConnection wc, IComponent component) {
        Map<UUID, IComponent> components = configurations.get(wc);
        if (components == null) {
            components = new HashMap<UUID, IComponent>();
        }
        components.put(component.getItemId(), component);
        configurations.put(wc, components);
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        NewBaselineDialog dialog;
        Map<IWorkspaceConnection, Map<UUID, IComponent>> configurations = this.extractConfigurations(selection);
        if (configurations.isEmpty()) {
            return;
        }
        if (configurations.size() == 1 && configurations.entrySet().iterator().next().getValue().size() == 1) {
            IWorkspaceConnection wc = configurations.entrySet().iterator().next().getKey();
            Map<UUID, IComponent> componentMap = configurations.entrySet().iterator().next().getValue();
            IComponent component = componentMap.entrySet().iterator().next().getValue();
            dialog = new NewBaselineDialog(shell, NLS.bind((String)Messages.NewBaselineAction_BaselineDialogTitle, (Object)component.getName()), component, wc);
        } else {
            dialog = new NewBaselineDialog(shell, Messages.NewBaselineAction_6, null, null);
        }
        if (dialog.open() == 0) {
            NewBaselineAction.createBaselines(configurations, dialog.getName(), dialog.getComment(), this.getOperationRunner());
        }
    }

    public static void createBaselines(final Map<IWorkspaceConnection, Map<UUID, IComponent>> configurations, final String name, final String comment, IOperationRunner opRunner) {
        String jobtitle = configurations.size() == 1 && configurations.entrySet().iterator().next().getValue().size() == 1 ? Messages.NewBaselineAction_CreateBaselineJobName : Messages.NewBaselineAction_CreateBaselinesJobName;
        opRunner.enqueue(jobtitle, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                WarnCreateBaselineDilemmaHandler dilemmaHandler = new WarnCreateBaselineDilemmaHandler(configurations);
                ICreateBaselineOperation op = IOperationFactory.instance.getCreateBaselineOperation((CreateBaselineDilemmaHandler)dilemmaHandler);
                for (Map.Entry entry : configurations.entrySet()) {
                    IWorkspaceConnection wc = (IWorkspaceConnection)entry.getKey();
                    for (IComponent component : ((Map)entry.getValue()).values()) {
                        op.createBaselineRequest(wc, (IComponentHandle)component, name, comment);
                    }
                }
                op.run(monitor);
            }
        });
    }
}

