/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.actions.components;

import com.ibm.team.filesystem.ide.ui.internal.actions.load.LoadAction;
import com.ibm.team.filesystem.ui.actions.teamplace.CommonAction;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class LoadComponentsAction
extends CommonAction {
    public void run(final Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        this.runOnSelection(selection, new CommonAction.ITeamPlaceRunnable(){

            @Override
            public IStatus run(IWorkspaceConnection connection, Object[] selection, IProgressMonitor progress) {
                IWorkspaceConnection workspaceConnection = null;
                HashSet<WorkspaceComponentWrapper> wrappers = new HashSet<WorkspaceComponentWrapper>();
                ArrayList<IComponent> components = new ArrayList<IComponent>(wrappers.size());
                int i = 0;
                while (i < selection.length) {
                    Object o = selection[i];
                    if (o instanceof WorkspaceComponentWrapper) {
                        WorkspaceComponentWrapper wrapper = (WorkspaceComponentWrapper)o;
                        workspaceConnection = wrapper.getWorkspaceConnection();
                        Assert.isTrue((boolean)workspaceConnection.getResolvedWorkspace().sameItemId((IItemHandle)connection.getResolvedWorkspace()));
                        if (!wrappers.contains(wrapper)) {
                            wrappers.add(wrapper);
                            components.add(wrapper.getComponent());
                        }
                    }
                    ++i;
                }
                try {
                    LoadAction.checkout(shell.getDisplay(), shell, connection, components, LoadComponentsAction.this.getOperationRunner(), progress);
                }
                catch (TeamRepositoryException e) {
                    return StatusUtil.newStatus((Object)this, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        });
    }

    @Override
    protected String getOperationName() {
        return Messages.LoadComponentsAction_2;
    }

    @Override
    protected boolean isEnabled() {
        Map<String, Map<CommonAction.WorkspaceDescriptor, List<Object>>> workspaces = this.getWorkspacesFromSelection(this.getStructuredSelection());
        if (workspaces.size() == 1) {
            for (Map<CommonAction.WorkspaceDescriptor, List<Object>> map : workspaces.values()) {
                if (map.size() != 1) continue;
                return true;
            }
        }
        return false;
    }
}

