/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.actions.components;

import com.ibm.team.filesystem.ui.item.AdapterUtil;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.VisibilityPicker;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.dto.IReadScope;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class ChangeVisibilityComponentAction
extends AbstractActionDelegate {
    public static final String ACTION_ID = "com.ibm.team.filesystem.actions.changevisibilitycomponent";

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        String dialogDescription;
        VisibilityPicker.PickerMode mode;
        final List<ComponentWrapper> components = AdapterUtil.adaptList(selection.toList(), ComponentWrapper.class);
        final IReadScope[] readScope = new IReadScope[1];
        ProgressMonitorDialog d = new ProgressMonitorDialog(shell);
        final IAuditableHandle contributorSentinel = (IAuditableHandle)IContributor.ITEM_TYPE.createItemHandle(UUID.generate(), null);
        final IAuditableHandle[] owner = new IAuditableHandle[2];
        final ITeamRepository[] repo = new ITeamRepository[1];
        try {
            d.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    try {
                        try {
                            ArrayList<IComponent> componentHandles = new ArrayList<IComponent>();
                            for (ComponentWrapper cw : components) {
                                if (!cw.getRepository().equals(repo[0])) {
                                    if (repo[0] == null) {
                                        repo[0] = cw.getRepository();
                                    } else {
                                        repo[0] = null;
                                        break;
                                    }
                                }
                                IComponent component = cw.getComponent();
                                componentHandles.add(component);
                            }
                            if (repo[0] != null) {
                                IAuditableHandle ownerHandle2;
                                IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)repo[0]);
                                readScope[0] = (IReadScope)mgr.findReadScopeForComponents(componentHandles, (IProgressMonitor)progress.newChild(40)).get(0);
                                List owners = mgr.findOwnersForComponents(Collections.unmodifiableList(componentHandles), (IProgressMonitor)progress.newChild(20));
                                for (IAuditableHandle ownerHandle2 : owners) {
                                    if (owner[0] == null) {
                                        owner[0] = ownerHandle2 instanceof IContributorHandle ? contributorSentinel : ownerHandle2;
                                        continue;
                                    }
                                    if ((!(ownerHandle2 instanceof IContributorHandle) || owner[0].sameItemId((IItemHandle)contributorSentinel)) && (!(ownerHandle2 instanceof IProcessAreaHandle) || owner[0].sameItemId((IItemHandle)ownerHandle2))) continue;
                                    owner[0] = null;
                                    break;
                                }
                                ownerHandle2 = owner[0];
                                if (ownerHandle2 != null && ownerHandle2 instanceof IProcessAreaHandle) {
                                    IProcessArea ownerArea = (IProcessArea)repo[0].itemManager().fetchCompleteItem((IItemHandle)ownerHandle2, 0, (IProgressMonitor)progress.newChild(20));
                                    owner[0] = ownerArea;
                                    if (ownerArea instanceof ITeamArea) {
                                        IProjectAreaHandle projectAreaHandle = ((ITeamArea)ownerArea).getProjectArea();
                                        owner[1] = (IProjectArea)repo[0].itemManager().fetchCompleteItem((IItemHandle)projectAreaHandle, 0, (IProgressMonitor)progress.newChild(20));
                                    }
                                }
                            }
                        }
                        catch (TeamRepositoryException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        progress.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            ErrorDialog.openError((Shell)shell, (String)Messages.ChangeVisibilityComponentAction_0, (String)Messages.ChangeVisibilityComponentAction_1, (IStatus)StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (owner[0] == null) {
            MessageDialog.openInformation((Shell)shell, (String)Messages.ChangeVisibilityComponentAction_4, (String)Messages.ChangeVisibilityComponentAction_5);
            return;
        }
        if (repo[0] == null) {
            MessageDialog.openInformation((Shell)shell, (String)Messages.ChangeVisibilityComponentAction_4, (String)Messages.ChangeVisibilityComponentAction_6);
            return;
        }
        if (components.size() > 1) {
            mode = VisibilityPicker.PickerMode.COMPONENTS;
            dialogDescription = Messages.ChangeVisibilityComponentAction_multipleComponentsDialogTitle;
        } else {
            mode = VisibilityPicker.PickerMode.COMPONENT;
            dialogDescription = Messages.ChangeVisibilityComponentAction_2;
        }
        VisibilityPicker picker = new VisibilityPicker((IShellProvider)new SameShellProvider((Control)shell), repo[0], readScope[0], mode, dialogDescription);
        if (!owner[0].sameItemId((IItemHandle)contributorSentinel) && owner[0] instanceof IProcessArea) {
            IProjectArea projectArea = null;
            ITeamArea teamArea = null;
            int i = 0;
            while (i < owner.length && owner[i] != null) {
                if (owner[i] instanceof ITeamArea) {
                    teamArea = (ITeamArea)owner[i];
                } else if (owner[i] instanceof IProjectArea) {
                    projectArea = (IProjectArea)owner[i];
                }
                ++i;
            }
            picker.setOwner((IAuditable)owner[0]);
            picker.setProcessAreas(projectArea, teamArea);
        }
        if (picker.open() == 0) {
            final IReadScope scope = picker.getReadScope();
            this.getOperationRunner().enqueue(Messages.ChangeVisibilityComponentAction_3, (Operation)new RepositoryOperation(){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    for (ComponentWrapper cw : components) {
                        IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)repo[0]);
                        IComponent component = cw.getComponent();
                        mgr.setComponentOwnerAndVisibility((IComponentHandle)component, IScmService.NOOP_OWNER, scope, (IProgressMonitor)progress.newChild(50));
                        repo[0].itemManager().refreshSharedItems(Collections.singletonList(component), (IProgressMonitor)progress.newChild(50));
                    }
                }
            });
        }
    }
}

