/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.actions;

import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.process.rcp.ui.teamnavigator.IMenuOperationTarget;
import com.ibm.team.repository.rcp.ui.internal.menus.AbstractActionExt;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IWorkbenchSite;

public class TanAction
extends AbstractActionExt
implements Runnable {
    private String defaultText;
    private String type;
    private ISelectionProvider provider;
    protected Runnable updateRunnable = new Runnable(){

        @Override
        public void run() {
            TanAction.this.update();
        }
    };
    private ISelectionChangedListener listener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            TanAction.this.update();
        }
    };
    private IWorkbenchSite site;

    public TanAction(ImageDescriptor descriptor, String defaultText, String type, IWorkbenchSite site, ISelectionProvider selection) {
        super(descriptor, defaultText);
        this.provider = selection;
        this.defaultText = defaultText;
        this.type = type;
        this.site = site;
        this.setId(type);
    }

    protected void update() {
        IStructuredSelection ss;
        IMenuOperationTarget op;
        boolean found = false;
        ISelection sel = this.provider.getSelection();
        if (sel instanceof IStructuredSelection && (op = this.getTarget(ss = (IStructuredSelection)sel)) != null && op.canDoOperation(this.type, ss)) {
            String newText = op.getLabel(this.type);
            this.setText(newText != null ? newText : this.defaultText);
            found = true;
        }
        this.setVisible(found);
    }

    private IMenuOperationTarget getTarget(IStructuredSelection ss) {
        List selectionList = ss.toList();
        for (Object next : selectionList) {
            IMenuOperationTarget nextTarget = (IMenuOperationTarget)Adapters.getAdapter(next, IMenuOperationTarget.class);
            if (nextTarget == null || !nextTarget.canDoOperation(this.type, ss)) continue;
            return nextTarget;
        }
        return null;
    }

    public int getStyle() {
        return 8;
    }

    protected void allocate() {
        this.update();
        this.provider.addSelectionChangedListener(this.listener);
        super.allocate();
    }

    protected void deallocate() {
        this.provider.removeSelectionChangedListener(this.listener);
        super.deallocate();
    }

    @Override
    public void run() {
        IStructuredSelection ss;
        IMenuOperationTarget mot;
        ISelection sel = this.provider.getSelection();
        if (sel instanceof IStructuredSelection && (mot = this.getTarget(ss = (IStructuredSelection)sel)) != null && mot.canDoOperation(this.type, ss)) {
            mot.doOperation(this.type, this.site, ss);
        }
    }
}

