/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.actions;

import com.ibm.team.filesystem.ui.queries.FolderNode;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.operations.RenameFolderOperation;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class RenameFolderAction
extends AbstractActionDelegate
implements IInputValidator {
    private String getOperationName() {
        return Messages.RenameFolderAction_OperationName;
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        if (selection.size() != 1) {
            return;
        }
        Object obj = selection.getFirstElement();
        if (!(obj instanceof FolderNode)) {
            return;
        }
        final FolderNode node = (FolderNode)obj;
        String defaultName = node.getName() == null || node.getName().isEmpty() ? Messages.RenameFolderAction_DialogDefaultValue : node.getName();
        final InputDialog dialog = new InputDialog(shell, Messages.RenameFolderAction_DialogTitle, Messages.RenameFolderAction_DialogPrompt, defaultName, (IInputValidator)this);
        if (dialog.open() != 0) {
            return;
        }
        this.getOperationRunner().enqueue(this.getOperationName(), (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                RenameFolderOperation operation = new RenameFolderOperation();
                String name = dialog.getValue();
                operation.rename(node.getItem(), name);
                operation.run(monitor, problems);
            }
        });
    }

    public String isValid(String newText) {
        if (newText.equals("")) {
            return "";
        }
        if (!newText.trim().equals(newText)) {
            return Messages.CreateFolderAction_DialogErrorBeginsWithSpace;
        }
        return null;
    }
}

