/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.ui.changes.dialogs.ActivityDeleteDialog;
import com.ibm.team.filesystem.ui.domain.SelectionValidator;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class RemoveSuspendedChangeSetAction
extends AbstractActionDelegate {
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        boolean shouldEnable = new SelectionValidator(selection).isValid(true) && SelectionValidator.isSelectionOnlyInAllSuspendedNode(selection);
        action.setEnabled(shouldEnable);
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        ArrayList<IChangeSet> changeSets = new ArrayList<IChangeSet>(selection.size());
        ITeamRepository repo = null;
        for (Object obj : selection.toList()) {
            if (!(obj instanceof ContributorPlaceChangeSetWrapper)) continue;
            ContributorPlaceChangeSetWrapper wrapper = (ContributorPlaceChangeSetWrapper)((Object)obj);
            repo = wrapper.getRepository();
            changeSets.add(wrapper.getChangeSet());
        }
        if (repo != null) {
            ActivityDeleteDialog dialog = new ActivityDeleteDialog(shell, changeSets, 2);
            if (dialog.open() != 0) {
                return;
            }
            IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            RemoveSuspendedChangeSetAction.removeChangeSets(shell, this.getOperationRunner(), manager, changeSets);
        }
    }

    public static void removeChangeSets(Shell shell, IOperationRunner runner, final IWorkspaceManager manager, final List<IChangeSet> changeSets) {
        String name = Messages.RemoveSuspendedActivityAction_0;
        runner.enqueue(name, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                manager.removeSuspended((Collection)changeSets, monitor);
            }
        });
    }
}

