/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.actions;

import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.domain.SelectionValidator;
import com.ibm.team.filesystem.ui.queries.FolderNode;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.actions.AbstractFolderAction;
import com.ibm.team.internal.filesystem.ui.operations.AbstractFolderOperation;
import com.ibm.team.internal.filesystem.ui.operations.RemoveFromFolderOperation;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class RemoveFromFolderAction
extends AbstractFolderAction {
    public static final String ACTION_ID = "com.ibm.team.filesystem.actions.removeFromFolder";

    @Override
    protected boolean confirm(Shell shell, IStructuredSelection selection) {
        String message;
        String title;
        if (selection.getFirstElement() instanceof FolderNode) {
            title = Messages.RemoveFromFolderAction_ConfirmFolderTitle;
            message = Messages.RemoveFromFolderAction_ConfirmFolderMessage;
        } else {
            title = Messages.RemoveFromFolderAction_ConfirmItemTitle;
            message = Messages.RemoveFromFolderAction_ConfirmItemMessage;
        }
        return DialogUtil.openQuestionDialog(shell, title, message, true);
    }

    @Override
    protected String getOperationName() {
        return Messages.RemoveFromFolderAction_OperationName;
    }

    @Override
    protected AbstractFolderOperation getConfiguredOperation(SelectionValidator validator) {
        RemoveFromFolderOperation operation = new RemoveFromFolderOperation(this.getContext());
        operation.setOwner(validator.getOwner());
        for (SelectionValidator.ItemWrapper item : validator.getItems()) {
            operation.remove(item.getParentFolder(), item.getItem());
        }
        return operation;
    }

    @Override
    protected boolean pickTarget(Shell shell, SelectionValidator validator) {
        return true;
    }
}

