/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.actions;

import com.ibm.team.containers.common.IItemContainer;
import com.ibm.team.containers.common.IItemContainerHandle;
import com.ibm.team.filesystem.ui.domain.SelectionValidator;
import com.ibm.team.filesystem.ui.queries.FolderNode;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.actions.AbstractFolderAction;
import com.ibm.team.internal.filesystem.ui.operations.AbstractFolderOperation;
import com.ibm.team.internal.filesystem.ui.operations.MoveToFolderOperation;
import com.ibm.team.internal.filesystem.ui.picker.ItemContainerPicker;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Shell;

public class MoveToFolderAction
extends AbstractFolderAction {
    public static final String ACTION_ID = "com.ibm.team.filesystem.actions.moveToFolder";

    @Override
    protected String getOperationName() {
        return Messages.MoveToFolderAction_OperationName;
    }

    @Override
    protected AbstractFolderOperation getConfiguredOperation(SelectionValidator validator) {
        MoveToFolderOperation operation = new MoveToFolderOperation();
        IItemContainer targetItem = this.target.getItem();
        operation.setTarget((IItemContainerHandle)targetItem);
        for (SelectionValidator.ItemWrapper wrapper : validator.getItems()) {
            boolean moveToSameParent;
            boolean moveToSameItem = wrapper.getItem().sameItemId((IItemHandle)targetItem);
            boolean bl = targetItem == null ? wrapper.getParentFolder() == null : (moveToSameParent = targetItem.sameItemId((IItemHandle)wrapper.getParentFolder()));
            if (moveToSameItem || moveToSameParent) continue;
            operation.move(wrapper.getOwner(), wrapper.getParentFolder(), wrapper.getItem());
        }
        return operation;
    }

    @Override
    protected boolean pickTarget(Shell shell, SelectionValidator validator) {
        List<FolderNode> selectedFolders = validator.getOwner() instanceof IContributorHandle ? ItemContainerPicker.pickFolder(shell, validator.getRepository(), null, (IContributorHandle)validator.getOwner(), false) : (validator.hasSnapshot() ? ItemContainerPicker.pickFolder(shell, validator.getRepository(), (IContributorHandle)validator.getRepository().loggedInContributor(), false) : ItemContainerPicker.pickFolder(shell, validator.getRepository(), Collections.singletonList(validator.getOwner()), null, false));
        if (selectedFolders.size() == 1) {
            SelectionValidator.ItemWrapper itemToMove;
            if (validator.getItems().size() == 1 && validator.getItems().get(0) != null && (itemToMove = validator.getItems().get(0)).getItem().sameItemId((IItemHandle)selectedFolders.get(0).getItem())) {
                return false;
            }
            this.target = selectedFolders.get(0);
            return true;
        }
        return false;
    }
}

