/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.actions;

import com.ibm.team.containers.common.IItemContainerHandle;
import com.ibm.team.filesystem.client.internal.ClientRepositoryUtil;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.ui.queries.FolderNode;
import com.ibm.team.filesystem.ui.queries.RepositoryNode;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.operations.CreateFolderOperation;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class CreateFolderAction
extends AbstractActionDelegate
implements IInputValidator {
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (selection instanceof IStructuredSelection) {
            ProcessedSelection processedSelection = new ProcessedSelection((IStructuredSelection)selection);
            action.setEnabled(processedSelection.isValid());
        }
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        final ProcessedSelection processedSelection = new ProcessedSelection(selection);
        if (!processedSelection.isValid()) {
            MessageDialog.openError((Shell)shell, (String)Messages.CreateFolderAction_ErrorTitle, (String)Messages.CreateFolderAction_ErrorMessage);
            return;
        }
        final InputDialog dialog = new InputDialog(shell, Messages.CreateFolderAction_DialogTitle, Messages.CreateFolderAction_DialogPrompt, Messages.CreateFolderAction_DialogDefaultValue, (IInputValidator)this);
        if (dialog.open() != 0) {
            return;
        }
        this.getOperationRunner().enqueue(this.getOperationName(), (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                CreateFolderOperation operation = new CreateFolderOperation();
                String name = dialog.getValue();
                operation.add(processedSelection.getRepo(), processedSelection.getParent(), processedSelection.getOwner(), name);
                operation.run(monitor, problems);
            }
        });
    }

    private String getOperationName() {
        return Messages.CreateFolderAction_OperationName;
    }

    public String isValid(String newText) {
        if (newText.equals("")) {
            return "";
        }
        if (!newText.trim().equals(newText)) {
            return Messages.CreateFolderAction_DialogErrorBeginsWithSpace;
        }
        return null;
    }

    private class ProcessedSelection {
        private ITeamRepository repo = null;
        private IItemHandle owner = null;
        private IItemContainerHandle parent = null;
        private boolean valid = false;

        private ProcessedSelection(IStructuredSelection selection) {
            this.init(selection);
        }

        private void init(IStructuredSelection selection) {
            Object element = selection.getFirstElement();
            if (element == null) {
                return;
            }
            if (element instanceof DomainSubtreeRoot) {
                DomainSubtreeRoot node = (DomainSubtreeRoot)element;
                this.processDomainSubtreeRoot(node);
            } else if (element instanceof RepositoryNode) {
                RepositoryNode node = (RepositoryNode)element;
                this.processRepositoryNode(node);
            } else if (element instanceof FolderNode) {
                FolderNode node = (FolderNode)element;
                this.processFolderNode(node);
            }
        }

        private void processFolderNode(FolderNode node) {
            this.repo = node.getRepo();
            this.owner = node.getOwner();
            this.parent = node.getItem();
            this.valid = true;
        }

        private void processRepositoryNode(RepositoryNode node) {
            this.repo = node.getRepository();
            try {
                this.owner = RepositoryUtils.getLoggedInContributor((ITeamRepository)this.repo);
            }
            catch (NotLoggedInException e) {
                return;
            }
            this.valid = true;
        }

        private void processDomainSubtreeRoot(DomainSubtreeRoot node) {
            if (node.getCategoryElement() instanceof IProjectAreaHandle) {
                IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)node.getCategoryElement();
                this.repo = ClientRepositoryUtil.getRepository((IItemHandle)projectAreaHandle);
                this.owner = projectAreaHandle;
                this.valid = true;
            } else {
                ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
                if (repos.length == 1) {
                    this.repo = repos[0];
                    try {
                        this.owner = RepositoryUtils.getLoggedInContributor((ITeamRepository)this.repo);
                    }
                    catch (NotLoggedInException e) {
                        return;
                    }
                    this.valid = true;
                }
            }
        }

        private boolean isValid() {
            return this.valid;
        }

        private ITeamRepository getRepo() {
            return this.repo;
        }

        private IItemHandle getOwner() {
            return this.owner;
        }

        private IItemContainerHandle getParent() {
            return this.parent;
        }
    }
}

