/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.actions;

import com.ibm.team.filesystem.ui.domain.SelectionValidator;
import com.ibm.team.filesystem.ui.queries.FolderNode;
import com.ibm.team.internal.filesystem.ui.ItemContainerManager;
import com.ibm.team.internal.filesystem.ui.operations.AbstractFolderOperation;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public abstract class AbstractFolderAction
extends AbstractActionDelegate {
    protected FolderNode target;

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        SelectionValidator validator = new SelectionValidator(selection);
        action.setEnabled(this.canEnable(selection) && validator.isValid(true));
    }

    protected boolean canEnable(ISelection selection) {
        return !SelectionValidator.isSelectionInAllNode(selection) && !SelectionValidator.isSelectionInExpandedQueryNode(selection);
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        SelectionValidator validator = new SelectionValidator((ISelection)selection);
        if (validator.isValid(true)) {
            boolean shouldContinue;
            boolean bl = shouldContinue = this.pickTarget(shell, validator) && this.confirm(shell, selection);
            if (shouldContinue) {
                final AbstractFolderOperation operation = this.getConfiguredOperation(validator);
                this.getOperationRunner().enqueue(this.getOperationName(), (Operation)new RepositoryOperation(){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                        operation.run(monitor, problems);
                    }
                });
                ItemContainerManager.getInstance().fireChangeEvents();
            }
        }
    }

    protected boolean confirm(Shell shell, IStructuredSelection selection) {
        return true;
    }

    protected abstract boolean pickTarget(Shell var1, SelectionValidator var2);

    protected abstract String getOperationName();

    protected abstract AbstractFolderOperation getConfiguredOperation(SelectionValidator var1);
}

