/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui;

import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.ui.views.ComponentEntry;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.viewers.IFilter;

public class WildcardFilter
implements IFilter {
    private static final String LOG_NAMESPACE = "com.ibm.team.filesystem.ide.ui";
    private static final String specialCharacters = "\\.[]{}()<>+-=!^$|";
    private Pattern pattern = null;

    public WildcardFilter(String wildcardText) {
        String filterText = wildcardText;
        try {
            filterText = this.escape(filterText);
            filterText = filterText.replaceAll("\\*", ".*");
            filterText = filterText.replaceAll("\\?", ".");
            filterText = String.valueOf(filterText) + ".*";
            this.pattern = Pattern.compile(filterText, 2);
        }
        catch (PatternSyntaxException e) {
            this.pattern = Pattern.compile(".*", 2);
            LoggingHelper.error((String)LOG_NAMESPACE, (String)"Problem parsing wildcard string.", (Throwable)e);
        }
    }

    public Pattern getPatter() {
        return this.pattern;
    }

    private String escape(String text) {
        String result = "";
        int i = 0;
        while (i < text.length()) {
            CharSequence character = text.subSequence(i, i + 1);
            if (specialCharacters.contains(character)) {
                result = String.valueOf(result) + "\\";
            }
            result = String.valueOf(result) + character;
            ++i;
        }
        return result;
    }

    public boolean select(Object toTest) {
        if (toTest instanceof ComponentEntry) {
            ComponentEntry componentEntry = (ComponentEntry)toTest;
            return this.pattern.matcher(componentEntry.getName()).matches();
        }
        if (toTest instanceof WorkspaceComponentWrapper) {
            WorkspaceComponentWrapper wrapper = (WorkspaceComponentWrapper)toTest;
            return this.pattern.matcher(wrapper.getComponent().getName()).matches();
        }
        return false;
    }
}

