/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.filesystem.client.internal.utils.IgnoreUtils;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.jface.JazzResources;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class UnignoreComplexRuleDialog
extends TrayDialog {
    private Object lock = new Object();
    private boolean doneCollect = false;
    private List<IIgnoreManager.IIgnoreReason> reasons;
    private HashSet<IIgnoreProvider.IIgnoreRule> rulesToRemove;
    private final HashSet<IShareable> toUnignore;
    private Table matchBox;
    private static final String PREF_KEY = "UnignoreComplexRuleDialog";
    private Job collectJob;
    private final Display display;
    private IDialogSettings settings;
    private LocalResourceManager resourceManager;
    private CLabel statusMessageLabel;
    private int unselectedMatchedItemCount = 0;
    private int collectedResourceCount = 0;
    private Image ICON_ERROR;

    public UnignoreComplexRuleDialog(Shell shell, List<IIgnoreManager.IIgnoreReason> reasons, List<IShareable> toUnignore) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.reasons = reasons;
        this.rulesToRemove = IgnoreUtils.extractRulesFromReasons(reasons);
        this.display = shell.getDisplay();
        this.toUnignore = new HashSet();
        this.toUnignore.addAll(toUnignore);
        IDialogSettings workbenchSettings = UiPlugin.getDefault().getDialogSettings();
        this.settings = workbenchSettings.getSection(PREF_KEY);
        if (this.settings == null) {
            this.settings = workbenchSettings.addNewSection(PREF_KEY);
        }
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)shell);
        this.ICON_ERROR = JazzResources.getImageWithDefault((ResourceManager)this.resourceManager, (ImageDescriptor)com.ibm.team.jface.internal.ImagePool.ERROR_ICON);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.UnignoreComplexRuleDialog_1);
    }

    protected Control createDialogArea(Composite parent) {
        GridLayoutFactory layoutFactory = GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins());
        Composite top = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)top);
        Label warningLabel = new Label(top, 64);
        warningLabel.setText(Messages.UnignoreComplexRuleDialog_2);
        SashForm sashForm = new SashForm(top, 512);
        Composite groupRules = new Composite((Composite)sashForm, 0);
        Label boxLabel = new Label(groupRules, 0);
        boxLabel.setText(Messages.UnignoreComplexRuleDialog_3);
        Table rules = new Table(groupRules, 34816);
        int itemHeight = this.guessItemHeightFor((Control)rules);
        GridDataFactory.fillDefaults().hint(-1, itemHeight * (1 + this.rulesToRemove.size())).grab(true, true).applyTo((Control)rules);
        this.populateRuleBox(rules);
        GridLayoutFactory.fillDefaults().generateLayout(groupRules);
        Composite groupMatch = new Composite((Composite)sashForm, 65536);
        boxLabel = new Label(groupMatch, 0);
        boxLabel.setText(Messages.UnignoreComplexRuleDialog_4);
        this.matchBox = new Table(groupMatch, 34816);
        int itemHeight2 = this.guessItemHeightFor((Control)this.matchBox);
        GridDataFactory.fillDefaults().hint(-1, itemHeight2 * (1 + this.rulesToRemove.size())).grab(true, true).applyTo((Control)this.matchBox);
        this.statusMessageLabel = new CLabel(groupMatch, 0);
        GridLayoutFactory.fillDefaults().generateLayout(groupMatch);
        sashForm.setWeights(new int[]{1, 2});
        this.populateMatchBox();
        Dialog.applyDialogFont((Control)parent);
        layoutFactory.generateLayout(top);
        return top;
    }

    private void populateRuleBox(Table rules) {
        for (IIgnoreManager.IIgnoreReason reason : this.reasons) {
            TableItem item = new TableItem(rules, 0);
            for (IIgnoreProvider.IIgnoreRule rule : reason.getRules()) {
                if (!(rule instanceof IgnoreRule)) continue;
                if (reason.inherited()) {
                    assert (reason.inheritsFrom() != null);
                    item.setText(NLS.bind((String)Messages.UnignoreComplexRuleDialog_6, (Object)IgnoreUtils.describeRule((IIgnoreProvider.IIgnoreRule)rule), (Object)reason.inheritsFrom().getLocalPath()));
                    continue;
                }
                item.setText(IgnoreUtils.describeRule((IIgnoreProvider.IIgnoreRule)rule));
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateButtons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateButtons() {
        Object object = this.lock;
        synchronized (object) {
            if (this.matchBox.getItemCount() < this.collectedResourceCount) {
                return;
            }
            Button b = this.getButton(0);
            b.setEnabled(this.doneCollect);
        }
    }

    private void populateMatchBox() {
        this.collectJob = new Job(Messages.UnignoreComplexRuleDialog_7){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IgnoreUtils.findIgnoresForRules((Collection)UnignoreComplexRuleDialog.this.rulesToRemove, (IgnoreUtils.IIgnoredShareablesVisitor)new UnignoredController(), (IProgressMonitor)monitor);
                }
                catch (FileSystemException e) {
                    return new Status(4, "com.ibm.team.filesystem.ide.ui", Messages.UnignoreComplexRuleDialog_8);
                }
                Object object = UnignoreComplexRuleDialog.this.lock;
                synchronized (object) {
                    UnignoreComplexRuleDialog.this.doneCollect = true;
                }
                UnignoreComplexRuleDialog.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (UnignoreComplexRuleDialog.this.matchBox.isDisposed()) {
                            return;
                        }
                        UnignoreComplexRuleDialog.this.updateButtons();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        this.collectJob.schedule();
    }

    private int getMatchIndexFor(String path, int lowerBound, int upperBound) {
        Object object = this.lock;
        synchronized (object) {
            if (lowerBound == upperBound) {
                return upperBound;
            }
            int middleIndex = lowerBound + (upperBound - lowerBound) / 2;
            String otherText = this.matchBox.getItem(middleIndex).getText();
            int cmp = path.compareTo(otherText);
            if (lowerBound + 1 == upperBound) {
                if (cmp < 0) {
                    return lowerBound;
                }
                if (cmp > 0) {
                    return upperBound;
                }
            }
            if (cmp < 0) {
                return this.getMatchIndexFor(path, lowerBound, middleIndex);
            }
            if (cmp > 0) {
                return this.getMatchIndexFor(path, middleIndex, upperBound);
            }
            throw new IllegalStateException("Path already exists in matchBox: " + path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void warnAboutExtraItem(IShareable shareable) {
        Object object = this.lock;
        synchronized (object) {
            ++this.unselectedMatchedItemCount;
            String explanation = null;
            explanation = this.unselectedMatchedItemCount == 1 ? Messages.UnignoreComplexRuleDialog_10 : Messages.UnignoreComplexRuleDialog_11;
            this.statusMessageLabel.setText(NLS.bind((String)explanation, (Object)("" + this.unselectedMatchedItemCount)));
            if (this.unselectedMatchedItemCount == 1) {
                this.statusMessageLabel.setForeground(JFaceColors.getErrorText((Display)this.getShell().getDisplay()));
                this.statusMessageLabel.setImage(this.ICON_ERROR);
            }
        }
    }

    protected final Image getImage(ImageDescriptor descriptor) {
        Object o = this.resourceManager.find((DeviceResourceDescriptor)descriptor);
        if (o instanceof Image) {
            return (Image)o;
        }
        return this.resourceManager.createImageWithDefault(descriptor);
    }

    private int guessItemHeightFor(Control control) {
        FontData[] data = control.getFont().getFontData();
        int maxHeight = -1;
        FontData[] fontDataArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            FontData datum = fontDataArray[n2];
            maxHeight = Math.max(datum.getHeight(), maxHeight);
            ++n2;
        }
        return maxHeight;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.settings;
    }

    private class UnignoredController
    implements IgnoreUtils.IIgnoredShareablesVisitor {
        private UnignoredController() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitShareableIgnoredByRule(IIgnoreProvider.IIgnoreRule rule, final IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
            Object object = UnignoreComplexRuleDialog.this.lock;
            synchronized (object) {
                UnignoreComplexRuleDialog unignoreComplexRuleDialog = UnignoreComplexRuleDialog.this;
                unignoreComplexRuleDialog.collectedResourceCount = unignoreComplexRuleDialog.collectedResourceCount + 1;
            }
            final ResourceType type = shareable.getResourceType(monitor);
            UnignoreComplexRuleDialog.this.display.asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (UnignoreComplexRuleDialog.this.matchBox.isDisposed()) {
                        return;
                    }
                    Color missingColor = JFaceColors.getErrorText((Display)UnignoreComplexRuleDialog.this.display);
                    TableItem item = null;
                    Object object = UnignoreComplexRuleDialog.this.lock;
                    synchronized (object) {
                        item = new TableItem(UnignoreComplexRuleDialog.this.matchBox, 0, UnignoreComplexRuleDialog.this.getMatchIndexFor(shareable.getLocalPath().toString(), 0, UnignoreComplexRuleDialog.this.matchBox.getItemCount()));
                    }
                    String path = shareable.getLocalPath().toString();
                    item.setText(path);
                    ImageDescriptor image = null;
                    image = type == ResourceType.FOLDER ? UiPlugin.getFileSystemImageDescriptor(null) : (type == ResourceType.SYMBOLIC_LINK ? ImagePool.SYMBOLIC_LINK : UiPlugin.getFileSystemImageDescriptor(path));
                    item.setImage(UnignoreComplexRuleDialog.this.getImage(image));
                    if (!UnignoreComplexRuleDialog.this.toUnignore.contains(shareable)) {
                        item.setForeground(missingColor);
                        UnignoreComplexRuleDialog.this.warnAboutExtraItem(shareable);
                    }
                    UnignoreComplexRuleDialog.this.updateButtons();
                }
            });
        }

        public boolean shouldSkip(IIgnoreProvider.IIgnoreRule rule, IShareable shareable, IProgressMonitor progress) {
            return false;
        }
    }
}

