/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui;

import com.ibm.team.internal.filesystem.ui.Messages;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class TextBox
implements ModifyListener,
TraverseListener,
FocusListener,
Observer,
IControlContentAdapter {
    public static final String COMMENT_MODIFIED = "text.changed";
    public static final String OK_REQUESTED = "ok.requested";
    private final StyledText fTextField;
    private final String fMessage;
    private ListenerList listeners = new ListenerList();
    private String fText;

    public TextBox(Composite composite, int style, String message, String initialText) {
        this.fMessage = message;
        this.fText = initialText;
        AnnotationModel annotationModel = new AnnotationModel();
        DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
        Composite cc = new Composite(composite, 2048);
        cc.setLayout((Layout)new FillLayout());
        cc.setLayoutData((Object)new GridData(1808));
        final SourceViewer sourceViewer = new SourceViewer(cc, null, null, true, style);
        this.fTextField = sourceViewer.getTextWidget();
        this.fTextField.setIndent(2);
        final SourceViewerDecorationSupport support = new SourceViewerDecorationSupport((ISourceViewer)sourceViewer, null, (IAnnotationAccess)annotationAccess, EditorsUI.getSharedTextColors());
        Iterator e = new MarkerAnnotationPreferences().getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            support.setAnnotationPreference((AnnotationPreference)e.next());
        }
        support.install(EditorsUI.getPreferenceStore());
        final IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        final IHandlerActivation handlerActivation = this.installQuickFixActionHandler(handlerService, sourceViewer);
        final TextViewerAction cutAction = new TextViewerAction((ITextViewer)sourceViewer, 3);
        cutAction.setText(Messages.TextBox_2);
        cutAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
        final TextViewerAction copyAction = new TextViewerAction((ITextViewer)sourceViewer, 4);
        copyAction.setText(Messages.TextBox_3);
        copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        final TextViewerAction pasteAction = new TextViewerAction((ITextViewer)sourceViewer, 5);
        pasteAction.setText(Messages.TextBox_4);
        pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        final TextViewerAction selectAllAction = new TextViewerAction((ITextViewer)sourceViewer, 7);
        selectAllAction.setText(Messages.TextBox_5);
        selectAllAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        MenuManager contextMenu = new MenuManager();
        contextMenu.add((IAction)cutAction);
        contextMenu.add((IAction)copyAction);
        contextMenu.add((IAction)pasteAction);
        contextMenu.add((IAction)selectAllAction);
        contextMenu.add((IContributionItem)new Separator());
        final SubMenuManager quickFixMenu = new SubMenuManager((IMenuManager)contextMenu);
        quickFixMenu.setVisible(true);
        quickFixMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                quickFixMenu.removeAll();
                IAnnotationModel annotationModel = sourceViewer.getAnnotationModel();
                Iterator annotationIterator = annotationModel.getAnnotationIterator();
                while (annotationIterator.hasNext()) {
                    Annotation annotation = (Annotation)annotationIterator.next();
                    if (annotation.isMarkedDeleted() || !TextBox.this.includes(annotationModel.getPosition(annotation), sourceViewer.getTextWidget().getCaretOffset()) || !sourceViewer.getQuickAssistAssistant().canFix(annotation)) continue;
                    ICompletionProposal[] computeQuickAssistProposals = sourceViewer.getQuickAssistAssistant().getQuickAssistProcessor().computeQuickAssistProposals(sourceViewer.getQuickAssistInvocationContext());
                    int i = 0;
                    while (i < computeQuickAssistProposals.length) {
                        final ICompletionProposal proposal = computeQuickAssistProposals[i];
                        quickFixMenu.add((IAction)new Action(proposal.getDisplayString()){

                            public void run() {
                                proposal.apply(sourceViewer.getDocument());
                            }

                            public ImageDescriptor getImageDescriptor() {
                                if (proposal.getImage() != null) {
                                    return ImageDescriptor.createFromImage((Image)proposal.getImage());
                                }
                                return null;
                            }
                        });
                        ++i;
                    }
                }
            }
        });
        this.fTextField.addFocusListener(new FocusListener(){
            private IHandlerActivation cutHandlerActivation;
            private IHandlerActivation copyHandlerActivation;
            private IHandlerActivation pasteHandlerActivation;
            private IHandlerActivation selectAllHandlerActivation;

            public void focusGained(FocusEvent e) {
                cutAction.update();
                copyAction.update();
                IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                this.cutHandlerActivation = service.activateHandler("org.eclipse.ui.edit.cut", (IHandler)new ActionHandler((IAction)cutAction), (Expression)new ActiveShellExpression(TextBox.this.getComposite().getShell()));
                this.copyHandlerActivation = service.activateHandler("org.eclipse.ui.edit.copy", (IHandler)new ActionHandler((IAction)copyAction), (Expression)new ActiveShellExpression(TextBox.this.getComposite().getShell()));
                this.pasteHandlerActivation = service.activateHandler("org.eclipse.ui.edit.paste", (IHandler)new ActionHandler((IAction)pasteAction), (Expression)new ActiveShellExpression(TextBox.this.getComposite().getShell()));
                this.selectAllHandlerActivation = service.activateHandler("org.eclipse.ui.edit.selectAll", (IHandler)new ActionHandler((IAction)selectAllAction), (Expression)new ActiveShellExpression(TextBox.this.getComposite().getShell()));
            }

            public void focusLost(FocusEvent e) {
                IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                if (this.cutHandlerActivation != null) {
                    service.deactivateHandler(this.cutHandlerActivation);
                }
                if (this.copyHandlerActivation != null) {
                    service.deactivateHandler(this.copyHandlerActivation);
                }
                if (this.pasteHandlerActivation != null) {
                    service.deactivateHandler(this.pasteHandlerActivation);
                }
                if (this.selectAllHandlerActivation != null) {
                    service.deactivateHandler(this.selectAllHandlerActivation);
                }
            }
        });
        this.fTextField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                cutAction.update();
                copyAction.update();
            }
        });
        sourceViewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                support.uninstall();
                handlerService.deactivateHandler(handlerActivation);
            }
        });
        Document document = new Document(initialText);
        sourceViewer.configure((SourceViewerConfiguration)new TextSourceViewerConfiguration(EditorsUI.getPreferenceStore()));
        sourceViewer.setDocument((IDocument)document, (IAnnotationModel)annotationModel);
        this.fTextField.addTraverseListener((TraverseListener)this);
        this.fTextField.addModifyListener((ModifyListener)this);
        this.fTextField.addFocusListener((FocusListener)this);
        this.fTextField.setMenu(contextMenu.createContextMenu((Control)this.fTextField));
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void firePropertyChangeEvent(String property, Object old, Object newObj) {
        Object[] delegates = this.listeners.getListeners();
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, property, old, newObj);
        int i = 0;
        while (i < delegates.length) {
            IPropertyChangeListener listener = (IPropertyChangeListener)delegates[i];
            listener.propertyChange(event);
            ++i;
        }
    }

    public Composite getComposite() {
        return this.fTextField.getParent();
    }

    protected Shell getShell() {
        return this.fTextField.getShell();
    }

    protected boolean includes(Position position, int caretOffset) {
        return position.includes(caretOffset) || position.offset + position.length == caretOffset;
    }

    private IHandlerActivation installQuickFixActionHandler(IHandlerService handlerService, SourceViewer sourceViewer) {
        return handlerService.activateHandler("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals", (IHandler)this.createQuickFixActionHandler((ITextOperationTarget)sourceViewer), (Expression)new ActiveShellExpression(sourceViewer.getTextWidget().getShell()));
    }

    private ActionHandler createQuickFixActionHandler(final ITextOperationTarget textOperationTarget) {
        Action quickFixAction = new Action(){

            public void run() {
                textOperationTarget.doOperation(22);
            }
        };
        quickFixAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
        return new ActionHandler((IAction)quickFixAction);
    }

    public void modifyText(ModifyEvent e) {
        String old = this.fText;
        this.fText = this.fTextField.getText();
        this.firePropertyChangeEvent(COMMENT_MODIFIED, old, this.fText);
    }

    public void keyTraversed(TraverseEvent e) {
        if (e.detail == 4 && (e.stateMask & 0x40000) != 0) {
            e.doit = false;
            this.firePropertyChangeEvent(OK_REQUESTED, null, null);
        }
    }

    public void focusGained(FocusEvent e) {
        if (this.fText.length() > 0) {
            return;
        }
        this.fTextField.removeModifyListener((ModifyListener)this);
        try {
            this.fTextField.setText(this.fText);
        }
        finally {
            this.fTextField.addModifyListener((ModifyListener)this);
        }
    }

    public void focusLost(FocusEvent e) {
        if (this.fText.length() > 0) {
            return;
        }
        this.fTextField.removeModifyListener((ModifyListener)this);
        try {
            this.fTextField.setText(this.fMessage);
            this.fTextField.selectAll();
        }
        finally {
            this.fTextField.addModifyListener((ModifyListener)this);
        }
    }

    public void setEnabled(boolean enabled) {
        this.fTextField.setEnabled(enabled);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof String) {
            this.setText((String)arg);
        }
    }

    public String getText() {
        return this.fText;
    }

    public void setText(String text) {
        if (text.length() == 0) {
            this.fTextField.setText(this.fMessage);
            this.fTextField.selectAll();
        } else {
            this.fTextField.setText(text);
        }
    }

    public void setFocus() {
        this.fTextField.setFocus();
    }

    public String getControlContents(Control arg0) {
        return this.getText();
    }

    public int getCursorPosition(Control arg0) {
        return this.fTextField.getCaretOffset();
    }

    public Rectangle getInsertionBounds(Control arg0) {
        return this.fTextField.getBounds();
    }

    public void insertControlContents(Control arg0, String text, int arg2) {
        this.fTextField.setText(text);
    }

    public void setControlContents(Control arg0, String text, int arg2) {
        this.fTextField.setText(text);
    }

    public void setCursorPosition(Control arg0, int offset) {
        this.fTextField.setCaretOffset(offset);
    }

    private class TextViewerAction
    extends Action
    implements IUpdate {
        private int operationCode = -1;
        private ITextOperationTarget operationTarget;

        public TextViewerAction(ITextViewer viewer, int operationCode) {
            this.operationCode = operationCode;
            this.operationTarget = viewer.getTextOperationTarget();
            this.update();
        }

        public void update() {
            boolean wasEnabled = this.isEnabled();
            boolean isEnabled = this.operationTarget != null && this.operationTarget.canDoOperation(this.operationCode);
            this.setEnabled(isEnabled);
            if (wasEnabled != isEnabled) {
                this.firePropertyChange("enabled", wasEnabled ? Boolean.TRUE : Boolean.FALSE, isEnabled ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        public void run() {
            if (this.operationCode != -1 && this.operationTarget != null) {
                this.operationTarget.doOperation(this.operationCode);
            }
        }
    }
}

