/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.BaselineLabelProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.scm.common.IBaselineSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class SnapshotEditPart {
    private Text nameText;
    private Text commentText;
    private String nameName = "";
    private String commentName = "";
    private final IBaselineSet baselineSet;
    private Label creatorLabel;
    private final ITeamRepository repo;
    private final IStatusCollector statusCollector;
    private final IOpenEventListener openListener;
    private Button defaultButton;

    public SnapshotEditPart(IStatusCollector statusCollector, IOpenEventListener openListener) {
        this.statusCollector = statusCollector;
        this.openListener = openListener;
        this.repo = null;
        this.baselineSet = null;
    }

    public SnapshotEditPart(ITeamRepository repo, IBaselineSet baseline, IOpenEventListener openListener) {
        this.openListener = openListener;
        Assert.isNotNull((Object)repo);
        Assert.isNotNull((Object)baseline);
        this.repo = repo;
        this.baselineSet = baseline;
        this.statusCollector = null;
    }

    public Control createContents(Composite top) {
        Label label;
        Composite parent = new Composite(top, 0);
        GridDataFactory.fillDefaults().hint(-1, 150).grab(true, false).applyTo((Control)parent);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(parent);
        if (this.baselineSet != null) {
            label = new Label(parent, 0);
            label.setText(Messages.SnapshotEditPart_2);
            GridDataFactory.fillDefaults().applyTo((Control)label);
            this.creatorLabel = new Label(parent, 0);
            this.creatorLabel.setText(Messages.SnapshotEditPart_3);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.creatorLabel);
            label = new Label(parent, 0);
            label.setText(Messages.SnapshotEditPart_4);
            GridDataFactory.fillDefaults().applyTo((Control)label);
            label = new Label(parent, 0);
            label.setText(BaselineLabelProvider.getDate(this.baselineSet.getCreationDate()));
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
            final Display display = this.creatorLabel.getShell().getDisplay();
            new Job(Messages.SnapshotEditPart_5){

                protected IStatus run(IProgressMonitor monitor) {
                    String contributorName = Messages.SnapshotEditPart_6;
                    try {
                        IContributor contributor = (IContributor)SnapshotEditPart.this.repo.itemManager().fetchCompleteItem((IItemHandle)SnapshotEditPart.this.baselineSet.getCreator(), 0, monitor);
                        contributorName = NLS.bind((String)Messages.SnapshotEditPart_1, (Object)contributor.getName(), (Object)contributor.getUserId());
                    }
                    catch (TeamRepositoryException contributor) {
                        // empty catch block
                    }
                    final String contributorLabel = contributorName;
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (SnapshotEditPart.this.creatorLabel != null && !SnapshotEditPart.this.creatorLabel.isDisposed()) {
                                SnapshotEditPart.this.creatorLabel.setText(contributorLabel);
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
        label = new Label(parent, 0);
        label.setText(Messages.SnapshotEditPart_9);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.nameText = new Text(parent, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.nameText);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SnapshotEditPart.this.nameName = SnapshotEditPart.this.nameText.getText();
                SnapshotEditPart.this.updateEnablements();
            }
        });
        label = new Label(parent, 0);
        label.setText(Messages.SnapshotEditPart_10);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)label);
        this.commentText = new Text(parent, 2114);
        GridDataFactory.fillDefaults().hint(-1, 70).grab(true, false).span(2, 1).applyTo((Control)this.commentText);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 24: {
                        SnapshotEditPart.this.commentName = SnapshotEditPart.this.commentText.getText();
                        break;
                    }
                    case 31: {
                        if (e.character != '\r' || (e.stateMask & 0x40000) == 0) break;
                        Event event = new Event();
                        event.widget = e.widget;
                        SnapshotEditPart.this.openListener.handleOpen(new SelectionEvent(event));
                        break;
                    }
                    case 15: {
                        if (SnapshotEditPart.this.defaultButton == null) break;
                        SnapshotEditPart.this.commentText.getShell().setDefaultButton(null);
                        SnapshotEditPart.this.commentText.getShell().setDefaultButton(null);
                        break;
                    }
                    case 16: {
                        if (SnapshotEditPart.this.defaultButton == null) break;
                        SnapshotEditPart.this.commentText.getShell().setDefaultButton(SnapshotEditPart.this.defaultButton);
                    }
                }
            }
        };
        this.commentText.addListener(24, listener);
        this.commentText.addListener(31, listener);
        this.commentText.addListener(15, listener);
        this.commentText.addListener(16, listener);
        if (this.baselineSet != null) {
            this.nameText.setText(this.baselineSet.getName());
            this.commentText.setText(this.baselineSet.getComment());
            this.nameText.setEditable(false);
            this.commentText.setEditable(false);
        }
        if (this.statusCollector != null) {
            this.statusCollector.reportProblem(StatusUtil.newStatus((Object)this, (int)4, (String)""));
        }
        return parent;
    }

    public void updateEnablements() {
        if (this.statusCollector != null) {
            if (this.isNameValid()) {
                this.statusCollector.reportProblem(StatusUtil.newStatus((Object)this, (int)0, (String)""));
            } else {
                this.statusCollector.reportProblem(StatusUtil.newStatus((Object)this, (int)4, (String)Messages.SnapshotEditPart_12));
            }
        }
    }

    public boolean isNameValid() {
        return this.nameName != null && this.nameName.trim().length() > 0;
    }

    public boolean isValid() {
        return this.isNameValid();
    }

    public void setNameText(String name) {
        this.nameText.setText(name);
    }

    public void setCommentText(String comment) {
        this.commentText.setText(comment);
    }

    public String getName() {
        return this.nameName;
    }

    public String getComment() {
        return this.commentName;
    }

    public void setDefaultButton(Button button) {
        this.defaultButton = button;
    }
}

