/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui;

import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.internal.ClientProviderFactory;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.links.ChangeSetLinks;
import com.ibm.team.scm.common.providers.ProviderFactory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class LinkUtils {
    public static List<IItem> fetchDisplayReasonsFor(IChangeSetHandle changeSetHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repo = (ITeamRepository)changeSetHandle.getOrigin();
        List links = ChangeSetLinks.findLinks((ProviderFactory)new ClientProviderFactory(repo), (IChangeSetHandle)changeSetHandle, (String[])new String[]{"com.ibm.team.filesystem.workitems.change_set"}, (IProgressMonitor)monitor);
        ArrayList<IItem> reasons = new ArrayList();
        ArrayList<IItemHandle> reasonHandles = new ArrayList<IItemHandle>();
        for (ILink link : links) {
            IReference target = link.getTargetRef();
            if (!target.isItemReference()) continue;
            reasonHandles.add(((IItemReference)target).getReferencedItem());
        }
        reasons = repo.itemManager().fetchCompleteItems(reasonHandles, 0, monitor);
        return reasons;
    }

    public static List<IURIReference> fetchDisplayOslcLinksFor(IChangeSetHandle changeSetHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IURIReference> result = new ArrayList<IURIReference>();
        ITeamRepository repo = (ITeamRepository)changeSetHandle.getOrigin();
        List links = ChangeSetLinks.findLinks((ProviderFactory)new ClientProviderFactory(repo), (IChangeSetHandle)changeSetHandle, (String[])new String[]{"com.ibm.team.filesystem.oslc_cm.change_request.change_set"}, (IProgressMonitor)monitor);
        for (ILink link : links) {
            IReference ref = link.getTargetRef();
            if (!ref.isURIReference()) continue;
            result.add((IURIReference)ref);
        }
        return result;
    }

    public static String reasonsToHtml(List<IReference> reasons) {
        StringBuffer html = new StringBuffer();
        for (IReference reference : reasons) {
            if (reference.isURIReference()) {
                html.append("<a href=\"");
                html.append(reference.createURI());
                html.append("\" />");
                html.append(reference.getComment());
                html.append("</a>");
                continue;
            }
            if (reference.isItemReference()) {
                html.append("<a href=\"");
                html.append(reference.createURI());
                html.append("\" />");
                html.append(reference.getComment());
                html.append("</a>");
                continue;
            }
            html.append(String.valueOf(reference.getComment()) + "<br>");
        }
        return html.toString();
    }

    public static String reasonsPlainText(List<IReference> reasons) {
        StringBuffer html = new StringBuffer();
        for (IReference reference : reasons) {
            if (reference.isURIReference()) {
                html.append(reference.getComment());
                continue;
            }
            if (reference.isItemReference()) {
                html.append(reference.getComment());
                continue;
            }
            html.append(reference.getComment());
        }
        return html.toString();
    }
}

