/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.JazzIgnoreFile;
import com.ibm.team.filesystem.client.internal.utils.IgnoreUtils;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.internal.ImagePool;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class IgnorePatternDialog
extends TrayDialog {
    private List<IShareable> originallySelected;
    private List<IShareable> resultIgnored = null;
    private final DefaultIgnoreProvider ignoreProvider;
    private final IIgnoreManager ignoreManager;
    private static final String PREF_KEY = "IgnorePatternDialog";
    private static final String ACTION_KEY = "Action";
    private static final int ADD_NAME_ENTRY = 0;
    private static final int ADD_EXTENSION_ENTRY = 1;
    private static final int ADD_CUSTOM_ENTRY = 2;
    private IDialogSettings settings;
    private Button addNameEntryButton;
    private Button addExtensionEntryButton;
    private Button addCustomEntryButton;
    private Text customEntryText;
    private CLabel statusMessageLabel;
    private Button scopeLocalButton;
    private Button scopeRecursiveButton;
    private Combo scopeRootCombo;
    private int selectedAction;
    private boolean isRecursive;
    private String recursionRoot;
    private List<IgnoreRule> rules = null;
    private Table matchBox;
    private static final int LABEL_INDENT_WIDTH = 32;
    Object lock = new Object();
    private final Display display;
    private CollectJob collectJob = new CollectJob(Messages.IgnorePatternDialog_1);
    private LocalResourceManager resourceManager;
    private Image ICON_ERROR;
    private Image ICON_WARN;

    public IgnorePatternDialog(Shell shell, List<IShareable> shareables, IIgnoreManager ignoreManager, DefaultIgnoreProvider ignoresProvider) throws FileSystemException {
        super(shell);
        this.ignoreManager = ignoreManager;
        this.ignoreProvider = ignoresProvider;
        this.originallySelected = shareables;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.collectJob.setSystem(true);
        this.display = shell.getDisplay();
        IDialogSettings workbenchSettings = UiPlugin.getDefault().getDialogSettings();
        this.settings = workbenchSettings.getSection(PREF_KEY);
        if (this.settings == null) {
            this.settings = workbenchSettings.addNewSection(PREF_KEY);
        }
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)shell);
        this.ICON_WARN = JazzResources.getImageWithDefault((ResourceManager)this.resourceManager, (ImageDescriptor)ImagePool.WARN_ICON);
        this.ICON_ERROR = JazzResources.getImageWithDefault((ResourceManager)this.resourceManager, (ImageDescriptor)ImagePool.ERROR_ICON);
        try {
            this.selectedAction = this.settings.getInt(ACTION_KEY);
        }
        catch (NumberFormatException e) {
            this.selectedAction = 0;
        }
    }

    public List<IgnoreRule> getRules() {
        return this.rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IShareable> getIgnoreList() {
        Object object = this.lock;
        synchronized (object) {
            return this.resultIgnored;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.IgnorePatternDialog_4);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.onChange();
        this.validate();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        GridLayoutFactory layoutFactory = GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins());
        Composite top = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)top);
        Listener selectionListener = new Listener(){

            public void handleEvent(Event event) {
                IgnorePatternDialog.this.onChange();
            }
        };
        Listener modifyListener = new Listener(){

            public void handleEvent(Event event) {
                IgnorePatternDialog.this.validate();
            }
        };
        boolean isPlural = this.originallySelected.size() > 1;
        Group groupType = new Group(top, 0);
        groupType.setText(Messages.IgnorePatternDialog_5);
        this.addNameEntryButton = new Button((Composite)groupType, 16);
        this.addNameEntryButton.setText(isPlural ? Messages.IgnorePatternDialog_6 : Messages.IgnorePatternDialog_7);
        this.addNameEntryButton.addListener(13, selectionListener);
        this.addNameEntryButton.setSelection(this.selectedAction == 0);
        this.addExtensionEntryButton = this.createRadioButton((Composite)groupType, isPlural ? Messages.IgnorePatternDialog_8 : Messages.IgnorePatternDialog_9);
        this.addExtensionEntryButton.addListener(13, selectionListener);
        this.addExtensionEntryButton.setSelection(this.selectedAction == 1);
        this.createIndentedLabel((Composite)groupType, this.getMatchedExtensionText(), 32);
        this.addCustomEntryButton = this.createRadioButton((Composite)groupType, Messages.IgnorePatternDialog_10);
        this.addCustomEntryButton.addListener(13, selectionListener);
        this.addCustomEntryButton.setSelection(this.selectedAction == 2);
        this.createIndentedLabel((Composite)groupType, "*.htm*", 32);
        String text = "";
        if (this.originallySelected.size() > 0) {
            text = this.originallySelected.get(0).getLocalPath().getName();
        }
        this.customEntryText = this.createIndentedText((Composite)groupType, text, 32);
        this.customEntryText.addListener(24, modifyListener);
        layoutFactory.generateLayout((Composite)groupType);
        Group groupScope = new Group(top, 0);
        groupScope.setText(Messages.IgnorePatternDialog_13);
        this.scopeLocalButton = this.createRadioButton((Composite)groupScope, Messages.IgnorePatternDialog_14);
        this.scopeLocalButton.addListener(13, selectionListener);
        this.scopeLocalButton.setSelection(true);
        this.scopeRecursiveButton = this.createRadioButton((Composite)groupScope, Messages.IgnorePatternDialog_15);
        this.scopeRecursiveButton.addListener(13, selectionListener);
        this.scopeRootCombo = new Combo((Composite)groupScope, 8);
        this.scopeRootCombo.addListener(13, selectionListener);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalIndent = 32;
        this.scopeRootCombo.setLayoutData((Object)data);
        layoutFactory.generateLayout((Composite)groupScope);
        Group groupMatch = new Group(top, 0);
        groupMatch.setText(Messages.IgnorePatternDialog_16);
        this.matchBox = new Table((Composite)groupMatch, 2048);
        int itemHeight = this.guessItemHeightFor((Control)this.matchBox);
        GridDataFactory.fillDefaults().hint(-1, itemHeight * (1 + this.originallySelected.size())).grab(true, true).applyTo((Control)this.matchBox);
        this.statusMessageLabel = new CLabel((Composite)groupMatch, 0);
        layoutFactory.generateLayout((Composite)groupMatch);
        new PopulateScopeRootsJob().schedule();
        Dialog.applyDialogFont((Control)parent);
        layoutFactory.generateLayout(top);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.filesystem.ide.ui.dialog_addtoignorelist");
        return top;
    }

    private int guessItemHeightFor(Control control) {
        FontData[] data = control.getFont().getFontData();
        int maxHeight = -1;
        FontData[] fontDataArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            FontData datum = fontDataArray[n2];
            maxHeight = Math.max(datum.getHeight(), maxHeight);
            ++n2;
        }
        return maxHeight;
    }

    private String getMatchedExtensionText() {
        HashSet<String> patterns = new HashSet<String>(this.originallySelected.size());
        for (IShareable toIgnore : this.originallySelected) {
            patterns.add(IgnorePatternDialog.generateSuffixPatternFor(toIgnore));
        }
        StringBuffer buf = new StringBuffer();
        for (String pattern : patterns) {
            if (buf.length() > 0) {
                buf.append(Messages.IgnorePatternDialog_17);
            }
            buf.append(pattern);
        }
        return buf.toString();
    }

    protected void okPressed() {
        this.settings.put(ACTION_KEY, this.selectedAction);
        super.okPressed();
    }

    private Label createIndentedLabel(Composite parent, String text, int indent) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalIndent = indent;
        label.setLayoutData((Object)data);
        return label;
    }

    private Text createIndentedText(Composite parent, String text, int indent) {
        Text textbox = new Text(parent, 2048);
        textbox.setText(text);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalIndent = indent;
        textbox.setLayoutData((Object)data);
        return textbox;
    }

    private Button createRadioButton(Composite parent, String text) {
        Button button = new Button(parent, 16);
        button.setText(text);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)button);
        return button;
    }

    private void onChange() {
        boolean oldIsGlobal = this.isRecursive;
        int oldSelectedAction = this.selectedAction;
        String oldRecursionRoot = this.recursionRoot;
        this.isRecursive = this.scopeRecursiveButton.getSelection();
        this.scopeRootCombo.setEnabled(this.isRecursive);
        int index = this.scopeRootCombo.getSelectionIndex();
        if (index != -1) {
            this.recursionRoot = this.scopeRootCombo.getItem(index);
        }
        if (this.addNameEntryButton.getSelection()) {
            this.selectedAction = 0;
        } else if (this.addExtensionEntryButton.getSelection()) {
            this.selectedAction = 1;
        } else if (this.addCustomEntryButton.getSelection()) {
            this.selectedAction = 2;
        }
        this.customEntryText.setEnabled(this.selectedAction == 2);
        if (oldIsGlobal != this.isRecursive || oldSelectedAction != this.selectedAction || oldRecursionRoot != null && !oldRecursionRoot.equals(this.recursionRoot)) {
            this.validate();
        }
    }

    private static final String generateSuffixPatternFor(IShareable s) {
        IPath path = s.getLocalPath().toPath();
        String extension = path.getFileExtension();
        extension = extension == null || extension.length() == 0 ? path.lastSegment() : "*." + extension;
        return extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate() {
        this.collectJob.stop();
        ArrayList<IgnoreRule> localRules = null;
        List entries = (List)this.scopeRootCombo.getData();
        IShareable installationPoint = null;
        IShare share = null;
        if (this.isRecursive) {
            DirectoryEntry entry = (DirectoryEntry)entries.get(this.scopeRootCombo.getSelectionIndex());
            share = entry.getShare();
            installationPoint = share != null ? share.getSandbox().findShareable((IRelativeLocation)new RelativeLocation(entry.getPath().segments()), ResourceType.FOLDER) : entry.getSandbox().findShareable((IRelativeLocation)new RelativeLocation(entry.getPath().segments()), ResourceType.FOLDER);
        }
        localRules = new ArrayList<IgnoreRule>();
        for (IShareable shareable : this.originallySelected) {
            String pattern = null;
            if (installationPoint != null && !installationPoint.getSandbox().equals(shareable.getSandbox()) || share != null && !share.getPath().isPrefixOf(shareable.getLocalPath())) continue;
            if (this.selectedAction == 0) {
                pattern = shareable.getLocalPath().getName();
            } else if (this.selectedAction == 1) {
                pattern = IgnorePatternDialog.generateSuffixPatternFor(shareable);
            } else if (this.selectedAction == 2) {
                pattern = this.customEntryText.getText();
            }
            IShareable inst = installationPoint == null ? ((Shareable)shareable).getParent() : installationPoint;
            localRules.addAll(this.ignoreProvider.getIgnoreRulesFor(pattern, Collections.singletonList(inst), this.isRecursive));
        }
        IgnoreUtils.removeContainedRules(localRules);
        Object object = this.lock;
        synchronized (object) {
            this.rules = localRules;
        }
        this.collectJob.start();
        this.setStatus(Messages.IgnorePatternDialog_18);
        this.updateButtons();
    }

    private void setError(String text) {
        if (text == null) {
            this.statusMessageLabel.setText("");
            this.statusMessageLabel.setImage(null);
        } else {
            this.statusMessageLabel.setText(text);
            this.statusMessageLabel.setForeground(JFaceColors.getErrorText((Display)this.getShell().getDisplay()));
            this.statusMessageLabel.setImage(this.ICON_ERROR);
        }
    }

    private void setStatus(String text) {
        if (text == null) {
            this.statusMessageLabel.setText("");
            this.statusMessageLabel.setImage(null);
        } else {
            this.statusMessageLabel.setText(text);
            this.statusMessageLabel.setForeground(JFaceColors.getBannerForeground((Display)this.display));
            this.statusMessageLabel.setImage(null);
        }
    }

    private void setWarning(String text) {
        if (text == null) {
            this.statusMessageLabel.setText("");
            this.statusMessageLabel.setImage(null);
        } else {
            this.statusMessageLabel.setText(text);
            this.statusMessageLabel.setForeground(JFaceColors.getBannerForeground((Display)this.display));
            this.statusMessageLabel.setImage(this.ICON_WARN);
        }
    }

    private void showMatches(Collection<IShareable> wouldBeIgnored, List<IgnoreRule> rules, IProgressMonitor progress) throws FileSystemException {
        final TreeSet<MatchedShareable> items = new TreeSet<MatchedShareable>(new MatchedSharableComparator());
        ArrayList<IShareable> uncontained = new ArrayList<IShareable>();
        uncontained.addAll(this.originallySelected);
        for (IShareable wouldBe : wouldBeIgnored) {
            IRelativeLocation wouldBePath = wouldBe.getLocalPath();
            for (IShareable selected : this.originallySelected) {
                IRelativeLocation selectedPath = selected.getLocalPath();
                if (!wouldBePath.isPrefixOf(selectedPath) || wouldBePath.equals((Object)selectedPath)) continue;
                uncontained.remove(selected);
            }
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(uncontained.size() + wouldBeIgnored.size()));
        for (IShareable shareable : uncontained) {
            if (wouldBeIgnored.remove(shareable)) {
                items.add(new MatchedShareable(State.PROPER, shareable, (IProgressMonitor)monitor.newChild(1)));
                continue;
            }
            items.add(new MatchedShareable(State.MISSING, shareable, (IProgressMonitor)monitor.newChild(1)));
        }
        for (IShareable shareable : wouldBeIgnored) {
            items.add(new MatchedShareable(State.EXTRA, shareable, (IProgressMonitor)monitor.newChild(1)));
        }
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (IgnorePatternDialog.this.matchBox.isDisposed()) {
                    return;
                }
                Color extraColor = IgnorePatternDialog.this.display.getSystemColor(9);
                Color missingColor = JFaceColors.getErrorText((Display)IgnorePatternDialog.this.display);
                int properCount = 0;
                int missingCount = 0;
                int extraCount = 0;
                IgnorePatternDialog.this.matchBox.removeAll();
                for (MatchedShareable matched : items) {
                    String path;
                    if (missingCount > 0 && properCount == 0 && extraCount == 0 && matched.state != State.MISSING) {
                        TableItem separator = new TableItem(IgnorePatternDialog.this.matchBox, 2);
                        separator.setText("-------------------");
                    }
                    TableItem tableItem = new TableItem(IgnorePatternDialog.this.matchBox, 0);
                    String text = path = matched.shareable.getLocalPath().toString();
                    if (matched.resourceType == ResourceType.FOLDER) {
                        path = null;
                    }
                    switch (matched.state) {
                        case PROPER: {
                            tableItem.setImage(IgnorePatternDialog.this.getImage(UiPlugin.getFileSystemImageDescriptor(path)));
                            ++properCount;
                            break;
                        }
                        case MISSING: {
                            tableItem.setImage(IgnorePatternDialog.this.ICON_ERROR);
                            tableItem.setForeground(missingColor);
                            text = NLS.bind((String)Messages.IgnorePatternDialog_22, (Object)text);
                            ++missingCount;
                            break;
                        }
                        case EXTRA: {
                            tableItem.setImage(IgnorePatternDialog.this.getImage(UiPlugin.getFileSystemImageDescriptor(path)));
                            tableItem.setForeground(extraColor);
                            text = NLS.bind((String)Messages.IgnorePatternDialog_23, (Object)text);
                            ++extraCount;
                        }
                    }
                    tableItem.setText(text);
                }
                if (missingCount > 0) {
                    IgnorePatternDialog.this.setError(Messages.IgnorePatternDialog_24);
                } else if (extraCount > 0) {
                    IgnorePatternDialog.this.setWarning(Messages.IgnorePatternDialog_25);
                } else {
                    IgnorePatternDialog.this.setStatus(null);
                }
                IgnorePatternDialog.this.updateButtons();
            }
        });
    }

    protected final Image getImage(ImageDescriptor descriptor) {
        Object o = this.resourceManager.find((DeviceResourceDescriptor)descriptor);
        if (o instanceof Image) {
            return (Image)o;
        }
        return this.resourceManager.createImageWithDefault(descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateButtons() {
        boolean enable = false;
        Object object = this.lock;
        synchronized (object) {
            enable = this.resultIgnored != null;
        }
        this.getButton(0).setEnabled(enable);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.settings;
    }

    static /* synthetic */ List access$1(IgnorePatternDialog ignorePatternDialog) {
        return ignorePatternDialog.rules;
    }

    static /* synthetic */ List access$2(IgnorePatternDialog ignorePatternDialog) {
        return ignorePatternDialog.resultIgnored;
    }

    static /* synthetic */ void access$3(IgnorePatternDialog ignorePatternDialog, Collection collection, List list, IProgressMonitor iProgressMonitor) throws FileSystemException {
        ignorePatternDialog.showMatches(collection, list, iProgressMonitor);
    }

    private class CollectJob
    extends Job
    implements IgnoreUtils.IIgnoredShareablesVisitor {
        List<IShareable> wouldBeIgnored;
        IProgressMonitor cancelMonitor;
        long lastStartTime;
        long lastRequestTime;

        public CollectJob(String name) {
            super(name);
            this.cancelMonitor = null;
            this.lastStartTime = 0L;
            this.lastRequestTime = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        protected IStatus run(IProgressMonitor monitor) {
            block34: {
                this.wouldBeIgnored = new ArrayList<IShareable>();
                rules = null;
                var3_3 = IgnorePatternDialog.this.lock;
                synchronized (var3_3) {
                    IgnorePatternDialog.access$0(IgnorePatternDialog.this, null);
                    this.lastStartTime = this.lastRequestTime;
                    rules = IgnorePatternDialog.access$1(IgnorePatternDialog.this);
                    this.cancelMonitor = monitor;
                }
                IgnoreUtils.findIgnoresForRules((Collection)rules, (IgnoreUtils.IIgnoredShareablesVisitor)this, (IProgressMonitor)monitor);
                var3_3 = IgnorePatternDialog.this.lock;
                synchronized (var3_3) {
                    if (this.cancelMonitor != null && !monitor.isCanceled()) ** break block33
                    var5_5 = Status.CANCEL_STATUS;
                    // MONITOREXIT @DISABLED, blocks:[1, 2, 14] lbl22 : MonitorExitStatement: MONITOREXIT : var3_3
                    var6_7 = IgnorePatternDialog.this.lock;
                }
                synchronized (var6_7) {
                    this.cancelMonitor = null;
                    if (this.shouldRunAgain()) {
                        this.schedule(250L);
                    }
                }
                return var5_5;
                {
                    try {
                        try {
                            break block34;
                            {
                                catch (Throwable v2) {
                                    throw v2;
                                }
                            }
                        }
                        catch (FileSystemException e) {
                            var5_6 = FileSystemStatusUtil.getStatusFor((int)4, (String)"com.ibm.team.filesystem.ide.ui", (String)Messages.IgnorePatternDialog_3, (Throwable)e);
                            var6_8 = IgnorePatternDialog.this.lock;
                            synchronized (var6_8) {
                                this.cancelMonitor = null;
                                if (this.shouldRunAgain()) {
                                    this.schedule(250L);
                                }
                            }
                            return var5_6;
                        }
                    }
                    catch (Throwable var4_11) {
                        var6_9 = IgnorePatternDialog.this.lock;
                        synchronized (var6_9) {
                            this.cancelMonitor = null;
                            if (this.shouldRunAgain()) {
                                this.schedule(250L);
                            }
                        }
                        throw var4_11;
                    }
                }
            }
            var6_10 = IgnorePatternDialog.this.lock;
            synchronized (var6_10) {
                this.cancelMonitor = null;
                if (this.shouldRunAgain()) {
                    this.schedule(250L);
                }
            }
            e = IgnorePatternDialog.this.lock;
            synchronized (e) {
                IgnorePatternDialog.access$0(IgnorePatternDialog.this, new ArrayList<E>(this.wouldBeIgnored.size()));
                IgnorePatternDialog.access$2(IgnorePatternDialog.this).addAll(this.wouldBeIgnored);
            }
            progress = SubMonitor.convert((IProgressMonitor)monitor);
            progress.setWorkRemaining(10);
            try {
                IgnorePatternDialog.access$3(IgnorePatternDialog.this, this.wouldBeIgnored, rules, (IProgressMonitor)progress);
            }
            catch (FileSystemException e) {
                return FileSystemStatusUtil.getStatusFor((int)4, (String)"com.ibm.team.filesystem.ide.ui", (String)Messages.IgnorePatternDialog_0, (Throwable)e);
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void start() {
            Object object = IgnorePatternDialog.this.lock;
            synchronized (object) {
                this.lastRequestTime = this.lastStartTime + 1L;
                this.schedule(250L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void stop() {
            Object object = IgnorePatternDialog.this.lock;
            synchronized (object) {
                if (this.cancelMonitor != null) {
                    this.cancelMonitor.setCanceled(true);
                    this.cancelMonitor = null;
                }
                IgnorePatternDialog.this.resultIgnored = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean shouldRunAgain() {
            Object object = IgnorePatternDialog.this.lock;
            synchronized (object) {
                return this.lastRequestTime > this.lastStartTime;
            }
        }

        public void visitShareableIgnoredByRule(IIgnoreProvider.IIgnoreRule rule, IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
            this.wouldBeIgnored.add(shareable);
        }

        public boolean shouldSkip(IIgnoreProvider.IIgnoreRule rule, IShareable shareable, IProgressMonitor monitor) {
            return IgnorePatternDialog.this.ignoreManager.shouldBeIgnored(shareable, monitor);
        }
    }

    private static class DirectoryEntry {
        private final IPath path;
        private final IShare share;
        private final ISandbox sandbox;

        public DirectoryEntry(IPath path, IShare share, ISandbox sandbox) {
            this.path = path;
            this.share = share;
            this.sandbox = sandbox;
        }

        public IPath getPath() {
            return this.path;
        }

        public IShare getShare() {
            return this.share;
        }

        public ISandbox getSandbox() {
            return this.sandbox;
        }
    }

    private static class InverseCaseInsensitiveOrderComparator
    implements Comparator<IPath> {
        private InverseCaseInsensitiveOrderComparator() {
        }

        @Override
        public int compare(IPath p1, IPath p2) {
            String o2;
            String o1 = p1.toOSString();
            int result = String.CASE_INSENSITIVE_ORDER.compare(o1, o2 = p2.toOSString());
            if (result == 0) {
                return 0;
            }
            if (result < 0) {
                return 1;
            }
            return -1;
        }
    }

    private static class MatchedSharableComparator
    implements Comparator<MatchedShareable> {
        private MatchedSharableComparator() {
        }

        @Override
        public int compare(MatchedShareable o1, MatchedShareable o2) {
            int cmp = o1.state.compareTo(o2.state);
            if (cmp != 0) {
                return cmp;
            }
            IRelativeLocation o1Path = o1.shareable.getLocalPath();
            IRelativeLocation o2Path = o2.shareable.getLocalPath();
            return o1Path.toString().compareTo(o2Path.toString());
        }
    }

    private static class MatchedShareable {
        final State state;
        final IShareable shareable;
        final ResourceType resourceType;

        MatchedShareable(State state, IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
            this.state = state;
            this.shareable = shareable;
            this.resourceType = shareable.getResourceType(monitor);
        }
    }

    private class PopulateScopeRootsJob
    extends Job {
        PopulateScopeRootsJob() {
            super(Messages.IgnorePatternDialog_IGNORE_SCOPE_JOB_NAME);
            this.setSystem(true);
            this.setPriority(10);
        }

        private void populateScopeRootCombo(SubMonitor monitor) {
            TreeMap<IPath, DirectoryEntry> paths = new TreeMap<IPath, DirectoryEntry>(new InverseCaseInsensitiveOrderComparator());
            monitor.setWorkRemaining(IgnorePatternDialog.this.originallySelected.size() * 2);
            block4: for (IShareable shareable : IgnorePatternDialog.this.originallySelected) {
                IShare share;
                IPath path = shareable.getLocalPath().toPath();
                ISandbox sandbox = shareable.getSandbox();
                try {
                    share = shareable.getShare((IProgressMonitor)monitor.newChild(1));
                }
                catch (FileSystemException e) {
                    StatusUtil.log((Object)"com.ibm.team.filesystem.client", (Throwable)e);
                    continue;
                }
                int minSize = 1;
                if (share != null) {
                    minSize = share.getPath().segmentCount();
                }
                while (minSize < path.segmentCount()) {
                    if (paths.containsKey(path = path.removeLastSegments(1))) continue block4;
                    paths.put(path, new DirectoryEntry(path, share, sandbox));
                }
            }
            ArrayList<String> markedUpPaths = new ArrayList<String>(paths.size());
            final ArrayList<DirectoryEntry> shares = new ArrayList<DirectoryEntry>(paths.size());
            monitor.setWorkRemaining(paths.size() + 1);
            DefaultIgnoreProvider dip = DefaultIgnoreProvider.getDefault((IProgressMonitor)monitor.newChild(1));
            for (Map.Entry entry : paths.entrySet()) {
                IPath path = entry.getKey();
                JazzIgnoreFile jif = null;
                IShare share = ((DirectoryEntry)entry.getValue()).getShare();
                if (share != null) {
                    try {
                        jif = dip.getIgnoreFileForFolder(share.getSandbox(), (IRelativeLocation)new RelativeLocation(path.segments()), false, (IProgressMonitor)monitor.newChild(1));
                    }
                    catch (FileSystemException e) {
                        StatusUtil.log((Object)"com.ibm.team.filesystem.client", (Throwable)e);
                    }
                }
                String jifAnnotation = "";
                if (jif != null) {
                    int ruleCount = jif.getRules().size();
                    jifAnnotation = ruleCount == 1 ? NLS.bind((String)Messages.IgnorePatternDialog_RULE_COUNT_SINGULAR, (Object)ruleCount) : NLS.bind((String)Messages.IgnorePatternDialog_RULE_COUNT, (Object)ruleCount);
                }
                markedUpPaths.add(NLS.bind((String)Messages.IgnorePatternDialog_27, (Object)path.toOSString(), (Object)jifAnnotation));
                shares.add((DirectoryEntry)entry.getValue());
            }
            final String[] scopedStrings = markedUpPaths.toArray(new String[markedUpPaths.size()]);
            if (!IgnorePatternDialog.this.display.isDisposed()) {
                IgnorePatternDialog.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!IgnorePatternDialog.this.scopeRootCombo.isDisposed()) {
                            IgnorePatternDialog.this.scopeRootCombo.setItems(scopedStrings);
                            IgnorePatternDialog.this.scopeRootCombo.select(0);
                            IgnorePatternDialog.this.scopeRootCombo.setData((Object)shares);
                            IgnorePatternDialog.this.recursionRoot = scopedStrings[0];
                        }
                    }
                });
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.populateScopeRootCombo(SubMonitor.convert((IProgressMonitor)monitor));
            return Status.OK_STATUS;
        }
    }

    private static enum State {
        MISSING,
        EXTRA,
        PROPER;

    }
}

