/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.namespace.BaselineNamespace;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.PendingChangesUtil;
import com.ibm.team.internal.filesystem.ui.wizards.component.ComponentConfigurationPickerWizard;
import com.ibm.team.internal.filesystem.ui.wizards.component.PickBaselineChain;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.repository.rcp.ui.wizards.IRunnableWithResult;
import com.ibm.team.repository.rcp.ui.wizards.PageChain;
import com.ibm.team.repository.rcp.ui.wizards.WizardUtil;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Shell;

public class BaselineSelectionDialog {
    public static void getBaseline(final ComponentConfigurationPickerWizard.ConfigurationPickerInput baselinePickerInput, final UIContext context, final String pageDescription, final ItemNamespace namespace, final IPartResult<BaselineSelectionDialogResult> result) {
        context.getUserOperationRunner().enqueue(Messages.BaselineSelectionDialog_0, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                ItemId component = namespace.fetchComponentId((IProgressMonitor)progress.newChild(100));
                final IComponentHandle componentHandle = (IComponentHandle)component.toHandle();
                IWorkspaceHandle workspaceHandle = null;
                if (namespace instanceof WorkspaceNamespace) {
                    WorkspaceNamespace wn = (WorkspaceNamespace)namespace;
                    ItemId wid = wn.getWorkspaceId();
                    workspaceHandle = (IWorkspaceHandle)wid.toHandle();
                }
                final IWorkspaceHandle finalWorkspaceHandle = workspaceHandle;
                context.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkspaceHandle currentCollaboration = null;
                        if (finalWorkspaceHandle != null && componentHandle != null) {
                            currentCollaboration = PendingChangesUtil.getCurrentIncomingCollaboration(finalWorkspaceHandle, componentHandle);
                        }
                        BaselineSelectionDialog.getBaseline(baselinePickerInput, context, pageDescription, namespace.getRepository(), finalWorkspaceHandle, currentCollaboration, componentHandle, (IPartResult<BaselineSelectionDialogResult>)result);
                    }
                });
            }
        });
    }

    public static void getBaseline(ComponentConfigurationPickerWizard.ConfigurationPickerInput baselinePickerInput, UIContext context, String pageDescription, ITeamRepository repo, IWorkspaceHandle workspaceHandle, IWorkspaceHandle currentCollaboration, IComponentHandle component, final IPartResult<BaselineSelectionDialogResult> result) {
        final PickBaselineChain baselineChain = new PickBaselineChain(baselinePickerInput, repo, workspaceHandle, currentCollaboration, component);
        baselineChain.setBaselinePageDescription(pageDescription);
        WizardUtil.open((Shell)context.getShell(), (String)Messages.BaselineSelectionDialog_SelectBaselineDialogTitle, (String)IDialogConstants.FINISH_LABEL, (boolean)false, (PageChain)baselineChain, (IRunnableWithResult)new IRunnableWithResult<Boolean>(){

            public Boolean run() {
                result.setResult((Object)new BaselineSelectionDialogResult(baselineChain.getBaseline(), baselineChain.traverseBaselineHierarchy()));
                return true;
            }
        }, (String)"com.ibm.team.filesystem.ide.ui.wizard_selectbaseline");
    }

    public static class BaselineSelectionDialogResult {
        private final BaselineNamespace fBaselineNamespace;
        private final boolean fCreateBaselineHierarchy;

        public BaselineSelectionDialogResult(BaselineNamespace baselineNamespace, boolean createBaselineHierarchy) {
            this.fBaselineNamespace = baselineNamespace;
            this.fCreateBaselineHierarchy = createBaselineHierarchy;
        }

        public BaselineNamespace getBaselineNamespace() {
            return this.fBaselineNamespace;
        }

        public boolean isHierarchicalBaselineReplace() {
            return this.fCreateBaselineHierarchy;
        }
    }
}

