/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.wrapper;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.common.internal.util.ComponentHierarchyCompareResult;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.ILocalSynchronizationManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.PortsCacheManager;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentHierarchyData;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.IHierarchicalComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.TeamPlaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesComponentNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentHierarchyNode;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.util.Util;

public abstract class WorkspaceComponentWrapper
extends AbstractWrapper
implements IHierarchicalComponentWrapper {
    private final IWorkspaceConnection fWorkspaceConnection;
    private final IComponent fComponent;
    private Boolean fForcedCanAddSubcomponentsValue;
    private Boolean fForcedCanRemoveAsSubcomponentValue;
    protected Boolean fForcedCanRemoveComponentValue;
    private ComponentHierarchyData fHierarchyData;
    private ComponentHierarchyCompareResult.MovedComponentResult fMoveResult;
    private StructuralChangesComponentNode fStructuralChangesComponentNode;

    protected WorkspaceComponentWrapper(IWorkspaceConnection workspaceConnection, IComponent component) {
        super((IItem)component);
        Assert.isNotNull((Object)workspaceConnection, (String)"IWorkspaceConnection workspaceConnection cannot be null.");
        Assert.isNotNull((Object)component, (String)"IComponent component cannot be null.");
        this.fWorkspaceConnection = workspaceConnection;
        this.fComponent = component;
    }

    public static WorkspaceComponentWrapper newWrapper(IWorkspaceConnection ws, IComponent component) {
        if (ws.isStream()) {
            return new TeamPlaceComponentWrapper(ws, component);
        }
        return new ContributorPlaceComponentWrapper(ws, component);
    }

    public static WorkspaceComponentWrapper constructFrom(WorkspaceNamespace namespace, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRepository repo = namespace.getRepository();
        IWorkspaceConnection connection = namespace.getWorkspaceConnection((IProgressMonitor)progress.newChild(50));
        IComponent component = (IComponent)RepoFetcher.fetchCurrent((ITeamRepository)repo, (ItemId)namespace.getComponentId(), (IProgressMonitor)progress.newChild(50));
        return WorkspaceComponentWrapper.newWrapper(connection, component);
    }

    public static Set<WorkspaceComponentWrapper> getWrappersFromComponentHandles(IWorkspaceConnection workspace, Collection<IComponentHandle> componentHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet<WorkspaceComponentWrapper> wrappers = new HashSet<WorkspaceComponentWrapper>(componentHandles.size());
        ITeamRepository repo = workspace.teamRepository();
        IFetchResult result = repo.itemManager().fetchCompleteItemsPermissionAware(new ArrayList<IComponentHandle>(componentHandles), 0, monitor);
        for (Object o : result.getRetrievedItems()) {
            if (!(o instanceof IComponent)) continue;
            IComponent component = (IComponent)o;
            wrappers.add(WorkspaceComponentWrapper.newWrapper(workspace, component));
        }
        return wrappers;
    }

    public WorkspaceNamespace getNamespace() {
        return WorkspaceNamespace.create((IWorkspaceConnection)this.fWorkspaceConnection, (IComponentHandle)this.fComponent);
    }

    @Override
    public IComponent getComponent() {
        return this.fComponent;
    }

    @Override
    public IComponentHandle getComponentHandle() {
        return this.getComponent();
    }

    @Override
    public IComponentHandle getWrappedItemHandle() {
        return this.getComponentHandle();
    }

    @Override
    public ITeamRepository getRepository() {
        return this.fWorkspaceConnection.teamRepository();
    }

    @Override
    public IWorkspace getWorkspace() {
        return this.fWorkspaceConnection.getResolvedWorkspace();
    }

    @Override
    public IContextHandle getContextHandle() {
        return this.getWorkspace();
    }

    @Override
    public IWorkspaceConnection getWorkspaceConnection() {
        return this.fWorkspaceConnection;
    }

    @Override
    public IConnection getConnection(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getWorkspaceConnection();
    }

    public ComponentHierarchyData getHierarchyData() {
        return this.fHierarchyData;
    }

    @Override
    public void createHierarchyData(IComponentHierarchyNode node, IHierarchicalComponentWrapper parent) {
        Assert.isTrue((boolean)node.getComponentHandle().sameItemId((IItemHandle)this.fComponent), (String)"The component in hierarchyData cannot be different.");
        this.fHierarchyData = new ComponentHierarchyData(node, parent, this);
    }

    @Override
    public boolean canAddSubcomponents() {
        if (this.fForcedCanAddSubcomponentsValue == null) {
            return !this.getWorkspaceConnection().isStream() && FileSystemCore.getComponentHierarchyManager().isHierarchicalComponentsEnabled(this.getRepository()) && this.fHierarchyData != null;
        }
        return this.fForcedCanAddSubcomponentsValue;
    }

    @Override
    public boolean canRemoveAsSubcomponent() {
        if (this.fForcedCanRemoveAsSubcomponentValue == null) {
            return !this.getWorkspaceConnection().isStream() && this.fHierarchyData != null && !this.fHierarchyData.isRoot();
        }
        return this.fForcedCanRemoveAsSubcomponentValue;
    }

    public boolean isShared() {
        ILocalSynchronizationManager mgr = FileSystemResourcesPlugin.getComponentSyncModel().getLocalSynchronizationManager();
        return mgr.isShared((IWorkspaceHandle)this.getWorkspace(), (IComponentHandle)this.getComponent());
    }

    public boolean canOpenGapEditor() {
        boolean canOpenGapEditor = false;
        if (this.isShared()) {
            IWorkspaceConnection workspace = this.getWorkspaceConnection();
            IComponent component = this.getComponent();
            if (PortsCacheManager.getInstance().hasPortData(workspace.teamRepository(), (IWorkspaceHandle)workspace.getResolvedWorkspace(), (IComponentHandle)component)) {
                canOpenGapEditor = true;
            }
        }
        return canOpenGapEditor;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IComponent.class) {
            return this.fComponent;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof WorkspaceComponentWrapper)) {
            return false;
        }
        WorkspaceComponentWrapper other = (WorkspaceComponentWrapper)obj;
        if (!Util.equals((Object)this.fWorkspaceConnection, (Object)other.fWorkspaceConnection)) {
            return false;
        }
        if (this.fHierarchyData != null && other.fHierarchyData == null || this.fHierarchyData == null && other.fHierarchyData != null) {
            return false;
        }
        if (this.fHierarchyData != null && other.fHierarchyData != null) {
            if (!((IComponentHierarchyNode)this.fHierarchyData.getHierarchyNode()).getAncestorPath().equals(((IComponentHierarchyNode)other.fHierarchyData.getHierarchyNode()).getAncestorPath())) {
                return false;
            }
            if (((IComponentHierarchyNode)this.fHierarchyData.getHierarchyNode()).isBranchContainsCycles() != ((IComponentHierarchyNode)other.fHierarchyData.getHierarchyNode()).isBranchContainsCycles()) {
                return false;
            }
            if (((IComponentHierarchyNode)this.fHierarchyData.getHierarchyNode()).isInCycle() != ((IComponentHierarchyNode)other.fHierarchyData.getHierarchyNode()).isInCycle()) {
                return false;
            }
        }
        if (this.fMoveResult == null ? other.fMoveResult != null : !this.fMoveResult.equals(other.fMoveResult)) {
            return false;
        }
        if (this.fForcedCanAddSubcomponentsValue == null ? other.fForcedCanAddSubcomponentsValue != null : !this.fForcedCanAddSubcomponentsValue.equals(other.fForcedCanAddSubcomponentsValue)) {
            return false;
        }
        if (this.fForcedCanRemoveAsSubcomponentValue == null ? other.fForcedCanRemoveAsSubcomponentValue != null : !this.fForcedCanRemoveAsSubcomponentValue.equals(other.fForcedCanRemoveAsSubcomponentValue)) {
            return false;
        }
        if (this.fForcedCanRemoveComponentValue == null ? other.fForcedCanRemoveComponentValue != null : !this.fForcedCanRemoveComponentValue.equals(other.fForcedCanRemoveComponentValue)) {
            return false;
        }
        if (other.isLocked() != this.isLocked()) {
            return false;
        }
        return other.isLockedByMe() == this.isLockedByMe();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = prime * super.hashCode();
        result += Util.hashCode((Object)this.fWorkspaceConnection);
        if (this.fHierarchyData != null) {
            result += Util.hashCode((Object)((IComponentHierarchyNode)this.fHierarchyData.getHierarchyNode()).getAncestorPath());
        }
        result = prime * result + (this.fMoveResult == null ? 0 : this.fMoveResult.hashCode());
        result = prime * result + (this.fForcedCanAddSubcomponentsValue == null ? 0 : this.fForcedCanAddSubcomponentsValue.hashCode());
        result = prime * result + (this.fForcedCanRemoveAsSubcomponentValue == null ? 0 : this.fForcedCanRemoveAsSubcomponentValue.hashCode());
        result = prime * result + (this.fForcedCanRemoveComponentValue == null ? 0 : this.fForcedCanRemoveComponentValue.hashCode());
        return result;
    }

    public boolean isLocked() {
        return this.getWorkspaceConnection().isLocked(this.getComponentHandle());
    }

    public boolean isLockedByMe() {
        return this.getWorkspaceConnection().isLockedByMe(this.getComponentHandle());
    }

    public String getLockOwnerLabel() {
        if (this.isLockedByMe()) {
            return Messages.TeamPlaceWrapper_owner_me;
        }
        return this.getWorkspaceConnection().getLockOwnerName(this.getComponentHandle());
    }

    @Override
    public void setMoveResult(ComponentHierarchyCompareResult.MovedComponentResult result) {
        this.fMoveResult = result;
    }

    @Override
    public ComponentHierarchyCompareResult.MovedComponentResult getMoveResult() {
        return this.fMoveResult;
    }

    @Override
    public void setForcedCanAddSubcomponentsValue(Boolean value) {
        this.fForcedCanAddSubcomponentsValue = value;
    }

    @Override
    public void setForcedCanRemoveAsSubcomponentValue(Boolean value) {
        this.fForcedCanRemoveAsSubcomponentValue = value;
    }

    @Override
    public void setForcedCanRemoveComponentValue(Boolean value) {
        this.fForcedCanRemoveComponentValue = value;
    }

    @Override
    public void setStructuralChangesComponentNode(StructuralChangesComponentNode node) {
        this.fStructuralChangesComponentNode = node;
    }

    @Override
    public StructuralChangesComponentNode getStructuralChangesComponentNode() {
        return this.fStructuralChangesComponentNode;
    }
}

