/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.wrapper;

import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.scm.common.IWorkspace;

public class TeamPlaceWrapper
extends AbstractPlaceWrapper {
    protected TeamPlaceWrapper(ITeamRepository repo, IWorkspace workspace) {
        super(repo, workspace);
    }

    public boolean isLocked() {
        return this.getWorkspace().isLocked();
    }

    public String getStreamLockOwnerLabel() {
        if (this.isStreamLockedByMe()) {
            return Messages.TeamPlaceWrapper_owner_me;
        }
        return this.getWorkspace().getLockOwnerName();
    }

    public boolean isStreamLockedByMe() {
        if (!this.isLocked()) {
            return false;
        }
        IContributor loggedInContributor = this.getRepository().loggedInContributor();
        if (loggedInContributor == null) {
            return false;
        }
        return loggedInContributor.getItemId().getUuidValue().equals(this.getWorkspace().getLockOwnerItemID());
    }
}

