/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.wrapper;

import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import org.eclipse.core.runtime.Assert;

public class SnapshotComponentWrapper
extends AbstractWrapper {
    private IWorkspaceConnection workspaceConnection;
    private IComponent component;
    private IBaseline baseline;
    private final IBaselineSet bset;

    public SnapshotComponentWrapper(IWorkspaceConnection workspaceConn, IComponent component, IBaseline baseline, IBaselineSet bset) {
        super((IItem)baseline);
        Assert.isNotNull((Object)component);
        Assert.isNotNull((Object)baseline);
        Assert.isNotNull((Object)bset);
        this.baseline = baseline;
        this.bset = bset;
        this.workspaceConnection = workspaceConn;
        this.component = component;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IComponent.class) {
            return this.component;
        }
        if (adapter == IBaseline.class) {
            return this.baseline;
        }
        return super.getAdapter(adapter);
    }

    public IWorkspace getWorkspace() {
        return this.workspaceConnection.getResolvedWorkspace();
    }

    public IWorkspaceConnection getWorkspaceConnection() {
        return this.workspaceConnection;
    }

    public IComponent getComponent() {
        return this.component;
    }

    public IBaseline getBaseline() {
        return this.baseline;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SnapshotComponentWrapper)) {
            return false;
        }
        SnapshotComponentWrapper other = (SnapshotComponentWrapper)((Object)obj);
        return this.bset.sameItemId((IItemHandle)other.bset) && this.component.sameItemId((IItemHandle)other.component);
    }

    @Override
    public ITeamRepository getRepository() {
        return this.workspaceConnection.teamRepository();
    }
}

